/*
 * Decompiled with CFR 0.152.
 */
package com.schinkennugget;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.schinkennugget.Blockabulary;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class BlockabularyStats {
    private static final Gson GSON_WRITER = new GsonBuilder().setPrettyPrinting().create();
    private static final Gson GSON_READER = new Gson();
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir();
    private static final File STATS_FILE = CONFIG_DIR.resolve("blockabulary_stats.json").toFile();
    private static int totalQuestions;
    private static int rightAnswers;
    private static int wrongCapitalization0;
    private static int wrongCapitalization1;
    private static int wrongCapitalization2;
    private static int wrongAnswers;
    private static int skippedQuestions;

    public static void init() {
        if (!STATS_FILE.exists()) {
            BlockabularyStats.createDefaultStatsFile();
        }
    }

    private static void createDefaultStatsFile() {
        try {
            if (!STATS_FILE.getParentFile().exists()) {
                STATS_FILE.getParentFile().mkdirs();
            }
            String defaultStatsFile = "{\n  \"stats\": [\n    {\n      \"totalQuestions\": 0,\n      \"rightAnswers\": 0,\n      \"wrongCapitalization0\": 0,\n      \"wrongCapitalization1\": 0,\n      \"wrongCapitalization2\": 0,\n      \"wrongAnswers\": 0,\n      \"skippedQuestions\": 0\n    }\n  ]\n}";
            FileWriter writer = new FileWriter(STATS_FILE);
            writer.write(defaultStatsFile);
            writer.close();
            System.out.println("Default stats file created: " + STATS_FILE.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadStats() {
        try (FileReader reader = new FileReader(STATS_FILE);){
            JsonObject jsonObject = (JsonObject)GSON_READER.fromJson((Reader)reader, JsonObject.class);
            JsonArray statsArray = jsonObject.getAsJsonArray("stats");
            if (statsArray != null && !statsArray.isEmpty()) {
                JsonObject stats = statsArray.get(0).getAsJsonObject();
                totalQuestions = stats.get("totalQuestions").getAsInt();
                rightAnswers = stats.get("rightAnswers").getAsInt();
                wrongCapitalization0 = stats.get("wrongCapitalization0").getAsInt();
                wrongCapitalization1 = stats.get("wrongCapitalization1").getAsInt();
                wrongCapitalization2 = stats.get("wrongCapitalization2").getAsInt();
                wrongAnswers = stats.get("wrongAnswers").getAsInt();
                skippedQuestions = stats.get("skippedQuestions").getAsInt();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getTotalQuestions() {
        BlockabularyStats.loadStats();
        return totalQuestions;
    }

    public static int getRightAnswers() {
        BlockabularyStats.loadStats();
        return rightAnswers;
    }

    public static int getWrongCapitalization0() {
        BlockabularyStats.loadStats();
        return wrongCapitalization0;
    }

    public static int getWrongCapitalization1() {
        BlockabularyStats.loadStats();
        return wrongCapitalization1;
    }

    public static int getWrongCapitalization2() {
        BlockabularyStats.loadStats();
        return wrongCapitalization2;
    }

    public static int getWrongAnswers() {
        BlockabularyStats.loadStats();
        return wrongAnswers;
    }

    public static int getSkippedQuestions() {
        BlockabularyStats.loadStats();
        return skippedQuestions;
    }

    public static void setStats(String key, int newValue) {
        try {
            FileReader reader = new FileReader(STATS_FILE);
            JsonObject root = (JsonObject)GSON_WRITER.fromJson((Reader)reader, JsonObject.class);
            reader.close();
            JsonArray statsArray = root.getAsJsonArray("stats");
            if (statsArray != null && !statsArray.isEmpty()) {
                JsonObject stats = statsArray.get(0).getAsJsonObject();
                if (stats.has(key)) {
                    stats.addProperty(key, (Number)newValue);
                    Blockabulary.LOGGER.info("Updated " + key + " to " + newValue);
                } else {
                    Blockabulary.LOGGER.info(key + " does not exist");
                }
                FileWriter writer = new FileWriter(STATS_FILE);
                GSON_WRITER.toJson((JsonElement)root, (Appendable)writer);
                writer.flush();
                writer.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

