/*
 * Decompiled with CFR 0.152.
 */
package com.schinkennugget;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.schinkennugget.Blockabulary;
import com.schinkennugget.BlockabularyChatMessages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;

@Environment(value=EnvType.CLIENT)
public class BlockabularyFileManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir();
    private static final File VOCAB_FILE = CONFIG_DIR.resolve("vocab.json").toFile();
    private static final File TXT_FILE = CONFIG_DIR.resolve("vocab.txt").toFile();
    public static List<Map<String, String>> dataFromJson;
    public static List<Map<String, String>> orderedData;
    public static String currentQuestion;
    public static String currentAnswer;
    private static Map<String, String> selected;

    public static void init() {
        BlockabularyFileManager.loadVocab();
    }

    private static void createDefaultConfig() {
        try {
            if (!VOCAB_FILE.getParentFile().exists()) {
                VOCAB_FILE.getParentFile().mkdirs();
            }
            String defaultJson = "{\n  \"dataFromTxt\": [\n    {\n      \"question\": \"The config-file for Blockabulary is empty.\",\n      \"answer\": \"\",\n      \"timesAsked\": \"0\",\n      \"timesAnsweredCorrectly\": \"0\"\n    },\n    {\n      \"question\": \"The config-file for Blockabulary is empty.\",\n      \"answer\": \"\",\n      \"timesAsked\": \"0\",\n      \"timesAnsweredCorrectly\": \"0\"\n    }\n  ]\n}";
            FileWriter writer = new FileWriter(VOCAB_FILE);
            writer.write(defaultJson);
            writer.close();
            Blockabulary.LOGGER.info("Default config file created: " + VOCAB_FILE.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadVocab() {
        System.out.println("executing loadVocab");
        try {
            FileReader reader = new FileReader(VOCAB_FILE);
            Type type = new TypeToken<Map<String, List<Map<String, String>>>>(){}.getType();
            Map data = (Map)GSON.fromJson((Reader)reader, type);
            reader.close();
            dataFromJson = (List)data.get("data");
        }
        catch (IOException e) {
            e.printStackTrace();
            Blockabulary.LOGGER.info("vocab.json file was not found");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadTxt() {
        if (!TXT_FILE.exists()) return class_1074.method_4662((String)"message.blockabulary.no_txt_found", (Object[])new Object[0]);
        if (VOCAB_FILE.exists()) return class_1074.method_4662((String)"message.blockabulary.cant_overwrite_vocab", (Object[])new Object[0]);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(TXT_FILE));
            try {
                String line;
                ArrayList<String> dataFromTxt = new ArrayList<String>();
                ArrayList<Map<String, String>> dataForJson = new ArrayList<Map<String, String>>();
                Object info = "";
                int numberOfDataLoaded = 0;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().isEmpty()) continue;
                    dataFromTxt.add(line.trim());
                }
                for (int i = 0; i < dataFromTxt.size() - 1; ++numberOfDataLoaded, i += 2) {
                    String question = (String)dataFromTxt.get(i);
                    String answer = (String)dataFromTxt.get(i + 1);
                    HashMap<String, String> entry = new HashMap<String, String>();
                    entry.put("question", question);
                    entry.put("answer", answer);
                    entry.put("timesAsked", "0");
                    entry.put("timesAnsweredCorrectly", "0");
                    dataForJson.add(entry);
                    info = (String)info + "Loaded question " + question + "\nLoaded answer " + answer + "\n\n";
                }
                HashMap<String, ArrayList<Map<String, String>>> finalData = new HashMap<String, ArrayList<Map<String, String>>>();
                finalData.put("data", dataForJson);
                try (FileWriter writer = new FileWriter(VOCAB_FILE);){
                    GSON.toJson(finalData, (Appendable)writer);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    String string = "Failed to write the json file, because it wasn't found";
                    reader.close();
                    return string;
                }
                dataFromJson = dataForJson;
                String string = (String)info + "Loaded and saved " + numberOfDataLoaded + " questions and answers";
                return string;
            }
            finally {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    Throwable throwable;
                    throwable.addSuppressed(throwable2);
                }
            }
        }
        catch (IOException e) {
            Blockabulary.LOGGER.info("vocab.txt file could not be loaded, because it wasn't found.");
            e.printStackTrace();
            return class_1074.method_4662((String)"message.blockabulary.no_txt_found", (Object[])new Object[0]) + " and you managed to throw an IOException, how tf did you do that";
        }
    }

    public static List<Map<String, String>> getOrderedData() {
        if (orderedData == null) {
            BlockabularyFileManager.loadVocab();
            System.out.println("ececuting getOrderedData() (oben)");
            orderedData = new ArrayList<Map<String, String>>(dataFromJson);
            Collections.shuffle(orderedData);
        }
        System.out.println("ececuting getOrderedData()");
        System.out.println(orderedData);
        return orderedData;
    }

    public static String getQuestion() {
        System.out.println("executing getQuestion()");
        BlockabularyFileManager.loadVocab();
        if (dataFromJson == null || dataFromJson.isEmpty()) {
            return "vocab.json is empty or does not exist";
        }
        selected = BlockabularyFileManager.getOrderedData().get(0);
        if (orderedData == null || orderedData.isEmpty()) {
            return "An error occured. The vocab could not be loaded. (Error 43)";
        }
        for (int i = 0; i < orderedData.size(); ++i) {
            if (orderedData.get(i) != null) continue;
            return "An error occurred. The vocab could not be loaded correctly. (Error 42." + i + ")";
        }
        currentQuestion = selected.get("question");
        currentAnswer = selected.get("answer");
        System.out.println("ende: " + String.valueOf(orderedData));
        return currentQuestion;
    }

    public static void reorderData(int newOrder) {
        if (newOrder < 0) {
            orderedData.remove(0);
            if (orderedData == null || orderedData.isEmpty()) {
                BlockabularyChatMessages.sendLocalMessage(class_1074.method_4662((String)"message.blockabulary.finished_stack", (Object[])new Object[0]));
            }
        } else if (newOrder <= orderedData.size()) {
            orderedData.remove(0);
            orderedData.add(newOrder, selected);
        } else {
            orderedData.remove(0);
            orderedData.add(orderedData.size(), selected);
        }
    }

    public static void writeQuestionStats(boolean right) {
        BlockabularyFileManager.loadVocab();
        if (dataFromJson.contains(selected)) {
            ArrayList<Map<String, String>> dataForJson = new ArrayList<Map<String, String>>(dataFromJson);
            dataForJson.remove(selected);
            selected.replace("timesAsked", String.valueOf(Integer.valueOf(selected.get("timesAsked") + "1")));
            if (right) {
                selected.replace("timesAnsweredCorrectly", String.valueOf(Integer.valueOf(selected.get("timesAnsweredCorrectly") + "1")));
            }
            dataForJson.add(selected);
            HashMap<String, ArrayList<Map<String, String>>> finalData = new HashMap<String, ArrayList<Map<String, String>>>();
            finalData.put("data", dataForJson);
            try (FileWriter writer = new FileWriter(VOCAB_FILE);){
                GSON.toJson(finalData, (Appendable)writer);
                writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.err.println("Failed to write the json file, because it wasn't found");
            }
        }
    }

    static {
        currentQuestion = null;
        currentAnswer = null;
    }
}

