/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.betterfishtanksmod.block.entity;

import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.mint_gaming_studios.betterfishtanksmod.block.entity.ModBlockEntities;
import net.mint_gaming_studios.betterfishtanksmod.item.ModItems;
import net.mint_gaming_studios.betterfishtanksmod.loot.FishClassLootManager;
import net.mint_gaming_studios.betterfishtanksmod.recipe.AquaristTableRecipes;
import net.mint_gaming_studios.betterfishtanksmod.screen.AquaristTableMenu;
import net.mint_gaming_studios.betterfishtanksmod.screen.guitype.GuiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AquaristTableBlockEntity
extends BlockEntity
implements MenuProvider,
WorldlyContainer {
    private GuiType guiType = GuiType.DECO;
    private final ItemStackHandler itemHandler = new ItemStackHandler(7);
    private LazyOptional<IItemHandler> lazyItemHandler;
    protected final ContainerData data;
    private int progress = 0;
    private int maxProgress = 300;
    private int selectedRecipeIndex = -1;
    private final Random random = new Random();

    public AquaristTableBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.AQUARIST_TABLE_BE.get(), pPos, pBlockState);
        this.data = new ContainerData(){

            public int m_6413_(int pIndex) {
                return switch (pIndex) {
                    case 0 -> AquaristTableBlockEntity.this.progress;
                    case 1 -> AquaristTableBlockEntity.this.maxProgress;
                    case 2 -> AquaristTableBlockEntity.this.selectedRecipeIndex;
                    default -> 0;
                };
            }

            public void m_8050_(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        AquaristTableBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        AquaristTableBlockEntity.this.maxProgress = pValue;
                        break;
                    }
                    case 2: {
                        AquaristTableBlockEntity.this.setRecipeIndex(pValue);
                    }
                }
            }

            public int m_6499_() {
                return 3;
            }
        };
        this.lazyItemHandler = LazyOptional.of(() -> new IItemHandler(){

            public int getSlots() {
                return AquaristTableBlockEntity.this.itemHandler.getSlots();
            }

            @NotNull
            public ItemStack getStackInSlot(int slot) {
                boolean isRelevantSlot = false;
                if (AquaristTableBlockEntity.this.guiType == GuiType.FOOD) {
                    isRelevantSlot = slot == 0 || slot == 1 || slot == 2;
                } else if (AquaristTableBlockEntity.this.guiType == GuiType.EGG) {
                    isRelevantSlot = slot == 3 || slot == 4;
                } else if (AquaristTableBlockEntity.this.guiType == GuiType.DECO) {
                    isRelevantSlot = false;
                }
                if (isRelevantSlot) {
                    return AquaristTableBlockEntity.this.itemHandler.getStackInSlot(slot);
                }
                return ItemStack.f_41583_;
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                boolean canInsert = false;
                if (AquaristTableBlockEntity.this.guiType == GuiType.FOOD) {
                    canInsert = slot == 0 || slot == 1;
                } else if (AquaristTableBlockEntity.this.guiType == GuiType.EGG) {
                    canInsert = slot == 3;
                } else if (AquaristTableBlockEntity.this.guiType == GuiType.DECO) {
                    canInsert = false;
                }
                if (canInsert && this.isItemValid(slot, stack)) {
                    return AquaristTableBlockEntity.this.itemHandler.insertItem(slot, stack, simulate);
                }
                return stack;
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                boolean canExtract = false;
                if (AquaristTableBlockEntity.this.guiType == GuiType.FOOD) {
                    canExtract = slot == 2;
                } else if (AquaristTableBlockEntity.this.guiType == GuiType.EGG) {
                    canExtract = slot == 4;
                } else if (AquaristTableBlockEntity.this.guiType == GuiType.DECO) {
                    canExtract = false;
                }
                if (canExtract) {
                    return AquaristTableBlockEntity.this.itemHandler.extractItem(slot, amount, simulate);
                }
                return ItemStack.f_41583_;
            }

            public int getSlotLimit(int slot) {
                return AquaristTableBlockEntity.this.itemHandler.getSlotLimit(slot);
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (AquaristTableBlockEntity.this.guiType == GuiType.FOOD) {
                    if (slot == 0) {
                        return stack.m_150930_(Items.f_42576_) || stack.m_150930_(Items.f_42530_) || stack.m_150930_(Items.f_42531_) || stack.m_150930_((Item)ModItems.MINI_SHRIMP_RAW.get()) || stack.m_150930_((Item)ModItems.PELLET_MIX.get());
                    }
                    if (slot == 1) {
                        return stack.m_150930_((Item)ModItems.FOOD_CONTAINER.get());
                    }
                } else if (AquaristTableBlockEntity.this.guiType == GuiType.EGG && slot == 3) {
                    return AquaristTableBlockEntity.this.getFishClassForEgg(stack.m_41720_()) != null;
                }
                return false;
            }
        });
    }

    private String getFishClassForEgg(Item eggItem) {
        if (eggItem == ModItems.COMMON_FISH_EGG.get()) {
            return "common";
        }
        if (eggItem == ModItems.UNCOMMON_FISH_EGG.get()) {
            return "uncommon";
        }
        if (eggItem == ModItems.RARE_FISH_EGG.get()) {
            return "rare";
        }
        if (eggItem == ModItems.EPIC_FISH_EGG.get()) {
            return "epic";
        }
        if (eggItem == ModItems.EXOTIC_FISH_EGG.get()) {
            return "exotic";
        }
        if (eggItem == ModItems.LEGENDARY_FISH_EGG.get()) {
            return "legendary";
        }
        return null;
    }

    public GuiType getGuiType() {
        return this.guiType;
    }

    public void setGuiType(GuiType guiType) {
        this.guiType = guiType;
        this.m_6596_();
    }

    public void setRecipeIndex(int index) {
        this.selectedRecipeIndex = index < -1 ? -1 : index;
        if (this.guiType == GuiType.DECO) {
            this.updateDecoOutput();
        }
        this.m_6596_();
    }

    public int getRecipeIndex() {
        return this.selectedRecipeIndex;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.lazyItemHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.lazyItemHandler.invalidate();
    }

    protected void m_183515_(CompoundTag nbt) {
        nbt.m_128365_("inventory", (Tag)this.itemHandler.serializeNBT());
        nbt.m_128405_("aquarist_table.gui_type", this.guiType.ordinal());
        nbt.m_128405_("aquarist_table.progress", this.progress);
        nbt.m_128405_("aquarist_table.selected_recipe", this.selectedRecipeIndex);
        super.m_183515_(nbt);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.itemHandler.deserializeNBT(nbt.m_128469_("inventory"));
        if (nbt.m_128441_("aquarist_table.gui_type")) {
            this.guiType = GuiType.values()[nbt.m_128451_("aquarist_table.gui_type")];
        }
        this.progress = nbt.m_128451_("aquarist_table.progress");
        this.selectedRecipeIndex = nbt.m_128441_("aquarist_table.selected_recipe") ? nbt.m_128451_("aquarist_table.selected_recipe") : -1;
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128405_("aquarist_table.gui_type", this.guiType.ordinal());
        return nbt;
    }

    public void handleUpdateTag(CompoundTag nbt) {
        super.handleUpdateTag(nbt);
        if (nbt.m_128441_("aquarist_table.gui_type")) {
            this.guiType = GuiType.values()[nbt.m_128451_("aquarist_table.gui_type")];
        }
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.m_6836_(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.f_58858_, (Container)inventory);
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (pLevel.m_5776_()) {
            return;
        }
        if (this.guiType == GuiType.FOOD || this.guiType == GuiType.EGG) {
            if (this.hasRecipe()) {
                this.maxProgress = this.guiType == GuiType.EGG ? 2400 : 300;
                ++this.progress;
                this.m_6596_();
                if (this.progress >= this.maxProgress) {
                    this.craftItem();
                    this.resetProgress();
                }
            } else {
                this.resetProgress();
                this.m_6596_();
            }
        } else if (this.guiType == GuiType.DECO) {
            this.updateDecoOutput();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private ItemStack getFoodCraftingResult() {
        ItemStack inputItem = this.itemHandler.getStackInSlot(0);
        ItemStack inputContainer = this.itemHandler.getStackInSlot(1);
        if (inputContainer.m_41720_() == ModItems.FOOD_CONTAINER.get()) {
            if (inputItem.m_150930_(Items.f_42576_)) {
                return new ItemStack((ItemLike)ModItems.FOOD_DRIEDKELP_CONTAINER.get());
            }
            if (inputItem.m_150930_(Items.f_42530_) || inputItem.m_150930_(Items.f_42531_)) {
                return new ItemStack((ItemLike)ModItems.FOOD_FLAKES_CONTAINER.get());
            }
            if (inputItem.m_150930_((Item)ModItems.MINI_SHRIMP_RAW.get())) {
                return new ItemStack((ItemLike)ModItems.FOOD_MINISHRIMP_CONTAINER.get());
            }
        }
        return ItemStack.f_41583_;
    }

    private void craftItem() {
        ItemStack output;
        String fishClass;
        ItemStack inputEgg;
        if (this.guiType == GuiType.FOOD) {
            ItemStack result = this.getFoodCraftingResult();
            if (result.m_41619_()) {
                return;
            }
            this.itemHandler.extractItem(0, 1, false);
            this.itemHandler.extractItem(1, 1, false);
            this.itemHandler.insertItem(2, result, false);
        } else if (this.guiType == GuiType.EGG && !(inputEgg = this.itemHandler.getStackInSlot(3)).m_41619_() && this.f_58857_ instanceof ServerLevel && (fishClass = this.getFishClassForEgg(inputEgg.m_41720_())) != null && !(output = FishClassLootManager.getRandomLootForClass(fishClass)).m_41619_()) {
            this.itemHandler.extractItem(3, 1, false);
            this.itemHandler.insertItem(4, output.m_41777_(), false);
        }
    }

    private boolean hasRecipe() {
        if (this.guiType == GuiType.FOOD) {
            ItemStack result = this.getFoodCraftingResult();
            if (result.m_41619_()) {
                return false;
            }
            return this.canInsertAmountIntoOutputSlot(2, result.m_41613_()) && this.canInsertItemIntoOutputSlot(2, result.m_41720_());
        }
        if (this.guiType == GuiType.EGG) {
            ItemStack inputEgg = this.itemHandler.getStackInSlot(3);
            if (inputEgg.m_41619_()) {
                return false;
            }
            String fishClass = this.getFishClassForEgg(inputEgg.m_41720_());
            if (fishClass == null) {
                return false;
            }
            ItemStack outputSlot = this.itemHandler.getStackInSlot(4);
            return outputSlot.m_41613_() < outputSlot.m_41741_();
        }
        return false;
    }

    public void updateDecoOutput() {
        if (this.guiType != GuiType.DECO) {
            return;
        }
        ItemStack currentOutputStack = this.itemHandler.getStackInSlot(6);
        ItemStack newOutputStack = ItemStack.f_41583_;
        List availableRecipes = AquaristTableRecipes.DECO_RECIPES.stream().filter(recipe -> this.itemHandler.getStackInSlot(5).m_150930_(recipe.getInput())).collect(Collectors.toList());
        if (this.selectedRecipeIndex >= 0 && this.selectedRecipeIndex < availableRecipes.size()) {
            AquaristTableRecipes.DecoRecipe recipe2 = (AquaristTableRecipes.DecoRecipe)availableRecipes.get(this.selectedRecipeIndex);
            ItemStack inputStack = this.itemHandler.getStackInSlot(5);
            if (inputStack.m_150930_(recipe2.getInput()) && inputStack.m_41613_() >= 1) {
                newOutputStack = recipe2.getOutput().m_41777_();
            }
        }
        if (!ItemStack.m_41728_((ItemStack)currentOutputStack, (ItemStack)newOutputStack)) {
            this.itemHandler.setStackInSlot(6, newOutputStack);
            this.m_6596_();
        }
    }

    private boolean canInsertItemIntoOutputSlot(int slot, Item item) {
        ItemStack outputStack = this.itemHandler.getStackInSlot(slot);
        return outputStack.m_41619_() || outputStack.m_150930_(item);
    }

    private boolean canInsertAmountIntoOutputSlot(int slot, int count) {
        ItemStack outputStack = this.itemHandler.getStackInSlot(slot);
        return outputStack.m_41613_() + count <= outputStack.m_41741_();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.betterfishtanks.aquarist_table");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new AquaristTableMenu(pContainerId, pPlayerInventory, this, this.data);
    }

    public IItemHandler getInventory() {
        return this.itemHandler;
    }

    public List<ItemStack> getAvailableDecoRecipes() {
        ItemStack inputStack = this.itemHandler.getStackInSlot(5);
        if (inputStack.m_41619_()) {
            return List.of();
        }
        return AquaristTableRecipes.DECO_RECIPES.stream().filter(recipe -> inputStack.m_150930_(recipe.getInput().m_7968_().m_41720_())).map(AquaristTableRecipes.DecoRecipe::getOutput).collect(Collectors.toList());
    }

    public int m_6643_() {
        return this.itemHandler.getSlots();
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int pSlot) {
        return this.itemHandler.getStackInSlot(pSlot);
    }

    @NotNull
    public ItemStack m_7407_(int pSlot, int pAmount) {
        ItemStack stack = this.itemHandler.extractItem(pSlot, pAmount, false);
        if (!stack.m_41619_()) {
            this.m_6596_();
        }
        return stack;
    }

    @NotNull
    public ItemStack m_8016_(int pSlot) {
        ItemStack stack = this.itemHandler.getStackInSlot(pSlot);
        this.itemHandler.setStackInSlot(pSlot, ItemStack.f_41583_);
        if (!stack.m_41619_()) {
            this.m_6596_();
        }
        return stack;
    }

    public void m_6836_(int pSlot, @NotNull ItemStack pStack) {
        this.lazyItemHandler.ifPresent(handler -> {
            ItemStack remainingStack = handler.insertItem(pSlot, pStack, true);
            if (remainingStack.m_41613_() < pStack.m_41613_()) {
                handler.insertItem(pSlot, pStack, false);
                this.m_6596_();
            } else if (pStack.m_41619_() && !this.itemHandler.getStackInSlot(pSlot).m_41619_()) {
                this.itemHandler.setStackInSlot(pSlot, ItemStack.f_41583_);
                this.m_6596_();
            }
        });
    }

    public boolean m_6542_(@NotNull Player pPlayer) {
        return this.f_58857_.m_7702_(this.f_58858_) == this && pPlayer.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.f_41583_);
        }
        this.m_6596_();
    }

    public int[] m_7071_(Direction direction) {
        if (this.guiType == GuiType.DECO) {
            return new int[0];
        }
        if (direction == Direction.UP) {
            int[] nArray;
            switch (this.guiType) {
                case FOOD: {
                    int[] nArray2 = new int[2];
                    nArray2[0] = 0;
                    nArray = nArray2;
                    nArray2[1] = 1;
                    break;
                }
                case EGG: {
                    int[] nArray3 = new int[1];
                    nArray = nArray3;
                    nArray3[0] = 3;
                    break;
                }
                default: {
                    nArray = new int[]{};
                }
            }
            return nArray;
        }
        if (direction == Direction.DOWN) {
            int[] nArray;
            switch (this.guiType) {
                case FOOD: {
                    int[] nArray4 = new int[1];
                    nArray = nArray4;
                    nArray4[0] = 2;
                    break;
                }
                case EGG: {
                    int[] nArray5 = new int[1];
                    nArray = nArray5;
                    nArray5[0] = 4;
                    break;
                }
                default: {
                    nArray = new int[]{};
                }
            }
            return nArray;
        }
        return new int[0];
    }

    public boolean m_7155_(int slot, @NotNull ItemStack stack, @Nullable Direction direction) {
        if (this.guiType == GuiType.DECO) {
            return false;
        }
        if (direction == Direction.UP) {
            return switch (this.guiType) {
                case GuiType.FOOD -> {
                    if ((slot == 0 || slot == 1) && this.lazyItemHandler.map(handler -> handler.isItemValid(slot, stack)).orElse(false).booleanValue()) {
                        yield true;
                    }
                    yield false;
                }
                case GuiType.EGG -> {
                    if (slot == 3 && this.getFishClassForEgg(stack.m_41720_()) != null) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        return false;
    }

    public boolean m_7157_(int slot, @NotNull ItemStack stack, @NotNull Direction direction) {
        if (this.guiType == GuiType.DECO) {
            return false;
        }
        if (direction == Direction.DOWN) {
            return switch (this.guiType) {
                case GuiType.FOOD -> {
                    if (slot == 2) {
                        yield true;
                    }
                    yield false;
                }
                case GuiType.EGG -> {
                    if (slot == 4) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }
        return false;
    }

    public boolean m_7013_(int slot, @NotNull ItemStack stack) {
        return this.lazyItemHandler.map(handler -> handler.isItemValid(slot, stack)).orElse(false);
    }
}

