/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.betterfishtanksmod.block.entity;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import net.mint_gaming_studios.betterfishtanksmod.block.ModBlocks;
import net.mint_gaming_studios.betterfishtanksmod.block.custom.FishTankBlock;
import net.mint_gaming_studios.betterfishtanksmod.block.custom.decor.DecorationType;
import net.mint_gaming_studios.betterfishtanksmod.block.entity.ModBlockEntities;
import net.mint_gaming_studios.betterfishtanksmod.config.ModConfig;
import net.mint_gaming_studios.betterfishtanksmod.datagen.custom.FishClassifier;
import net.mint_gaming_studios.betterfishtanksmod.item.ModItems;
import net.mint_gaming_studios.betterfishtanksmod.item.custom.FishBagItem;
import net.mint_gaming_studios.betterfishtanksmod.screen.FishTankMenu;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FishTankBlockEntity
extends BlockEntity
implements WorldlyContainer,
MenuProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    private Direction playerFacing = Direction.NORTH;
    private BlockPos masterPos;
    private int fluidAmount = 0;
    private Fluid fluid = Fluids.f_76191_;
    private int capacity = 1000;
    private final Set<BlockPos> structureBlocks = new HashSet<BlockPos>();
    private boolean needsScan = true;
    private int structureMinY = -1;
    private int structureMaxY = -1;
    private final Map<Integer, BlockPos> decorationPositions = new HashMap<Integer, BlockPos>();
    private final Map<BlockPos, String> decorationOccupancy = new HashMap<BlockPos, String>();
    private int viewers = 0;
    private int foodLevel = 0;
    private final int maxFoodLevel = 1000;
    private long dayTickCounter = 0L;
    private int dailyFoodRequirement = 0;
    private float foodConsumptionBuffer = 0.0f;
    private static final int DAY_IN_TICKS = 24000;
    private DecorationType decorationType = DecorationType.NONE;
    private Direction caveFacing = Direction.NORTH;
    private Direction towerFacing = Direction.NORTH;
    private Direction branchFacing = Direction.NORTH;
    public static final int MAX_DECO_SLOTS_PER_PAGE = 5;
    public static final int MAX_DECO_SLOTS_POSSIBLE = 20;
    private int floorBlockCount = 0;
    private int maxDecoSlots = 5;
    private int currentPage = 0;
    public static final int FOOD_SLOT = 0;
    public static final int UPGRADE_SLOT_START = 1;
    public static final int UPGRADE_SLOT_END = 20;
    public static final int EGG_SLOT = 21;
    public static final int FLOORING_SLOT = 22;
    public static final int TOTAL_SLOTS = 23;
    private LazyOptional<IItemHandler> itemHandlerLazyOptional = LazyOptional.empty();
    private int fishCount = 0;
    private int progress = 0;
    private int maxProgress = 6000;
    protected final NonNullList<ItemStack> items = NonNullList.m_122780_((int)23, (Object)ItemStack.f_41583_);
    protected final ContainerData data;
    private static final int[] HOPPER_SLOTS_FOR_UP = new int[]{0};
    private static final int[] HOPPER_SLOTS_FOR_DOWN = new int[]{21};
    private static final int[] HOPPER_SLOTS_FOR_SIDES = new int[0];

    private List<BlockPos> getValidFloorPositions() {
        if (this.f_58857_ == null || !this.isMaster()) {
            return Collections.emptyList();
        }
        return this.structureBlocks.stream().filter(p -> {
            BlockEntity patt6356$temp = this.f_58857_.m_7702_(p);
            if (patt6356$temp instanceof FishTankBlockEntity) {
                FishTankBlockEntity be = (FishTankBlockEntity)patt6356$temp;
                return this.f_58857_.m_8055_(p).m_60713_((Block)ModBlocks.FISH_TANK_BLOCK.get()) && (Boolean)this.f_58857_.m_8055_(p).m_61143_((Property)FishTankBlock.DOWN) == false && be.getDecorationType() == DecorationType.NONE;
            }
            return false;
        }).collect(Collectors.toList());
    }

    public void linkRightClickToGui(ItemStack stack, BlockPos pos) {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                master.linkRightClickToGui(stack, pos);
            }
            return;
        }
        for (int i = 1; i <= 20; ++i) {
            if (!((ItemStack)this.items.get(i)).m_41619_()) continue;
            this.m_6836_(i, new ItemStack((ItemLike)stack.m_41720_()));
            this.m_6596_();
            return;
        }
    }

    public FishTankBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.FISH_TANK_ENTITY.get(), pos, state);
        this.masterPos = pos;
        this.itemHandlerLazyOptional = LazyOptional.of(() -> new IItemHandler(){

            public int getSlots() {
                return 2;
            }

            public ItemStack getStackInSlot(int slot) {
                if (slot == 0) {
                    return (ItemStack)FishTankBlockEntity.this.items.get(0);
                }
                if (slot == 1) {
                    return (ItemStack)FishTankBlockEntity.this.items.get(21);
                }
                return ItemStack.f_41583_;
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                int internalSlot = -1;
                if (slot == 0) {
                    internalSlot = 0;
                }
                if (internalSlot != 0) {
                    return stack;
                }
                if (!FishTankBlockEntity.this.m_7013_(internalSlot, stack)) {
                    return stack;
                }
                ItemStack currentStack = (ItemStack)FishTankBlockEntity.this.items.get(internalSlot);
                int maxStackSize = this.getSlotLimit(slot);
                if (currentStack.m_41613_() >= maxStackSize) {
                    return stack;
                }
                int transferAmount = Math.min(stack.m_41613_(), maxStackSize - currentStack.m_41613_());
                if (transferAmount == 0) {
                    return stack;
                }
                if (!simulate) {
                    if (currentStack.m_41619_()) {
                        FishTankBlockEntity.this.items.set(internalSlot, (Object)stack.m_255036_(transferAmount));
                    } else {
                        currentStack.m_41769_(transferAmount);
                    }
                    FishTankBlockEntity.this.m_6596_();
                }
                return stack.m_255036_(stack.m_41613_() - transferAmount);
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                int internalSlot = -1;
                if (slot == 0) {
                    internalSlot = 0;
                }
                if (slot == 1) {
                    internalSlot = 21;
                }
                if (internalSlot != 21) {
                    return ItemStack.f_41583_;
                }
                ItemStack currentStack = (ItemStack)FishTankBlockEntity.this.items.get(internalSlot);
                if (currentStack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                int extractedAmount = Math.min(amount, currentStack.m_41613_());
                if (extractedAmount == 0) {
                    return ItemStack.f_41583_;
                }
                if (!simulate) {
                    ItemStack extracted = currentStack.m_255036_(extractedAmount);
                    currentStack.m_41774_(extractedAmount);
                    FishTankBlockEntity.this.m_6596_();
                    return extracted;
                }
                return currentStack.m_255036_(extractedAmount);
            }

            public int getSlotLimit(int slot) {
                if (slot == 0) {
                    return ((ItemStack)FishTankBlockEntity.this.items.get(0)).m_41741_();
                }
                if (slot == 1) {
                    return ((ItemStack)FishTankBlockEntity.this.items.get(21)).m_41741_();
                }
                return 0;
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                int internalSlot = -1;
                if (slot == 0) {
                    internalSlot = 0;
                }
                if (slot == 1) {
                    internalSlot = 21;
                }
                if (internalSlot != -1) {
                    return FishTankBlockEntity.this.m_7013_(internalSlot, stack);
                }
                return false;
            }
        });
        this.data = new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> FishTankBlockEntity.this.progress;
                    case 1 -> FishTankBlockEntity.this.maxProgress;
                    case 2 -> FishTankBlockEntity.this.fishCount;
                    case 3 -> FishTankBlockEntity.this.foodLevel;
                    case 4 -> FishTankBlockEntity.this.maxFoodLevel;
                    case 5 -> FishTankBlockEntity.this.floorBlockCount;
                    case 6 -> FishTankBlockEntity.this.maxDecoSlots;
                    case 7 -> FishTankBlockEntity.this.currentPage;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 0: {
                        FishTankBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        FishTankBlockEntity.this.maxProgress = value;
                        break;
                    }
                    case 2: {
                        FishTankBlockEntity.this.fishCount = value;
                        break;
                    }
                    case 3: {
                        FishTankBlockEntity.this.foodLevel = value;
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        FishTankBlockEntity.this.floorBlockCount = value;
                        break;
                    }
                    case 6: {
                        FishTankBlockEntity.this.maxDecoSlots = value;
                        break;
                    }
                    case 7: {
                        FishTankBlockEntity.this.currentPage = value;
                    }
                }
            }

            public int m_6499_() {
                return 8;
            }
        };
    }

    public DecorationType getDecorationType() {
        return this.decorationType;
    }

    public void setDecorationType(DecorationType type) {
        if (this.decorationType != type) {
            this.decorationType = type;
            this.m_6596_();
            if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public Direction getCaveFacing() {
        return this.caveFacing;
    }

    public void setCaveFacing(Direction facing) {
        if (this.caveFacing != facing) {
            this.caveFacing = facing;
            this.m_6596_();
            if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public Direction getTowerFacing() {
        return this.towerFacing;
    }

    public void setTowerFacing(Direction facing) {
        if (this.towerFacing != facing) {
            this.towerFacing = facing;
            this.m_6596_();
            if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public Direction getBranchFacing() {
        return this.branchFacing;
    }

    public void setBranchFacing(Direction facing) {
        if (this.branchFacing != facing) {
            this.branchFacing = facing;
            this.m_6596_();
            if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public void updateFishCount() {
        int entityCount;
        if (!this.isMaster() || this.f_58857_ == null) {
            return;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos pos : this.structureBlocks) {
            minX = Math.min(minX, pos.m_123341_());
            minY = Math.min(minY, pos.m_123342_());
            minZ = Math.min(minZ, pos.m_123343_());
            maxX = Math.max(maxX, pos.m_123341_() + 1);
            maxY = Math.max(maxY, pos.m_123342_() + 1);
            maxZ = Math.max(maxZ, pos.m_123343_() + 1);
        }
        AABB boundingBox = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        this.fishCount = entityCount = this.f_58857_.m_6443_(Entity.class, boundingBox, entity -> this.isAquaticEntity((Entity)entity)).size();
        if (this.fishCount > 0) {
            float f = this.fishCount;
            Objects.requireNonNull(this);
            this.dailyFoodRequirement = (int)(f * (0.02f * 1000.0f));
            this.maxProgress = Math.max(20, 12000 / this.fishCount);
        } else {
            this.dailyFoodRequirement = 0;
            this.maxProgress = 0;
        }
        this.m_6596_();
    }

    private boolean isAquaticEntity(Entity entity) {
        return FishClassifier.isCatchable(entity);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
        BlockEntity be;
        FishTankBlockEntity master = this;
        if (!this.isMaster() && this.f_58857_ != null && (be = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
            FishTankBlockEntity masterEntity;
            master = masterEntity = (FishTankBlockEntity)be;
        }
        master.playerFacing = player.m_6350_();
        if (master.f_58857_ != null && !master.f_58857_.m_5776_()) {
            if (master.needsScan) {
                master.scanStructure();
                master.needsScan = false;
            }
            master.updateFishCount();
        }
        return new FishTankMenu(containerId, playerInventory, master, master.data);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.fishtank");
    }

    public static void tick(Level level, BlockPos pos, BlockState state, FishTankBlockEntity be) {
        if (level.m_5776_()) {
            return;
        }
        if (be.isMaster()) {
            if (be.needsScan) {
                be.scanStructure();
                be.needsScan = false;
            }
            if (be.viewers > 0) {
                be.synchronizeDecorations();
            }
            if (((Boolean)ModConfig.Server.REQUIRE_FOOD.get()).booleanValue()) {
                be.handleHunger();
            }
            FishTankBlockEntity.handleEggGeneration(be);
            be.preventFishDespawning();
            be.handleTurtleGrowth();
            if (level.m_46467_() % 100L == 0L) {
                be.calculateFloorBlocks();
                be.updateMaxDecoSlots();
            }
        } else if (!(level.m_46467_() % 100L != 0L || level.m_7702_(be.masterPos) != null && level.m_7702_(be.masterPos) instanceof FishTankBlockEntity)) {
            be.becomeMaster();
        }
    }

    private void calculateFloorBlocks() {
        if (this.f_58857_ == null || !this.isMaster()) {
            return;
        }
        int count = 0;
        for (BlockPos pos : this.structureBlocks) {
            BlockState blockState = this.f_58857_.m_8055_(pos);
            if (!blockState.m_61138_(FishTankBlock.FLOOR) || blockState.m_61143_(FishTankBlock.FLOOR) == FishTankBlock.FloorType.NONE) continue;
            ++count;
        }
        if (this.floorBlockCount != count) {
            this.floorBlockCount = count;
            this.m_6596_();
        }
    }

    private void updateMaxDecoSlots() {
        int newMaxDecoSlots = 5 * (1 + this.floorBlockCount / 10);
        if (this.maxDecoSlots != (newMaxDecoSlots = Math.min(newMaxDecoSlots, 20))) {
            this.maxDecoSlots = newMaxDecoSlots;
            if (this.currentPage * 5 >= this.maxDecoSlots) {
                this.currentPage = Math.max(0, (this.maxDecoSlots - 1) / 5);
            }
            this.m_6596_();
        }
    }

    public int getMaxDecoSlots() {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.getMaxDecoSlots();
            }
            return 5;
        }
        return this.maxDecoSlots;
    }

    public int getCurrentPage() {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.getCurrentPage();
            }
            return 0;
        }
        return this.currentPage;
    }

    public void setCurrentPage(int page) {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                master.setCurrentPage(page);
            }
            return;
        }
        int maxPage = (this.maxDecoSlots - 1) / 5;
        this.currentPage = Math.max(0, Math.min(page, maxPage));
        this.m_6596_();
    }

    private void preventFishDespawning() {
        if (this.f_58857_ == null || !this.isMaster()) {
            return;
        }
        Optional<AABB> boundingBoxOpt = this.getTankBounds();
        if (boundingBoxOpt.isEmpty()) {
            return;
        }
        List aquaticEntities = this.f_58857_.m_6443_(Entity.class, boundingBoxOpt.get(), this::isAquaticEntity);
        for (Entity entity : aquaticEntities) {
            if (!(entity instanceof Mob)) continue;
            Mob mobEntity = (Mob)entity;
            mobEntity.m_21530_();
        }
    }

    private void handleTurtleGrowth() {
        if (this.f_58857_ == null || !this.isMaster()) {
            return;
        }
        Optional<AABB> boundingBoxOpt = this.getTankBounds();
        if (boundingBoxOpt.isEmpty()) {
            return;
        }
        List babyTurtles = this.f_58857_.m_6443_(Turtle.class, boundingBoxOpt.get(), turtle -> turtle.m_6162_());
        if (babyTurtles.isEmpty()) {
            return;
        }
        int MAX_ADULT_TURTLES_ALLOWED = 2;
        long adultTurtleCount = this.f_58857_.m_6443_(Turtle.class, boundingBoxOpt.get(), turtle -> !turtle.m_6162_()).size();
        for (Turtle babyTurtle : babyTurtles) {
            if (adultTurtleCount >= 2L) continue;
            ++adultTurtleCount;
        }
    }

    private static void handleEggGeneration(FishTankBlockEntity be) {
        if (be.progress == 0 && be.getFishCount() > 0) {
            ItemStack eggSlot = be.m_8020_(21);
            ItemStack newEgg = be.getRandomFishEgg();
            if (newEgg.m_41619_()) {
                return;
            }
            if (eggSlot.m_41619_() || eggSlot.m_150930_(newEgg.m_41720_()) && eggSlot.m_41613_() < eggSlot.m_41741_()) {
                boolean canGenerateEggs = false;
                if (((Boolean)ModConfig.Server.REQUIRE_FOOD.get()).booleanValue()) {
                    if (be.foodLevel > 0) {
                        canGenerateEggs = true;
                    }
                } else {
                    ItemStack foodStack = be.m_8020_(0);
                    if (!foodStack.m_41619_()) {
                        if (FishTankBlockEntity.isFoodContainer(foodStack)) {
                            int maxDamage;
                            int damage = foodStack.m_41773_() + 1;
                            if (damage >= (maxDamage = foodStack.m_41741_())) {
                                be.m_6836_(0, new ItemStack((ItemLike)ModItems.FOOD_CONTAINER.get()));
                            } else {
                                foodStack.m_41721_(damage);
                            }
                        } else {
                            foodStack.m_41774_(1);
                        }
                        canGenerateEggs = true;
                    }
                }
                if (canGenerateEggs) {
                    be.progress = be.maxProgress;
                    FishTankBlockEntity.m_155232_((Level)be.f_58857_, (BlockPos)be.m_58899_(), (BlockState)be.m_58900_());
                }
            }
        }
        if (be.progress > 0) {
            --be.progress;
            if (be.progress == 0) {
                FishTankBlockEntity.craftItem(be);
            }
            FishTankBlockEntity.m_155232_((Level)be.f_58857_, (BlockPos)be.m_58899_(), (BlockState)be.m_58900_());
        }
    }

    private static void craftItem(FishTankBlockEntity be) {
        ItemStack newEgg = be.getRandomFishEgg();
        if (newEgg.m_41619_()) {
            return;
        }
        ItemStack eggSlot = be.m_8020_(21);
        if (eggSlot.m_41619_()) {
            be.m_6836_(21, newEgg);
        } else if (eggSlot.m_150930_(newEgg.m_41720_())) {
            eggSlot.m_41769_(1);
        }
    }

    private ItemStack getRandomFishEgg() {
        if (this.f_58857_ == null) {
            return ItemStack.f_41583_;
        }
        RandomSource random = this.f_58857_.f_46441_;
        double rand = random.m_188500_();
        if (rand < 0.5) {
            return new ItemStack((ItemLike)ModItems.COMMON_FISH_EGG.get());
        }
        if (rand < 0.75) {
            return new ItemStack((ItemLike)ModItems.UNCOMMON_FISH_EGG.get());
        }
        if (rand < 0.9) {
            return new ItemStack((ItemLike)ModItems.RARE_FISH_EGG.get());
        }
        if (rand < 0.97) {
            return new ItemStack((ItemLike)ModItems.EPIC_FISH_EGG.get());
        }
        if (rand < 0.99) {
            return new ItemStack((ItemLike)ModItems.LEGENDARY_FISH_EGG.get());
        }
        return new ItemStack((ItemLike)ModItems.EXOTIC_FISH_EGG.get());
    }

    private void handleHunger() {
        if (this.f_58857_ == null) {
            return;
        }
        ++this.dayTickCounter;
        if (this.dayTickCounter >= 24000L) {
            this.dayTickCounter = 0L;
            this.updateFishCount();
            this.foodConsumptionBuffer = 0.0f;
        }
        if (this.dailyFoodRequirement <= 0) {
            return;
        }
        this.foodConsumptionBuffer += (float)this.dailyFoodRequirement / 24000.0f;
        int amountToConsume = (int)this.foodConsumptionBuffer;
        if (amountToConsume > 0) {
            this.foodConsumptionBuffer -= (float)amountToConsume;
            int foodLeftToConsume = amountToConsume;
            int canConsumeNow = Math.min(foodLeftToConsume, this.foodLevel);
            this.foodLevel -= canConsumeNow;
            if ((foodLeftToConsume -= canConsumeNow) > 0 && this.refillFoodAndFillUp()) {
                int canConsumeAfterRefill = Math.min(foodLeftToConsume, this.foodLevel);
                this.foodLevel -= canConsumeAfterRefill;
                foodLeftToConsume -= canConsumeAfterRefill;
            }
            if (foodLeftToConsume > 0) {
                this.starveRandomFish();
            }
            this.m_6596_();
        }
    }

    private boolean refillFoodAndFillUp() {
        ItemStack foodStack = this.m_8020_(0);
        if (foodStack.m_41619_()) {
            return false;
        }
        boolean consumed = false;
        if (FishTankBlockEntity.isFoodContainer(foodStack)) {
            int currentDamage = foodStack.m_41773_();
            if (currentDamage < foodStack.m_41776_()) {
                foodStack.m_41721_(currentDamage + 1);
                consumed = true;
                if (foodStack.m_41773_() >= foodStack.m_41776_()) {
                    this.m_6836_(0, new ItemStack((ItemLike)ModItems.FOOD_CONTAINER.get()));
                }
            }
        } else if (foodStack.m_150930_(Items.f_42576_)) {
            foodStack.m_41774_(1);
            consumed = true;
        }
        if (consumed) {
            this.foodLevel = this.maxFoodLevel;
            return true;
        }
        return false;
    }

    private Optional<AABB> getTankBounds() {
        if (this.structureBlocks.isEmpty()) {
            return Optional.empty();
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos pos : this.structureBlocks) {
            minX = Math.min(minX, pos.m_123341_());
            minY = Math.min(minY, pos.m_123342_());
            minZ = Math.min(minZ, pos.m_123343_());
            maxX = Math.max(maxX, pos.m_123341_() + 1);
            maxY = Math.max(maxY, pos.m_123342_() + 1);
            maxZ = Math.max(maxZ, pos.m_123343_() + 1);
        }
        return Optional.of(new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
    }

    private void starveRandomFish() {
        Entity fishToStarve;
        if (this.f_58857_ == null) {
            return;
        }
        Optional<AABB> boundingBoxOpt = this.getTankBounds();
        if (boundingBoxOpt.isEmpty()) {
            return;
        }
        List aquaticEntities = this.f_58857_.m_6443_(Entity.class, boundingBoxOpt.get(), this::isAquaticEntity);
        if (!aquaticEntities.isEmpty() && (fishToStarve = (Entity)aquaticEntities.get(this.f_58857_.f_46441_.m_188503_(aquaticEntities.size()))) instanceof LivingEntity) {
            LivingEntity livingFish = (LivingEntity)fishToStarve;
            livingFish.m_6469_(this.f_58857_.m_269111_().m_269064_(), 1.0f);
        }
    }

    public void requestScan() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.needsScan = true;
        }
    }

    private void scanStructure() {
        if (!this.isMaster() || this.f_58857_ == null) {
            return;
        }
        this.structureBlocks.clear();
        HashSet<BlockPos> scanned = new HashSet<BlockPos>();
        LinkedList<BlockPos> toScan = new LinkedList<BlockPos>();
        toScan.add(this.f_58858_);
        scanned.add(this.f_58858_);
        while (!toScan.isEmpty()) {
            BlockPos currentPos = (BlockPos)toScan.poll();
            this.structureBlocks.add(currentPos);
            BlockEntity blockEntity = this.f_58857_.m_7702_(currentPos);
            if (blockEntity instanceof FishTankBlockEntity) {
                FishTankBlockEntity currentBe = (FishTankBlockEntity)blockEntity;
                currentBe.setMasterPos(this.f_58858_);
            }
            for (Direction dir : Direction.values()) {
                BlockPos neighborPos = currentPos.m_121945_(dir);
                if (scanned.contains(neighborPos) || !this.f_58857_.m_8055_(neighborPos).m_60713_(this.m_58900_().m_60734_())) continue;
                toScan.add(neighborPos);
                scanned.add(neighborPos);
            }
        }
        this.capacity = this.structureBlocks.size() * 1000;
        this.structureMinY = this.structureBlocks.stream().mapToInt(Vec3i::m_123342_).min().orElse(this.f_58858_.m_123342_());
        this.structureMaxY = this.structureBlocks.stream().mapToInt(Vec3i::m_123342_).max().orElse(this.f_58858_.m_123342_());
        if (this.fluidAmount > this.capacity) {
            this.fluidAmount = this.capacity;
        }
        this.updateAllBlockStates();
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private void becomeMaster() {
        this.masterPos = this.f_58858_;
        this.needsScan = true;
        this.m_6596_();
    }

    public int getFluidAmount() {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.getFluidAmount();
            }
            return 0;
        }
        return this.fluidAmount;
    }

    public int getStructureMinY() {
        if (this.isMaster() || this.f_58857_ == null) {
            return this.structureMinY != -1 ? this.structureMinY : this.m_58899_().m_123342_();
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.masterPos);
        if (blockEntity instanceof FishTankBlockEntity) {
            FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
            return master.getStructureMinY();
        }
        return this.m_58899_().m_123342_();
    }

    public int getStructureMaxY() {
        if (this.isMaster() || this.f_58857_ == null) {
            return this.structureMaxY != -1 ? this.structureMaxY : this.m_58899_().m_123342_();
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.masterPos);
        if (blockEntity instanceof FishTankBlockEntity) {
            FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
            return master.getStructureMaxY();
        }
        return this.m_58899_().m_123342_();
    }

    public int getCapacity() {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.getCapacity();
            }
            return 1000;
        }
        return this.capacity;
    }

    public float getWaterLevelScaled() {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.getWaterLevelScaled();
            }
            return 0.0f;
        }
        return this.capacity > 0 ? (float)this.fluidAmount / (float)this.capacity : 0.0f;
    }

    public int addWater(int amount) {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.addWater(amount);
            }
            return 0;
        }
        int amountToAdd = Math.min(amount, this.capacity - this.fluidAmount);
        if (amountToAdd > 0) {
            this.fluidAmount += amountToAdd;
            LOGGER.info("Water in tank at {}: {}/{} mB", new Object[]{this.f_58858_, this.fluidAmount, this.capacity});
            this.updateAllBlockStates();
            this.m_6596_();
            if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
        return amountToAdd;
    }

    private void updateAllBlockStates() {
        if (this.f_58857_ == null || this.f_58857_.m_5776_() || !this.isMaster()) {
            return;
        }
        ItemStack floorStack = this.m_8020_(22);
        FishTankBlock.FloorType floorType = FishTankBlock.FloorType.NONE;
        if (floorStack.m_150930_(Items.f_41830_)) {
            floorType = FishTankBlock.FloorType.SAND;
        } else if (floorStack.m_150930_(Items.f_41832_)) {
            floorType = FishTankBlock.FloorType.GRAVEL;
        } else if (floorStack.m_150930_(Items.f_41831_)) {
            floorType = FishTankBlock.FloorType.RED_SAND;
        }
        int currentFluidAmount = this.fluidAmount;
        int fluidHeightY = this.structureMinY - 1;
        List sortedYLevels = this.structureBlocks.stream().map(Vec3i::m_123342_).distinct().sorted().collect(Collectors.toList());
        if (sortedYLevels.isEmpty()) {
            for (BlockPos pos2 : this.structureBlocks) {
                this.updateBlockProperties(pos2, FishTankBlock.FloorType.NONE, false);
            }
            return;
        }
        Iterator<Object> iterator = sortedYLevels.iterator();
        while (iterator.hasNext()) {
            int yLevel = (Integer)iterator.next();
            long blocksAtThisY = this.structureBlocks.stream().filter(pos -> pos.m_123342_() == yLevel).count();
            int volumeAtThisY = (int)blocksAtThisY * 1000;
            if (currentFluidAmount <= 0) break;
            fluidHeightY = yLevel;
            currentFluidAmount -= volumeAtThisY;
        }
        for (BlockPos pos3 : this.structureBlocks) {
            FishTankBlock.FloorType currentBlockFloorType = pos3.m_123342_() == this.structureMinY ? floorType : FishTankBlock.FloorType.NONE;
            boolean isWaterlogged = pos3.m_123342_() <= fluidHeightY && this.fluidAmount > 0;
            this.updateBlockProperties(pos3, currentBlockFloorType, isWaterlogged);
        }
        LOGGER.debug("Fishtank updated with {}/{} mB fluid ({}%)", new Object[]{this.fluidAmount, this.capacity, this.capacity > 0 ? this.fluidAmount * 100 / this.capacity : 0});
    }

    private void updateBlockProperties(BlockPos pos, FishTankBlock.FloorType floorType, boolean isWaterlogged) {
        if (this.f_58857_ == null) {
            return;
        }
        BlockState currentState = this.f_58857_.m_8055_(pos);
        if (currentState.m_60713_(this.m_58900_().m_60734_())) {
            FishTankBlock.FluidType fluidType = isWaterlogged ? (this.fluid == Fluids.f_76193_ ? FishTankBlock.FluidType.WATER : FishTankBlock.FluidType.NONE) : FishTankBlock.FluidType.NONE;
            BlockState newState = (BlockState)((BlockState)currentState.m_61124_(FishTankBlock.FLOOR, (Comparable)((Object)floorType))).m_61124_(FishTankBlock.FLUID_TYPE, (Comparable)((Object)fluidType));
            if (!newState.equals(currentState)) {
                try {
                    this.f_58857_.m_7731_(pos, newState, 3);
                }
                catch (Exception e) {
                    LOGGER.error("Error setting block state at {}: {}", (Object)pos, (Object)e.getMessage());
                }
            }
        }
    }

    public int removeWater(int amount) {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.removeWater(amount);
            }
            return 0;
        }
        int amountToRemove = Math.min(amount, this.fluidAmount);
        if (amountToRemove > 0) {
            this.fluidAmount -= amountToRemove;
            if (this.fluidAmount == 0) {
                this.fluid = Fluids.f_76191_;
            }
            this.updateAllBlockStates();
            this.m_6596_();
            if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
        return amountToRemove;
    }

    public boolean isMaster() {
        return this.f_58858_.equals((Object)this.masterPos);
    }

    public BlockPos getMasterPos() {
        return this.masterPos;
    }

    public void setMasterPos(BlockPos pos) {
        if (!this.masterPos.equals((Object)pos)) {
            this.masterPos = pos;
            this.m_6596_();
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128359_("decorationType", this.decorationType.m_7912_());
        nbt.m_128359_("caveFacing", this.caveFacing.m_122433_());
        nbt.m_128359_("towerFacing", this.towerFacing.m_122433_());
        nbt.m_128359_("branchFacing", this.branchFacing.m_122433_());
        if (this.isMaster()) {
            nbt.m_128405_("fluidAmount", this.fluidAmount);
            nbt.m_128359_("fluid", ForgeRegistries.FLUIDS.getKey((Object)this.fluid).toString());
            nbt.m_128405_("capacity", this.capacity);
            nbt.m_128405_("structureMinY", this.structureMinY);
            nbt.m_128405_("fishCount", this.fishCount);
            nbt.m_128405_("progress", this.progress);
            nbt.m_128405_("foodLevel", this.foodLevel);
            nbt.m_128405_("floorBlockCount", this.floorBlockCount);
            nbt.m_128405_("maxDecoSlots", this.maxDecoSlots);
            nbt.m_128405_("currentPage", this.currentPage);
            CompoundTag decoTag = new CompoundTag();
            this.decorationPositions.forEach((slot, pos) -> decoTag.m_128365_(String.valueOf(slot), (Tag)NbtUtils.m_129224_((BlockPos)pos)));
            nbt.m_128365_("Decorations", (Tag)decoTag);
            ListTag occupancyList = new ListTag();
            this.decorationOccupancy.forEach((pos, id) -> {
                CompoundTag entry = new CompoundTag();
                entry.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
                entry.m_128359_("Id", id);
                occupancyList.add((Object)entry);
            });
            nbt.m_128365_("DecorationOccupancy", (Tag)occupancyList);
        }
        nbt.m_128365_("masterPos", (Tag)NbtUtils.m_129224_((BlockPos)this.masterPos));
        return nbt;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (pkt.m_131708_() != null) {
            this.handleUpdateTag(pkt.m_131708_());
            if (this.f_58857_ != null && this.f_58857_.f_46443_) {
                this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            }
        }
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        if (tag.m_128441_("masterPos")) {
            this.masterPos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("masterPos"));
        }
        if (tag.m_128441_("decorationType")) {
            this.decorationType = DecorationType.byName(tag.m_128461_("decorationType"));
        }
        if (tag.m_128441_("caveFacing")) {
            this.caveFacing = Direction.m_122402_((String)tag.m_128461_("caveFacing"));
        }
        if (tag.m_128441_("towerFacing")) {
            this.towerFacing = Direction.m_122402_((String)tag.m_128461_("towerFacing"));
        }
        if (tag.m_128441_("branchFacing")) {
            this.branchFacing = Direction.m_122402_((String)tag.m_128461_("branchFacing"));
        }
        this.fluidAmount = tag.m_128451_("fluidAmount");
        this.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(tag.m_128461_("fluid")));
        this.capacity = tag.m_128451_("capacity");
        this.fishCount = tag.m_128451_("fishCount");
        this.progress = tag.m_128451_("progress");
        this.foodLevel = tag.m_128451_("foodLevel");
        this.floorBlockCount = tag.m_128451_("floorBlockCount");
        this.maxDecoSlots = tag.m_128451_("maxDecoSlots");
        this.currentPage = tag.m_128451_("currentPage");
        this.decorationPositions.clear();
        if (tag.m_128441_("Decorations")) {
            CompoundTag decoTag = tag.m_128469_("Decorations");
            for (String key : decoTag.m_128431_()) {
                this.decorationPositions.put(Integer.parseInt(key), NbtUtils.m_129239_((CompoundTag)decoTag.m_128469_(key)));
            }
        }
        this.decorationOccupancy.clear();
        if (tag.m_128425_("DecorationOccupancy", 9)) {
            ListTag occupancyList = tag.m_128437_("DecorationOccupancy", 10);
            for (int i = 0; i < occupancyList.size(); ++i) {
                CompoundTag entry = occupancyList.m_128728_(i);
                BlockPos pos = NbtUtils.m_129239_((CompoundTag)entry.m_128469_("Pos"));
                String id = entry.m_128461_("Id");
                this.decorationOccupancy.put(pos, id);
            }
        }
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public int m_6643_() {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.m_6643_();
            }
            return 23;
        }
        return this.items.size();
    }

    public boolean m_7983_() {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.m_7983_();
            }
            return true;
        }
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.m_8020_(slot);
            }
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.items.get(slot);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.m_7407_(slot, amount);
            }
            return ItemStack.f_41583_;
        }
        ItemStack stack = ContainerHelper.m_18969_(this.items, (int)slot, (int)amount);
        if (!stack.m_41619_()) {
            this.m_6596_();
            if (slot >= 1 && slot <= 20) {
                this.removeDecorationForSlot(slot);
            }
        }
        return stack;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.m_8016_(slot);
            }
            return ItemStack.f_41583_;
        }
        ItemStack stack = ContainerHelper.m_18966_(this.items, (int)slot);
        if (!stack.m_41619_() && slot >= 1 && slot <= 20) {
            this.removeDecorationForSlot(slot);
        }
        return stack;
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        ItemStack toSet;
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                master.m_6836_(slot, stack);
            }
            return;
        }
        ItemStack oldStack = ((ItemStack)this.items.get(slot)).m_41777_();
        int maxStackSize = 64;
        if (slot == 22 || slot >= 1 && slot <= 20) {
            maxStackSize = 1;
        }
        if ((toSet = stack).m_41613_() > maxStackSize) {
            toSet.m_41764_(maxStackSize);
        }
        this.items.set(slot, (Object)toSet);
        this.m_6596_();
        if (this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return;
        }
        if (slot == 0 && !ItemStack.m_41656_((ItemStack)oldStack, (ItemStack)toSet) && this.foodLevel <= 0) {
            this.refillFoodAndFillUp();
        }
        if (slot == 22) {
            this.updateAllBlockStates();
        } else if (slot >= 1 && slot <= 20 && !ItemStack.m_41656_((ItemStack)oldStack, (ItemStack)toSet)) {
            if (!oldStack.m_41619_()) {
                this.removeDecorationForSlot(slot);
            }
            if (!toSet.m_41619_()) {
                this.addDecorationForSlot(slot, toSet);
            }
        }
    }

    public boolean m_6542_(@NotNull Player player) {
        if (this.f_58857_ == null || this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public void m_6211_() {
        int i;
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                master.m_6211_();
            }
            return;
        }
        ArrayList<Integer> decoSlots = new ArrayList<Integer>();
        for (i = 1; i <= 20; ++i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            decoSlots.add(i);
        }
        for (i = 0; i < this.m_6643_(); ++i) {
            this.items.set(i, (Object)ItemStack.f_41583_);
        }
        Iterator iterator = decoSlots.iterator();
        while (iterator.hasNext()) {
            int slot = (Integer)iterator.next();
            this.removeDecorationForSlot(slot);
        }
        this.updateAllBlockStates();
        this.m_6596_();
    }

    public void m_5856_(Player pPlayer) {
        if (!pPlayer.m_5833_()) {
            ++this.viewers;
        }
    }

    public void m_5785_(Player pPlayer) {
        if (!pPlayer.m_5833_()) {
            --this.viewers;
            if (this.f_58857_ != null && !this.f_58857_.m_5776_() && this.isMaster()) {
                this.synchronizeDecorations();
            }
        }
    }

    public int[] m_7071_(Direction direction) {
        if (direction == Direction.UP) {
            return HOPPER_SLOTS_FOR_UP;
        }
        if (direction == Direction.DOWN) {
            return HOPPER_SLOTS_FOR_DOWN;
        }
        return HOPPER_SLOTS_FOR_SIDES;
    }

    public boolean m_7155_(int slot, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.m_7155_(slot, itemStack, direction);
            }
            return false;
        }
        return slot == 0 && direction == Direction.UP && this.m_7013_(slot, itemStack);
    }

    public boolean m_7157_(int slot, @NotNull ItemStack itemStack, @NotNull Direction direction) {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.m_7157_(slot, itemStack, direction);
            }
            return false;
        }
        return slot == 21 && direction == Direction.DOWN;
    }

    private boolean isCoral(ItemStack stack) {
        return stack.m_150930_(Items.f_42291_) || stack.m_150930_(Items.f_42292_) || stack.m_150930_(Items.f_42293_) || stack.m_150930_(Items.f_42294_) || stack.m_150930_(Items.f_42290_);
    }

    private static boolean isFoodContainer(ItemStack stack) {
        return stack.m_150930_((Item)ModItems.FOOD_DRIEDKELP_CONTAINER.get()) || stack.m_150930_((Item)ModItems.FOOD_FLAKES_CONTAINER.get()) || stack.m_150930_((Item)ModItems.FOOD_MINISHRIMP_CONTAINER.get()) || stack.m_150930_((Item)ModItems.FOOD_PELLETS_CONTAINER.get());
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128359_("decorationType", this.decorationType.m_7912_());
        nbt.m_128359_("caveFacing", this.caveFacing.m_122433_());
        nbt.m_128359_("towerFacing", this.towerFacing.m_122433_());
        nbt.m_128359_("branchFacing", this.branchFacing.m_122433_());
        if (this.isMaster()) {
            nbt.m_128405_("fluidAmount", this.fluidAmount);
            nbt.m_128359_("fluid", ForgeRegistries.FLUIDS.getKey((Object)this.fluid).toString());
            nbt.m_128405_("capacity", this.capacity);
            nbt.m_128405_("structureMinY", this.structureMinY);
            nbt.m_128405_("fishCount", this.fishCount);
            nbt.m_128405_("progress", this.progress);
            nbt.m_128405_("foodLevel", this.foodLevel);
            nbt.m_128405_("floorBlockCount", this.floorBlockCount);
            nbt.m_128405_("maxDecoSlots", this.maxDecoSlots);
            nbt.m_128405_("currentPage", this.currentPage);
            ContainerHelper.m_18973_((CompoundTag)nbt, this.items);
            CompoundTag decoTag = new CompoundTag();
            this.decorationPositions.forEach((slot, pos) -> decoTag.m_128365_(String.valueOf(slot), (Tag)NbtUtils.m_129224_((BlockPos)pos)));
            nbt.m_128365_("Decorations", (Tag)decoTag);
            ListTag occupancyList = new ListTag();
            this.decorationOccupancy.forEach((pos, id) -> {
                CompoundTag entry = new CompoundTag();
                entry.m_128365_("Pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
                entry.m_128359_("Id", id);
                occupancyList.add((Object)entry);
            });
            nbt.m_128365_("DecorationOccupancy", (Tag)occupancyList);
        }
        nbt.m_128365_("masterPos", (Tag)NbtUtils.m_129224_((BlockPos)this.masterPos));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.masterPos = NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("masterPos"));
        if (nbt.m_128441_("decorationType")) {
            this.decorationType = DecorationType.byName(nbt.m_128461_("decorationType"));
        }
        if (nbt.m_128441_("caveFacing")) {
            this.caveFacing = Direction.m_122402_((String)nbt.m_128461_("caveFacing"));
        }
        if (nbt.m_128441_("towerFacing")) {
            this.towerFacing = Direction.m_122402_((String)nbt.m_128461_("towerFacing"));
        }
        if (nbt.m_128441_("branchFacing")) {
            this.branchFacing = Direction.m_122402_((String)nbt.m_128461_("branchFacing"));
        }
        if (this.isMaster()) {
            this.fluidAmount = nbt.m_128451_("fluidAmount");
            this.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(nbt.m_128461_("fluid")));
            this.capacity = nbt.m_128451_("capacity");
            this.fishCount = nbt.m_128451_("fishCount");
            this.progress = nbt.m_128451_("progress");
            this.foodLevel = nbt.m_128451_("foodLevel");
            this.floorBlockCount = nbt.m_128451_("floorBlockCount");
            this.maxDecoSlots = nbt.m_128451_("maxDecoSlots");
            this.currentPage = nbt.m_128451_("currentPage");
            ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
            this.decorationPositions.clear();
            if (nbt.m_128441_("Decorations")) {
                CompoundTag decoTag = nbt.m_128469_("Decorations");
                for (String key : decoTag.m_128431_()) {
                    this.decorationPositions.put(Integer.parseInt(key), NbtUtils.m_129239_((CompoundTag)decoTag.m_128469_(key)));
                }
            }
            this.decorationOccupancy.clear();
            if (nbt.m_128425_("DecorationOccupancy", 9)) {
                ListTag occupancyList = nbt.m_128437_("DecorationOccupancy", 10);
                for (int i = 0; i < occupancyList.size(); ++i) {
                    CompoundTag entry = occupancyList.m_128728_(i);
                    BlockPos pos = NbtUtils.m_129239_((CompoundTag)entry.m_128469_("Pos"));
                    String id = entry.m_128461_("Id");
                    this.decorationOccupancy.put(pos, id);
                }
            }
        }
        if (this.f_58857_ != null && this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public boolean m_7013_(int slot, @NotNull ItemStack stack) {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.m_7013_(slot, stack);
            }
            return false;
        }
        if ((slot == 22 || slot >= 1 && slot <= 20) && !this.m_8020_(slot).m_41619_()) {
            return false;
        }
        if (slot == 22) {
            return stack.m_150930_(Items.f_41830_) || stack.m_150930_(Items.f_41832_) || stack.m_150930_(Items.f_41831_);
        }
        if (slot >= 1 && slot <= 20) {
            return this.getDecorationTypeFromItemStack(stack) != DecorationType.NONE;
        }
        if (slot == 0) {
            return FishTankBlockEntity.isFoodContainer(stack) || stack.m_150930_(Items.f_42576_);
        }
        if (slot == 21) {
            return false;
        }
        return false;
    }

    public int getFishCount() {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.getFishCount();
            }
            return 0;
        }
        return this.fishCount;
    }

    public void setFishCount(int count) {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                master.setFishCount(count);
            }
            return;
        }
        this.fishCount = count;
        this.m_6596_();
    }

    public void increaseFishCount() {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                master.increaseFishCount();
            }
            return;
        }
        ++this.fishCount;
        this.m_6596_();
    }

    public void decreaseFishCount() {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                master.decreaseFishCount();
            }
            return;
        }
        if (this.fishCount > 0) {
            --this.fishCount;
            this.m_6596_();
        }
    }

    public void synchronizeDecorations() {
        if (this.f_58857_ == null || !this.isMaster() || this.f_58857_.f_46443_) {
            return;
        }
        ArrayList<Integer> slotsToProcess = new ArrayList<Integer>(this.decorationPositions.keySet());
        for (Integer slot : slotsToProcess) {
            boolean isRegisteredAmethyst;
            DecorationType itemDecorationType;
            BlockPos registeredPos = this.decorationPositions.get(slot);
            ItemStack stackInSlot = this.m_8020_(slot);
            if (stackInSlot.m_41619_()) {
                this.removeDecorationForSlot(slot);
                continue;
            }
            DecorationType currentRegisteredType = DecorationType.NONE;
            BlockEntity blockEntity = this.f_58857_.m_7702_(registeredPos);
            if (blockEntity instanceof FishTankBlockEntity) {
                FishTankBlockEntity be = (FishTankBlockEntity)blockEntity;
                currentRegisteredType = be.getDecorationType();
            }
            boolean isSeagrassItem = (itemDecorationType = this.getDecorationTypeFromItemStack(stackInSlot)) == DecorationType.SEAGRASS;
            boolean isRegisteredSeagrass = currentRegisteredType == DecorationType.SEAGRASS || currentRegisteredType == DecorationType.SEAGRASS_BOTTOM || currentRegisteredType == DecorationType.SEAGRASS_TOP;
            boolean isKelpItem = itemDecorationType == DecorationType.KELP;
            boolean isRegisteredKelp = currentRegisteredType == DecorationType.KELP || currentRegisteredType == DecorationType.KELP_BOTTOM || currentRegisteredType == DecorationType.KELP_MIDDLE || currentRegisteredType == DecorationType.KELP_TOP;
            boolean isSeaPickleItem = itemDecorationType == DecorationType.SEA_PICKLE_1;
            boolean isRegisteredSeaPickle = currentRegisteredType == DecorationType.SEA_PICKLE_1 || currentRegisteredType == DecorationType.SEA_PICKLE_2 || currentRegisteredType == DecorationType.SEA_PICKLE_3 || currentRegisteredType == DecorationType.SEA_PICKLE_4;
            boolean isAmethystItem = itemDecorationType == DecorationType.AMETHYST_1;
            boolean bl = isRegisteredAmethyst = currentRegisteredType == DecorationType.AMETHYST_1 || currentRegisteredType == DecorationType.AMETHYST_2 || currentRegisteredType == DecorationType.AMETHYST_3 || currentRegisteredType == DecorationType.AMETHYST_4;
            if (isSeagrassItem && isRegisteredSeagrass || isKelpItem && isRegisteredKelp || isSeaPickleItem && isRegisteredSeaPickle || isAmethystItem && isRegisteredAmethyst || itemDecorationType == currentRegisteredType) continue;
            this.removeDecorationForSlot(slot);
            if (itemDecorationType == DecorationType.NONE) continue;
            this.addDecorationForSlot(slot, stackInSlot);
        }
        for (int i = 1; i <= 20; ++i) {
            ItemStack stackInSlot;
            DecorationType itemDecorationType;
            if (this.decorationPositions.containsKey(i) || (itemDecorationType = this.getDecorationTypeFromItemStack(stackInSlot = this.m_8020_(i))) == DecorationType.NONE) continue;
            this.addDecorationForSlot(i, stackInSlot);
        }
    }

    public void addDecorationForSlot(int slot, ItemStack stack) {
        if (this.f_58857_ == null || !this.isMaster()) {
            return;
        }
        DecorationType type = this.getDecorationTypeFromItemStack(stack);
        if (type == DecorationType.NONE) {
            LOGGER.warn("Attempted to add unrecognized decoration item: {}", (Object)stack.m_41720_().toString());
            return;
        }
        if (type.m_7912_().startsWith("structure_cave")) {
            this.addCaveVariantDecoration(slot, type);
        } else if (type.m_7912_().startsWith("small_stone")) {
            this.addMultiBlockDecoration(slot, type, 1, 2, 1);
        } else if (type.m_7912_().startsWith("tiny_stone")) {
            this.addSingleBlockDecoration(slot, type);
        } else if (type.m_7912_().startsWith("tiny_branch")) {
            this.addSingleBlockDecoration(slot, type);
        } else if (type.m_7912_().startsWith("small_branch")) {
            this.addMultiBlockDecoration(slot, type, 1, 2, 1);
        } else if (type.m_7912_().startsWith("medium_branch")) {
            this.addMultiBlockDecoration(slot, type, 2, 1, 1);
        } else if (type.m_7912_().startsWith("shipwreck")) {
            this.addSingleBlockDecoration(slot, type);
        } else if (type.m_7912_().startsWith("tower")) {
            this.addMultiBlockDecoration(slot, type, 1, 2, 1);
        } else if (type == DecorationType.SEAGRASS) {
            this.addSeagrassDecoration(slot);
        } else if (type == DecorationType.KELP) {
            this.addKelpDecoration(slot);
        } else if (type.m_7912_().startsWith("sea_pickle")) {
            this.addSeaPickleDecoration(slot);
        } else if (type.m_7912_().startsWith("amethyst")) {
            this.addAmethystDecoration(slot);
        } else if (type == DecorationType.DRIPSTONE) {
            this.addDripstoneDecoration(slot);
        } else if (type.m_7912_().startsWith("coral")) {
            this.addCoralDecoration(slot, type);
        }
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    public DecorationType getDecorationTypeFromItemStack(ItemStack stack) {
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_STONE_AMETHYST.get())) {
            return DecorationType.STRUCTURE_CAVE_STONE_AMETHYST;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_STONE_DIAMOND.get())) {
            return DecorationType.STRUCTURE_CAVE_STONE_DIAMOND;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_STONE_EMERALD.get())) {
            return DecorationType.STRUCTURE_CAVE_STONE_EMERALD;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_STONE_LAPIS.get())) {
            return DecorationType.STRUCTURE_CAVE_STONE_LAPIS;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_STONE_REDSTONE.get())) {
            return DecorationType.STRUCTURE_CAVE_STONE_REDSTONE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_GRANITE_AMETHYST.get())) {
            return DecorationType.STRUCTURE_CAVE_GRANITE_AMETHYST;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_GRANITE_DIAMOND.get())) {
            return DecorationType.STRUCTURE_CAVE_GRANITE_DIAMOND;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_GRANITE_EMERALD.get())) {
            return DecorationType.STRUCTURE_CAVE_GRANITE_EMERALD;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_GRANITE_LAPIS.get())) {
            return DecorationType.STRUCTURE_CAVE_GRANITE_LAPIS;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_GRANITE_REDSTONE.get())) {
            return DecorationType.STRUCTURE_CAVE_GRANITE_REDSTONE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_DIORITE_AMETHYST.get())) {
            return DecorationType.STRUCTURE_CAVE_DIORITE_AMETHYST;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_DIORITE_DIAMOND.get())) {
            return DecorationType.STRUCTURE_CAVE_DIORITE_DIAMOND;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_DIORITE_EMERALD.get())) {
            return DecorationType.STRUCTURE_CAVE_DIORITE_EMERALD;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_DIORITE_LAPIS.get())) {
            return DecorationType.STRUCTURE_CAVE_DIORITE_LAPIS;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_DIORITE_REDSTONE.get())) {
            return DecorationType.STRUCTURE_CAVE_DIORITE_REDSTONE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_ANDESITE_AMETHYST.get())) {
            return DecorationType.STRUCTURE_CAVE_ANDESITE_AMETHYST;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_ANDESITE_DIAMOND.get())) {
            return DecorationType.STRUCTURE_CAVE_ANDESITE_DIAMOND;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_ANDESITE_EMERALD.get())) {
            return DecorationType.STRUCTURE_CAVE_ANDESITE_EMERALD;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_ANDESITE_LAPIS.get())) {
            return DecorationType.STRUCTURE_CAVE_ANDESITE_LAPIS;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_ANDESITE_REDSTONE.get())) {
            return DecorationType.STRUCTURE_CAVE_ANDESITE_REDSTONE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_DEEPSLATE_AMETHYST.get())) {
            return DecorationType.STRUCTURE_CAVE_DEEPSLATE_AMETHYST;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_DEEPSLATE_DIAMOND.get())) {
            return DecorationType.STRUCTURE_CAVE_DEEPSLATE_DIAMOND;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_DEEPSLATE_EMERALD.get())) {
            return DecorationType.STRUCTURE_CAVE_DEEPSLATE_EMERALD;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_DEEPSLATE_LAPIS.get())) {
            return DecorationType.STRUCTURE_CAVE_DEEPSLATE_LAPIS;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_DEEPSLATE_REDSTONE.get())) {
            return DecorationType.STRUCTURE_CAVE_DEEPSLATE_REDSTONE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_TUFF_AMETHYST.get())) {
            return DecorationType.STRUCTURE_CAVE_TUFF_AMETHYST;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_TUFF_DIAMOND.get())) {
            return DecorationType.STRUCTURE_CAVE_TUFF_DIAMOND;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_TUFF_EMERALD.get())) {
            return DecorationType.STRUCTURE_CAVE_TUFF_EMERALD;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_TUFF_LAPIS.get())) {
            return DecorationType.STRUCTURE_CAVE_TUFF_LAPIS;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_TUFF_REDSTONE.get())) {
            return DecorationType.STRUCTURE_CAVE_TUFF_REDSTONE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_CALCITE_AMETHYST.get())) {
            return DecorationType.STRUCTURE_CAVE_CALCITE_AMETHYST;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_CALCITE_DIAMOND.get())) {
            return DecorationType.STRUCTURE_CAVE_CALCITE_DIAMOND;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_CALCITE_EMERALD.get())) {
            return DecorationType.STRUCTURE_CAVE_CALCITE_EMERALD;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_CALCITE_LAPIS.get())) {
            return DecorationType.STRUCTURE_CAVE_CALCITE_LAPIS;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_CALCITE_REDSTONE.get())) {
            return DecorationType.STRUCTURE_CAVE_CALCITE_REDSTONE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_DRIPSTONE_BLOCK_AMETHYST.get())) {
            return DecorationType.STRUCTURE_CAVE_DRIPSTONE_BLOCK_AMETHYST;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_DRIPSTONE_BLOCK_DIAMOND.get())) {
            return DecorationType.STRUCTURE_CAVE_DRIPSTONE_BLOCK_DIAMOND;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_DRIPSTONE_BLOCK_EMERALD.get())) {
            return DecorationType.STRUCTURE_CAVE_DRIPSTONE_BLOCK_EMERALD;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_DRIPSTONE_BLOCK_LAPIS.get())) {
            return DecorationType.STRUCTURE_CAVE_DRIPSTONE_BLOCK_LAPIS;
        }
        if (stack.m_150930_((Item)ModItems.DECO_STRUCTURE_CAVE_DRIPSTONE_BLOCK_REDSTONE.get())) {
            return DecorationType.STRUCTURE_CAVE_DRIPSTONE_BLOCK_REDSTONE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_STONE_STONE.get())) {
            return DecorationType.TINY_STONE_STONE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_STONE_GRANITE.get())) {
            return DecorationType.TINY_STONE_GRANITE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_STONE_DIORITE.get())) {
            return DecorationType.TINY_STONE_DIORITE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_STONE_ANDESITE.get())) {
            return DecorationType.TINY_STONE_ANDESITE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_STONE_DEEPSLATE.get())) {
            return DecorationType.TINY_STONE_DEEPSLATE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_STONE_TUFF.get())) {
            return DecorationType.TINY_STONE_TUFF;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_STONE_CALCITE.get())) {
            return DecorationType.TINY_STONE_CALCITE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_STONE_DRIPSTONE_BLOCK.get())) {
            return DecorationType.TINY_STONE_DRIPSTONE_BLOCK;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_STONE_STONE.get())) {
            return DecorationType.SMALL_STONE_STONE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_STONE_GRANITE.get())) {
            return DecorationType.SMALL_STONE_GRANITE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_STONE_DIORITE.get())) {
            return DecorationType.SMALL_STONE_DIORITE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_STONE_ANDESITE.get())) {
            return DecorationType.SMALL_STONE_ANDESITE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_STONE_DEEPSLATE.get())) {
            return DecorationType.SMALL_STONE_DEEPSLATE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_STONE_TUFF.get())) {
            return DecorationType.SMALL_STONE_TUFF;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_STONE_CALCITE.get())) {
            return DecorationType.SMALL_STONE_CALCITE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_STONE_DRIPSTONE_BLOCK.get())) {
            return DecorationType.SMALL_STONE_DRIPSTONE_BLOCK;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_BRANCH_OAK.get())) {
            return DecorationType.TINY_BRANCH_OAK;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_BRANCH_SPRUCE.get())) {
            return DecorationType.TINY_BRANCH_SPRUCE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_BRANCH_BIRCH.get())) {
            return DecorationType.TINY_BRANCH_BIRCH;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_BRANCH_JUNGLE.get())) {
            return DecorationType.TINY_BRANCH_JUNGLE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_BRANCH_ACACIA.get())) {
            return DecorationType.TINY_BRANCH_ACACIA;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_BRANCH_DARK_OAK.get())) {
            return DecorationType.TINY_BRANCH_DARK_OAK;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_BRANCH_MANGROVE.get())) {
            return DecorationType.TINY_BRANCH_MANGROVE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_BRANCH_CHERRY.get())) {
            return DecorationType.TINY_BRANCH_CHERRY;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_BRANCH_BAMBOO.get())) {
            return DecorationType.TINY_BRANCH_BAMBOO;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_BRANCH_STRIPPED_OAK.get())) {
            return DecorationType.TINY_BRANCH_STRIPPED_OAK;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_BRANCH_STRIPPED_SPRUCE.get())) {
            return DecorationType.TINY_BRANCH_STRIPPED_SPRUCE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_BRANCH_STRIPPED_BIRCH.get())) {
            return DecorationType.TINY_BRANCH_STRIPPED_BIRCH;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_BRANCH_STRIPPED_JUNGLE.get())) {
            return DecorationType.TINY_BRANCH_STRIPPED_JUNGLE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_BRANCH_STRIPPED_ACACIA.get())) {
            return DecorationType.TINY_BRANCH_STRIPPED_ACACIA;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_BRANCH_STRIPPED_DARK_OAK.get())) {
            return DecorationType.TINY_BRANCH_STRIPPED_DARK_OAK;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_BRANCH_STRIPPED_MANGROVE.get())) {
            return DecorationType.TINY_BRANCH_STRIPPED_MANGROVE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_BRANCH_STRIPPED_CHERRY.get())) {
            return DecorationType.TINY_BRANCH_STRIPPED_CHERRY;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TINY_BRANCH_STRIPPED_BAMBOO.get())) {
            return DecorationType.TINY_BRANCH_STRIPPED_BAMBOO;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_BRANCH_OAK.get())) {
            return DecorationType.SMALL_BRANCH_OAK;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_BRANCH_SPRUCE.get())) {
            return DecorationType.SMALL_BRANCH_SPRUCE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_BRANCH_BIRCH.get())) {
            return DecorationType.SMALL_BRANCH_BIRCH;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_BRANCH_JUNGLE.get())) {
            return DecorationType.SMALL_BRANCH_JUNGLE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_BRANCH_ACACIA.get())) {
            return DecorationType.SMALL_BRANCH_ACACIA;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_BRANCH_DARK_OAK.get())) {
            return DecorationType.SMALL_BRANCH_DARK_OAK;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_BRANCH_MANGROVE.get())) {
            return DecorationType.SMALL_BRANCH_MANGROVE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_BRANCH_CHERRY.get())) {
            return DecorationType.SMALL_BRANCH_CHERRY;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_BRANCH_BAMBOO.get())) {
            return DecorationType.SMALL_BRANCH_BAMBOO;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_BRANCH_STRIPPED_OAK.get())) {
            return DecorationType.SMALL_BRANCH_STRIPPED_OAK;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_BRANCH_STRIPPED_SPRUCE.get())) {
            return DecorationType.SMALL_BRANCH_STRIPPED_SPRUCE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_BRANCH_STRIPPED_BIRCH.get())) {
            return DecorationType.SMALL_BRANCH_STRIPPED_BIRCH;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_BRANCH_STRIPPED_JUNGLE.get())) {
            return DecorationType.SMALL_BRANCH_STRIPPED_JUNGLE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_BRANCH_STRIPPED_ACACIA.get())) {
            return DecorationType.SMALL_BRANCH_STRIPPED_ACACIA;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_BRANCH_STRIPPED_DARK_OAK.get())) {
            return DecorationType.SMALL_BRANCH_STRIPPED_DARK_OAK;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_BRANCH_STRIPPED_MANGROVE.get())) {
            return DecorationType.SMALL_BRANCH_STRIPPED_MANGROVE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_BRANCH_STRIPPED_CHERRY.get())) {
            return DecorationType.SMALL_BRANCH_STRIPPED_CHERRY;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SMALL_BRANCH_STRIPPED_BAMBOO.get())) {
            return DecorationType.SMALL_BRANCH_STRIPPED_BAMBOO;
        }
        if (stack.m_150930_((Item)ModItems.DECO_MEDIUM_BRANCH_OAK.get())) {
            return DecorationType.MEDIUM_BRANCH_OAK;
        }
        if (stack.m_150930_((Item)ModItems.DECO_MEDIUM_BRANCH_SPRUCE.get())) {
            return DecorationType.MEDIUM_BRANCH_SPRUCE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_MEDIUM_BRANCH_BIRCH.get())) {
            return DecorationType.MEDIUM_BRANCH_BIRCH;
        }
        if (stack.m_150930_((Item)ModItems.DECO_MEDIUM_BRANCH_JUNGLE.get())) {
            return DecorationType.MEDIUM_BRANCH_JUNGLE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_MEDIUM_BRANCH_ACACIA.get())) {
            return DecorationType.MEDIUM_BRANCH_ACACIA;
        }
        if (stack.m_150930_((Item)ModItems.DECO_MEDIUM_BRANCH_DARK_OAK.get())) {
            return DecorationType.MEDIUM_BRANCH_DARK_OAK;
        }
        if (stack.m_150930_((Item)ModItems.DECO_MEDIUM_BRANCH_MANGROVE.get())) {
            return DecorationType.MEDIUM_BRANCH_MANGROVE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_MEDIUM_BRANCH_CHERRY.get())) {
            return DecorationType.MEDIUM_BRANCH_CHERRY;
        }
        if (stack.m_150930_((Item)ModItems.DECO_MEDIUM_BRANCH_BAMBOO.get())) {
            return DecorationType.MEDIUM_BRANCH_BAMBOO;
        }
        if (stack.m_150930_((Item)ModItems.DECO_MEDIUM_BRANCH_STRIPPED_OAK.get())) {
            return DecorationType.MEDIUM_BRANCH_STRIPPED_OAK;
        }
        if (stack.m_150930_((Item)ModItems.DECO_MEDIUM_BRANCH_STRIPPED_SPRUCE.get())) {
            return DecorationType.MEDIUM_BRANCH_STRIPPED_SPRUCE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_MEDIUM_BRANCH_STRIPPED_BIRCH.get())) {
            return DecorationType.MEDIUM_BRANCH_STRIPPED_BIRCH;
        }
        if (stack.m_150930_((Item)ModItems.DECO_MEDIUM_BRANCH_STRIPPED_JUNGLE.get())) {
            return DecorationType.MEDIUM_BRANCH_STRIPPED_JUNGLE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_MEDIUM_BRANCH_STRIPPED_ACACIA.get())) {
            return DecorationType.MEDIUM_BRANCH_STRIPPED_ACACIA;
        }
        if (stack.m_150930_((Item)ModItems.DECO_MEDIUM_BRANCH_STRIPPED_DARK_OAK.get())) {
            return DecorationType.MEDIUM_BRANCH_STRIPPED_DARK_OAK;
        }
        if (stack.m_150930_((Item)ModItems.DECO_MEDIUM_BRANCH_STRIPPED_MANGROVE.get())) {
            return DecorationType.MEDIUM_BRANCH_STRIPPED_MANGROVE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_MEDIUM_BRANCH_STRIPPED_CHERRY.get())) {
            return DecorationType.MEDIUM_BRANCH_STRIPPED_CHERRY;
        }
        if (stack.m_150930_((Item)ModItems.DECO_MEDIUM_BRANCH_STRIPPED_BAMBOO.get())) {
            return DecorationType.MEDIUM_BRANCH_STRIPPED_BAMBOO;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SHIPWRECK_STRIPPED_OAK.get())) {
            return DecorationType.SHIPWRECK_STRIPPED_OAK;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SHIPWRECK_STRIPPED_SPRUCE.get())) {
            return DecorationType.SHIPWRECK_STRIPPED_SPRUCE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SHIPWRECK_STRIPPED_BIRCH.get())) {
            return DecorationType.SHIPWRECK_STRIPPED_BIRCH;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SHIPWRECK_STRIPPED_JUNGLE.get())) {
            return DecorationType.SHIPWRECK_STRIPPED_JUNGLE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SHIPWRECK_STRIPPED_ACACIA.get())) {
            return DecorationType.SHIPWRECK_STRIPPED_ACACIA;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SHIPWRECK_STRIPPED_DARK_OAK.get())) {
            return DecorationType.SHIPWRECK_STRIPPED_DARK_OAK;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SHIPWRECK_STRIPPED_MANGROVE.get())) {
            return DecorationType.SHIPWRECK_STRIPPED_MANGROVE;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SHIPWRECK_STRIPPED_CHERRY.get())) {
            return DecorationType.SHIPWRECK_STRIPPED_CHERRY;
        }
        if (stack.m_150930_((Item)ModItems.DECO_SHIPWRECK_STRIPPED_BAMBOO.get())) {
            return DecorationType.SHIPWRECK_STRIPPED_BAMBOO;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TOWER_STONE_BRICKS.get())) {
            return DecorationType.TOWER_STONE_BRICKS;
        }
        if (stack.m_150930_((Item)ModItems.DECO_TOWER_MOSSY_STONE_BRICKS.get())) {
            return DecorationType.TOWER_MOSSY_STONE_BRICKS;
        }
        if (stack.m_150930_(Items.f_41867_)) {
            return DecorationType.SEAGRASS;
        }
        if (stack.m_150930_(Items.f_41910_)) {
            return DecorationType.KELP;
        }
        if (stack.m_150930_(Items.f_41868_)) {
            return DecorationType.SEA_PICKLE_1;
        }
        if (stack.m_150930_(Items.f_151049_)) {
            return DecorationType.AMETHYST_1;
        }
        if (stack.m_150930_(Items.f_151087_)) {
            return DecorationType.DRIPSTONE;
        }
        if (stack.m_150930_(Items.f_42291_)) {
            return DecorationType.CORAL_BRAIN;
        }
        if (stack.m_150930_(Items.f_42292_)) {
            return DecorationType.CORAL_BUBBLE;
        }
        if (stack.m_150930_(Items.f_42293_)) {
            return DecorationType.CORAL_FIRE;
        }
        if (stack.m_150930_(Items.f_42294_)) {
            return DecorationType.CORAL_HORN;
        }
        if (stack.m_150930_(Items.f_42290_)) {
            return DecorationType.CORAL_TUBE;
        }
        return DecorationType.NONE;
    }

    private void addSingleBlockDecoration(int slot, DecorationType type) {
        if (this.f_58857_ == null || !this.isMaster()) {
            return;
        }
        List<BlockPos> floorPositions = this.getValidFloorPositions();
        if (floorPositions.isEmpty()) {
            return;
        }
        BlockPos basePos = floorPositions.get(this.f_58857_.f_46441_.m_188503_(floorPositions.size()));
        BlockEntity blockEntity = this.f_58857_.m_7702_(basePos);
        if (blockEntity instanceof FishTankBlockEntity) {
            FishTankBlockEntity be = (FishTankBlockEntity)blockEntity;
            be.setDecorationType(type);
            this.decorationPositions.put(slot, basePos);
            this.decorationOccupancy.put(basePos, type.m_7912_() + "_" + basePos.m_123344_());
        }
    }

    private void addMultiBlockDecoration(int slot, DecorationType type, int width, int height, int depth) {
        if (this.f_58857_ == null || !this.isMaster()) {
            return;
        }
        List<BlockPos> floorPositions = this.getValidFloorPositions();
        if (floorPositions.isEmpty()) {
            return;
        }
        Collections.shuffle(floorPositions, new Random());
        BlockPos foundBasePos = null;
        ArrayList<BlockPos> occupiedBlocks = new ArrayList<BlockPos>();
        for (BlockPos basePos : floorPositions) {
            boolean canPlace = true;
            occupiedBlocks.clear();
            occupiedBlocks.add(basePos);
            if (width > 1) {
                BlockPos widthNeighbor = basePos.m_121945_(this.playerFacing.m_122427_());
                if (!floorPositions.contains(widthNeighbor) || this.decorationOccupancy.containsKey(widthNeighbor)) {
                    canPlace = false;
                } else {
                    occupiedBlocks.add(widthNeighbor);
                }
            }
            if (depth > 1) {
                BlockPos depthNeighbor = basePos.m_121945_(this.playerFacing);
                if (!floorPositions.contains(depthNeighbor) || this.decorationOccupancy.containsKey(depthNeighbor)) {
                    canPlace = false;
                } else {
                    occupiedBlocks.add(depthNeighbor);
                }
            }
            if (height > 1) {
                for (int i = 1; i < height; ++i) {
                    BlockPos heightBlock = basePos.m_6630_(i);
                    if (!this.structureBlocks.contains(heightBlock) || this.decorationOccupancy.containsKey(heightBlock)) {
                        canPlace = false;
                        break;
                    }
                    occupiedBlocks.add(heightBlock);
                }
            }
            if (!canPlace) continue;
            foundBasePos = basePos;
            break;
        }
        if (foundBasePos == null) {
            LOGGER.info("Could not find a valid spot for multi-block decoration: {}", (Object)type.m_7912_());
            return;
        }
        String decorationId = type.m_7912_() + "_" + foundBasePos.m_123344_();
        this.decorationPositions.put(slot, foundBasePos);
        for (BlockPos pos : occupiedBlocks) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof FishTankBlockEntity)) continue;
            FishTankBlockEntity be = (FishTankBlockEntity)blockEntity;
            if (pos.equals((Object)foundBasePos)) {
                be.setDecorationType(type);
                if (type.m_7912_().startsWith("tower")) {
                    be.setTowerFacing(this.playerFacing);
                }
            } else if (type.m_7912_().startsWith("structure_cave")) {
                be.setDecorationType(DecorationType.STRUCTURE_CAVE_PART);
            } else if (type.m_7912_().startsWith("shipwreck")) {
                be.setDecorationType(DecorationType.STRUCTURE_SHIPWRECK_PART);
            } else if (type.m_7912_().startsWith("tower")) {
                be.setDecorationType(DecorationType.STRUCTURE_TOWER_PART);
            }
            this.decorationOccupancy.put(pos, decorationId);
        }
    }

    private void addCaveVariantDecoration(int slot, DecorationType type) {
        if (this.f_58857_ == null || !this.isMaster()) {
            return;
        }
        List<BlockPos> floorPositions = this.getValidFloorPositions();
        if (floorPositions.size() < 2) {
            LOGGER.info("Could not place cave decoration via GUI: Not enough valid floor positions.");
            return;
        }
        Collections.shuffle(floorPositions, new Random());
        BlockPos basePos = null;
        BlockPos neighborPos = null;
        Direction neighborDirection = this.playerFacing.m_122427_();
        for (BlockPos currentPos : floorPositions) {
            BlockPos potentialNeighbor = currentPos.m_121945_(neighborDirection);
            if (!floorPositions.contains(potentialNeighbor)) continue;
            basePos = currentPos;
            neighborPos = potentialNeighbor;
            break;
        }
        if (basePos == null) {
            LOGGER.info("Could not find a valid spot for the cave with a partner block to the right.");
            return;
        }
        String decorationId = type.m_7912_() + "_" + basePos.m_123344_();
        Direction caveFacing = this.playerFacing;
        BlockEntity blockEntity = this.f_58857_.m_7702_(basePos);
        if (blockEntity instanceof FishTankBlockEntity) {
            FishTankBlockEntity baseBe = (FishTankBlockEntity)blockEntity;
            baseBe.setDecorationType(type);
            baseBe.setCaveFacing(caveFacing);
        }
        if ((blockEntity = this.f_58857_.m_7702_(neighborPos)) instanceof FishTankBlockEntity) {
            FishTankBlockEntity neighborBe = (FishTankBlockEntity)blockEntity;
            neighborBe.setDecorationType(DecorationType.STRUCTURE_CAVE_PART);
            neighborBe.setCaveFacing(Direction.NORTH);
        }
        this.decorationPositions.put(slot, basePos);
        this.decorationOccupancy.put(basePos, decorationId);
        this.decorationOccupancy.put(neighborPos, decorationId);
        LOGGER.info("Cave decoration placed via GUI at {} with neighbor {}", (Object)basePos, (Object)neighborPos);
    }

    public void markDecorationsAsOccupied(String decorationId, BlockPos ... positions) {
        BlockEntity blockEntity;
        if (!this.isMaster() && this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
            FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
            master.markDecorationsAsOccupied(decorationId, positions);
            return;
        }
        if (positions.length == 0) {
            return;
        }
        for (BlockPos pos : positions) {
            this.decorationOccupancy.put(pos, decorationId);
            LOGGER.info("Position {} marked as occupied with ID {}", (Object)pos, (Object)decorationId);
        }
        for (int i = 1; i <= 20; ++i) {
            if (this.decorationPositions.containsKey(i)) continue;
            this.decorationPositions.put(i, positions[0]);
            break;
        }
        this.m_6596_();
    }

    public void removeDecorationForSlot(int slot) {
        String decorationId;
        if (this.f_58857_ == null || !this.isMaster()) {
            return;
        }
        BlockPos basePos = this.decorationPositions.remove(slot);
        if (basePos != null && (decorationId = this.decorationOccupancy.get(basePos)) != null) {
            List positionsToRemove = this.decorationOccupancy.entrySet().stream().filter(entry -> decorationId.equals(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
            for (BlockPos pos : positionsToRemove) {
                this.decorationOccupancy.remove(pos);
                BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
                if (!(blockEntity instanceof FishTankBlockEntity)) continue;
                FishTankBlockEntity targetBe = (FishTankBlockEntity)blockEntity;
                targetBe.setDecorationType(DecorationType.NONE);
                targetBe.setCaveFacing(Direction.NORTH);
                targetBe.setTowerFacing(Direction.NORTH);
                targetBe.setBranchFacing(Direction.NORTH);
            }
        }
        this.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private void addKelpDecoration(int slot) {
        if (this.f_58857_ == null || !this.isMaster()) {
            return;
        }
        List floorPositions = this.structureBlocks.stream().filter(p -> p.m_123342_() == this.structureMinY && !this.decorationOccupancy.containsKey(p)).collect(Collectors.toList());
        if (floorPositions.isEmpty()) {
            return;
        }
        BlockPos basePos = (BlockPos)floorPositions.get(this.f_58857_.f_46441_.m_188503_(floorPositions.size()));
        String decorationId = "kelp_" + basePos.m_123344_();
        BlockPos currentPos = basePos;
        BlockPos lastPos = null;
        while (this.structureBlocks.contains(currentPos) && !this.decorationOccupancy.containsKey(currentPos)) {
            this.decorationOccupancy.put(currentPos, decorationId);
            if (lastPos == null) {
                this.decorationPositions.put(slot, currentPos);
            }
            lastPos = currentPos;
            if (this.f_58857_.f_46441_.m_188501_() > 0.5f) break;
            currentPos = currentPos.m_7494_();
        }
        if (lastPos != null) {
            if (lastPos.equals((Object)basePos)) {
                BlockEntity blockEntity = this.f_58857_.m_7702_(basePos);
                if (blockEntity instanceof FishTankBlockEntity) {
                    FishTankBlockEntity be = (FishTankBlockEntity)blockEntity;
                    be.setDecorationType(DecorationType.KELP);
                }
            } else {
                BlockPos.MutableBlockPos iterPos = new BlockPos.MutableBlockPos().m_122190_((Vec3i)basePos);
                while (iterPos.m_123342_() <= lastPos.m_123342_()) {
                    BlockEntity blockEntity = this.f_58857_.m_7702_((BlockPos)iterPos);
                    if (blockEntity instanceof FishTankBlockEntity) {
                        FishTankBlockEntity be = (FishTankBlockEntity)blockEntity;
                        if (iterPos.equals((Object)basePos)) {
                            be.setDecorationType(DecorationType.KELP_BOTTOM);
                        } else if (iterPos.equals((Object)lastPos)) {
                            be.setDecorationType(DecorationType.KELP_TOP);
                        } else {
                            be.setDecorationType(DecorationType.KELP_MIDDLE);
                        }
                    }
                    iterPos.m_122173_(Direction.UP);
                }
            }
        }
        this.m_6596_();
    }

    private void addSeaPickleDecoration(int slot) {
        if (this.f_58857_ == null || !this.isMaster()) {
            return;
        }
        List floorPositions = this.structureBlocks.stream().filter(p -> p.m_123342_() == this.structureMinY && !this.decorationOccupancy.containsKey(p)).collect(Collectors.toList());
        if (floorPositions.isEmpty()) {
            return;
        }
        BlockPos basePos = (BlockPos)floorPositions.get(this.f_58857_.f_46441_.m_188503_(floorPositions.size()));
        int pickleCount = this.f_58857_.f_46441_.m_188503_(4) + 1;
        DecorationType decorationType = switch (pickleCount) {
            case 1 -> DecorationType.SEA_PICKLE_1;
            case 2 -> DecorationType.SEA_PICKLE_2;
            case 3 -> DecorationType.SEA_PICKLE_3;
            default -> DecorationType.SEA_PICKLE_4;
        };
        BlockEntity blockEntity = this.f_58857_.m_7702_(basePos);
        if (blockEntity instanceof FishTankBlockEntity) {
            FishTankBlockEntity be = (FishTankBlockEntity)blockEntity;
            be.setDecorationType(decorationType);
            this.decorationPositions.put(slot, basePos);
            this.decorationOccupancy.put(basePos, "sea_pickle_" + basePos.m_123344_());
        }
        this.m_6596_();
    }

    private void addAmethystDecoration(int slot) {
        if (this.f_58857_ == null || !this.isMaster()) {
            return;
        }
        List floorPositions = this.structureBlocks.stream().filter(p -> p.m_123342_() == this.structureMinY && !this.decorationOccupancy.containsKey(p)).collect(Collectors.toList());
        if (floorPositions.isEmpty()) {
            return;
        }
        BlockPos basePos = (BlockPos)floorPositions.get(this.f_58857_.f_46441_.m_188503_(floorPositions.size()));
        int amethystCount = this.f_58857_.f_46441_.m_188503_(4) + 1;
        DecorationType decorationType = switch (amethystCount) {
            case 1 -> DecorationType.AMETHYST_1;
            case 2 -> DecorationType.AMETHYST_2;
            case 3 -> DecorationType.AMETHYST_3;
            default -> DecorationType.AMETHYST_4;
        };
        BlockEntity blockEntity = this.f_58857_.m_7702_(basePos);
        if (blockEntity instanceof FishTankBlockEntity) {
            FishTankBlockEntity be = (FishTankBlockEntity)blockEntity;
            be.setDecorationType(decorationType);
            this.decorationPositions.put(slot, basePos);
            this.decorationOccupancy.put(basePos, "amethyst_" + basePos.m_123344_());
        }
        this.m_6596_();
    }

    private void addDripstoneDecoration(int slot) {
        if (this.f_58857_ == null || !this.isMaster()) {
            return;
        }
        List floorPositions = this.structureBlocks.stream().filter(p -> p.m_123342_() == this.structureMinY && !this.decorationOccupancy.containsKey(p)).collect(Collectors.toList());
        if (floorPositions.isEmpty()) {
            return;
        }
        BlockPos basePos = (BlockPos)floorPositions.get(this.f_58857_.f_46441_.m_188503_(floorPositions.size()));
        BlockEntity blockEntity = this.f_58857_.m_7702_(basePos);
        if (blockEntity instanceof FishTankBlockEntity) {
            FishTankBlockEntity be = (FishTankBlockEntity)blockEntity;
            be.setDecorationType(DecorationType.DRIPSTONE);
            this.decorationPositions.put(slot, basePos);
            this.decorationOccupancy.put(basePos, "dripstone_" + basePos.m_123344_());
        }
        this.m_6596_();
    }

    private void addCoralDecoration(int slot, DecorationType coralType) {
        if (this.f_58857_ == null || !this.isMaster()) {
            return;
        }
        List floorPositions = this.structureBlocks.stream().filter(p -> p.m_123342_() == this.structureMinY && !this.decorationOccupancy.containsKey(p)).collect(Collectors.toList());
        if (floorPositions.isEmpty()) {
            return;
        }
        BlockPos basePos = (BlockPos)floorPositions.get(this.f_58857_.f_46441_.m_188503_(floorPositions.size()));
        BlockEntity blockEntity = this.f_58857_.m_7702_(basePos);
        if (blockEntity instanceof FishTankBlockEntity) {
            FishTankBlockEntity be = (FishTankBlockEntity)blockEntity;
            be.setDecorationType(coralType);
            this.decorationPositions.put(slot, basePos);
            this.decorationOccupancy.put(basePos, "coral_" + coralType.m_7912_() + "_" + basePos.m_123344_());
        }
        this.m_6596_();
    }

    private void addSeagrassDecoration(int slot) {
        if (this.f_58857_ == null || !this.isMaster()) {
            return;
        }
        List floorPositions = this.structureBlocks.stream().filter(p -> p.m_123342_() == this.structureMinY && !this.decorationOccupancy.containsKey(p)).collect(Collectors.toList());
        if (floorPositions.isEmpty()) {
            return;
        }
        BlockPos basePos = (BlockPos)floorPositions.get(this.f_58857_.f_46441_.m_188503_(floorPositions.size()));
        boolean isTall = this.f_58857_.f_46441_.m_188501_() < 0.5f;
        BlockPos topPos = basePos.m_7494_();
        if (isTall && this.structureBlocks.contains(topPos) && !this.decorationOccupancy.containsKey(topPos)) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(basePos);
            if (blockEntity instanceof FishTankBlockEntity) {
                FishTankBlockEntity bottomBe = (FishTankBlockEntity)blockEntity;
                blockEntity = this.f_58857_.m_7702_(topPos);
                if (blockEntity instanceof FishTankBlockEntity) {
                    FishTankBlockEntity topBe = (FishTankBlockEntity)blockEntity;
                    bottomBe.setDecorationType(DecorationType.SEAGRASS_BOTTOM);
                    topBe.setDecorationType(DecorationType.SEAGRASS_TOP);
                    String decorationId = "seagrass_" + basePos.m_123344_();
                    this.decorationPositions.put(slot, basePos);
                    this.decorationOccupancy.put(basePos, decorationId);
                    this.decorationOccupancy.put(topPos, decorationId);
                }
            }
        } else {
            BlockEntity blockEntity = this.f_58857_.m_7702_(basePos);
            if (blockEntity instanceof FishTankBlockEntity) {
                FishTankBlockEntity be = (FishTankBlockEntity)blockEntity;
                be.setDecorationType(DecorationType.SEAGRASS);
                this.decorationPositions.put(slot, basePos);
                this.decorationOccupancy.put(basePos, "seagrass_" + basePos.m_123344_());
            }
        }
        this.m_6596_();
    }

    public String getFormattedWaterLevel() {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.getFormattedWaterLevel();
            }
            return "0%";
        }
        switch ((ModConfig.WaterUnit)((Object)ModConfig.Server.waterDisplayUnit.get())) {
            case BUCKETS: {
                double buckets = (double)this.fluidAmount / 1000.0;
                return String.format("%.1fB", buckets);
            }
            case MILLIBUCKETS: {
                return String.format("%dmB", this.fluidAmount);
            }
        }
        float percent = this.capacity > 0 ? (float)this.fluidAmount / (float)this.capacity * 100.0f : 0.0f;
        return String.format("%.0f%%", Float.valueOf(percent));
    }

    public int getFoodLevel() {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.getFoodLevel();
            }
            return 0;
        }
        return this.foodLevel;
    }

    public int getMaxFoodLevel() {
        return 1000;
    }

    public void addFood(int amount) {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                master.addFood(amount);
            }
            return;
        }
        this.foodLevel = Math.min(this.foodLevel + amount, this.maxFoodLevel);
        this.m_6596_();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        BlockEntity blockEntity;
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (this.isMaster()) {
                return LazyOptional.empty();
            }
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.getCapability(cap, side);
            }
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (this.isMaster()) {
                return this.itemHandlerLazyOptional.cast();
            }
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.getCapability(cap, side);
            }
        }
        return super.getCapability(cap, side);
    }

    public void onLoad() {
        super.onLoad();
        this.itemHandlerLazyOptional = LazyOptional.of(() -> new IItemHandler(){

            public int getSlots() {
                return 2;
            }

            public ItemStack getStackInSlot(int slot) {
                if (slot == 0) {
                    return (ItemStack)FishTankBlockEntity.this.items.get(0);
                }
                if (slot == 1) {
                    return (ItemStack)FishTankBlockEntity.this.items.get(21);
                }
                return ItemStack.f_41583_;
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                int internalSlot = -1;
                if (slot == 0) {
                    internalSlot = 0;
                }
                if (internalSlot != 0) {
                    return stack;
                }
                if (!FishTankBlockEntity.this.m_7013_(internalSlot, stack)) {
                    return stack;
                }
                ItemStack currentStack = (ItemStack)FishTankBlockEntity.this.items.get(internalSlot);
                int maxStackSize = this.getSlotLimit(slot);
                if (currentStack.m_41613_() >= maxStackSize) {
                    return stack;
                }
                int transferAmount = Math.min(stack.m_41613_(), maxStackSize - currentStack.m_41613_());
                if (transferAmount == 0) {
                    return stack;
                }
                if (!simulate) {
                    if (currentStack.m_41619_()) {
                        FishTankBlockEntity.this.items.set(internalSlot, (Object)stack.m_255036_(transferAmount));
                    } else {
                        currentStack.m_41769_(transferAmount);
                    }
                    FishTankBlockEntity.this.m_6596_();
                }
                return stack.m_255036_(stack.m_41613_() - transferAmount);
            }

            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                int internalSlot = -1;
                if (slot == 0) {
                    internalSlot = 0;
                }
                if (slot == 1) {
                    internalSlot = 21;
                }
                if (internalSlot != 21) {
                    return ItemStack.f_41583_;
                }
                ItemStack currentStack = (ItemStack)FishTankBlockEntity.this.items.get(internalSlot);
                if (currentStack.m_41619_()) {
                    return ItemStack.f_41583_;
                }
                int extractedAmount = Math.min(amount, currentStack.m_41613_());
                if (extractedAmount == 0) {
                    return ItemStack.f_41583_;
                }
                if (!simulate) {
                    ItemStack extracted = currentStack.m_255036_(extractedAmount);
                    currentStack.m_41774_(extractedAmount);
                    FishTankBlockEntity.this.m_6596_();
                    return extracted;
                }
                return currentStack.m_255036_(extractedAmount);
            }

            public int getSlotLimit(int slot) {
                if (slot == 0) {
                    return ((ItemStack)FishTankBlockEntity.this.items.get(0)).m_41741_();
                }
                if (slot == 1) {
                    return ((ItemStack)FishTankBlockEntity.this.items.get(21)).m_41741_();
                }
                return 0;
            }

            public boolean isItemValid(int slot, ItemStack stack) {
                int internalSlot = -1;
                if (slot == 0) {
                    internalSlot = 0;
                }
                if (slot == 1) {
                    internalSlot = 21;
                }
                if (internalSlot != -1) {
                    return FishTankBlockEntity.this.m_7013_(internalSlot, stack);
                }
                return false;
            }
        });
    }

    public void m_7651_() {
        super.m_7651_();
        this.itemHandlerLazyOptional.invalidate();
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        if (tank != 0) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(this.fluid, this.getFluidAmount());
    }

    public int getTankCapacity(int tank) {
        if (tank != 0) {
            return 0;
        }
        return this.getCapacity();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return tank == 0 && stack.getFluid() == Fluids.f_76193_;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.fill(resource, action);
            }
            return 0;
        }
        if (resource.isEmpty() || !this.isFluidValid(0, resource)) {
            return 0;
        }
        if (this.fluidAmount > 0 && !this.fluid.m_6212_(resource.getFluid())) {
            return 0;
        }
        if (action.execute()) {
            if (this.fluidAmount == 0) {
                this.fluid = resource.getFluid();
            }
            int filled = this.addWater(resource.getAmount());
            return filled;
        }
        int space = this.capacity - this.fluidAmount;
        return Math.min(resource.getAmount(), space);
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.drain(resource, action);
            }
            return FluidStack.EMPTY;
        }
        if (resource.isEmpty() || !resource.getFluid().m_6212_(this.fluid)) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (!this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.drain(maxDrain, action);
            }
            return FluidStack.EMPTY;
        }
        int drainedAmount = this.removeWater(maxDrain);
        return new FluidStack(this.fluid, drainedAmount);
    }

    public void copyMasterDataFrom(FishTankBlockEntity oldMaster) {
        this.fluidAmount = oldMaster.fluidAmount;
        this.fluid = oldMaster.fluid;
        this.capacity = oldMaster.capacity;
        this.structureMinY = oldMaster.structureMinY;
        this.structureMaxY = oldMaster.structureMaxY;
        this.fishCount = oldMaster.fishCount;
        this.progress = oldMaster.progress;
        this.foodLevel = oldMaster.foodLevel;
        this.floorBlockCount = oldMaster.floorBlockCount;
        this.maxDecoSlots = oldMaster.maxDecoSlots;
        this.currentPage = oldMaster.currentPage;
        this.items.clear();
        for (int i = 0; i < oldMaster.items.size(); ++i) {
            this.items.set(i, (Object)((ItemStack)oldMaster.items.get(i)).m_41777_());
        }
        this.decorationPositions.clear();
        this.decorationPositions.putAll(oldMaster.decorationPositions);
        this.decorationOccupancy.clear();
        this.decorationOccupancy.putAll(oldMaster.decorationOccupancy);
        this.m_6596_();
    }

    public boolean releaseFishFromBag(Player player, InteractionHand hand) {
        if (this.f_58857_ == null || !this.isMaster()) {
            BlockEntity blockEntity;
            if (this.f_58857_ != null && (blockEntity = this.f_58857_.m_7702_(this.masterPos)) instanceof FishTankBlockEntity) {
                FishTankBlockEntity master = (FishTankBlockEntity)blockEntity;
                return master.releaseFishFromBag(player, hand);
            }
            return false;
        }
        ItemStack fishBag = player.m_21120_(hand);
        if (!(fishBag.m_41720_() instanceof FishBagItem)) {
            return false;
        }
        CompoundTag fishData = FishBagItem.getFishData(fishBag);
        if (fishData == null || fishData.m_128456_()) {
            return false;
        }
        Optional<AABB> boundingBoxOpt = this.getTankBounds();
        if (boundingBoxOpt.isEmpty()) {
            return false;
        }
        AABB bounds = boundingBoxOpt.get();
        double centerX = bounds.f_82288_ + (bounds.f_82291_ - bounds.f_82288_) / 2.0;
        double centerY = bounds.f_82289_ + (bounds.f_82292_ - bounds.f_82289_) / 2.0;
        double centerZ = bounds.f_82290_ + (bounds.f_82293_ - bounds.f_82290_) / 2.0;
        Entity entity = EntityType.m_20645_((CompoundTag)fishData, (Level)this.f_58857_, e -> {
            e.m_7678_(centerX, centerY, centerZ, e.m_146908_(), e.m_146909_());
            return e;
        });
        if (entity != null && this.f_58857_.m_7967_(entity)) {
            FishBagItem.removeFish(fishBag);
            if (fishBag.m_41619_()) {
                player.m_21008_(hand, ItemStack.f_41583_);
            }
            this.increaseFishCount();
            this.m_6596_();
            return true;
        }
        return false;
    }

    private record DecorationVariant(RegistryObject<Block> block, int width, int height, int depth) {
    }
}

