/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.betterfishtanksmod.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ModConfig {
    public static final ForgeConfigSpec COMMON_CONFIG;
    public static final Server SERVER;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        COMMON_CONFIG = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public static ForgeConfigSpec.BooleanValue REQUIRE_FOOD;
        public static ForgeConfigSpec.EnumValue<WaterUnit> waterDisplayUnit;
        public static ForgeConfigSpec.BooleanValue ALLOW_DROWNED_CAPTURE;
        public static ForgeConfigSpec.BooleanValue ALLOW_GUARDIAN_CAPTURE;
        public static ForgeConfigSpec.BooleanValue ALLOW_WHALE_CAPTURE;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Better Fishtanks Mod Configuration").push("general");
            REQUIRE_FOOD = builder.comment("Require food for fish survival").define("requireFood", true);
            waterDisplayUnit = builder.comment(new String[]{"Defines how water is displayed in Fish Tank UI", "PERCENT: Shows as percentage (0-100%)", "BUCKETS: Shows as whole buckets (B)", "MILLIBUCKETS: Shows as millibuckets (mB)"}).defineEnum("waterDisplayUnit", (Enum)WaterUnit.PERCENT);
            builder.pop();
            builder.push("mob");
            ALLOW_DROWNED_CAPTURE = builder.comment("Set to true to allow Drowned to be captured with the Fish Bag.").define("allowDrownedCapture", false);
            ALLOW_GUARDIAN_CAPTURE = builder.comment("Set to true to allow Guardians and Elder Guardians to be captured with the Fish Bag.").define("allowGuardianCapture", false);
            ALLOW_WHALE_CAPTURE = builder.comment(new String[]{"Set to true to allow whales to be captured with the Fish Bag.", "WARNING: Large fish like whales may eat smaller fish in the same tank!"}).define("allowWhaleCapture", false);
            builder.pop();
        }
    }

    public static enum WaterUnit {
        PERCENT,
        BUCKETS,
        MILLIBUCKETS;

    }
}

