/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.betterfishtanksmod.data;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.mint_gaming_studios.betterfishtanksmod.BetterFishtanksMod;
import net.mint_gaming_studios.betterfishtanksmod.block.custom.decor.DecorationType;
import net.mint_gaming_studios.mint_lib.texture.ITextureResourceLoader;
import net.mint_gaming_studios.mint_lib.texture.TextureGenerator;

public class MintLibTextureDataProvider
implements DataProvider {
    private final PackOutput packOutput;
    private final String modId;

    public MintLibTextureDataProvider(PackOutput packOutput, String modId) {
        this.packOutput = packOutput;
        this.modId = modId;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cachedOutput) {
        Path sourceAssetRoot = this.packOutput.m_245114_().resolve("../../../src/main/resources").normalize();
        for (DecorationType decoType : DecorationType.values()) {
            String decoName;
            String baseName;
            if (!decoType.shouldGenerateItemModel() || (baseName = this.getBaseName(decoName = decoType.m_7912_())).isEmpty()) continue;
            Path greyscaleTexturePath = sourceAssetRoot.resolve("assets").resolve(this.modId).resolve("textures/item/deco/greyscale").resolve(baseName + ".png");
            if (!Files.exists(greyscaleTexturePath, new LinkOption[0])) {
                BetterFishtanksMod.LOGGER.warn("Skipping texture generation for '{}': Greyscale template not found at '{}'", (Object)decoName, (Object)greyscaleTexturePath);
                continue;
            }
            Path generatorOutputPath = this.packOutput.m_245114_();
            String subfolder = decoType.getTextureSubfolder();
            Path finalOutputDirectory = generatorOutputPath.resolve("assets").resolve(this.modId).resolve("textures/item").resolve(subfolder);
            try {
                ITextureResourceLoader resourceLoader = location -> {
                    String fullPath = "assets/" + location.m_135827_() + "/" + location.m_135815_();
                    InputStream stream = MintLibTextureDataProvider.class.getClassLoader().getResourceAsStream(fullPath);
                    if (stream == null) {
                        BetterFishtanksMod.LOGGER.error("Resource not found for texture generation: {}", (Object)fullPath);
                    }
                    return stream;
                };
                TextureGenerator generator = new TextureGenerator(TextureGenerator.GenerationMode.AUTOMATED, generatorOutputPath, greyscaleTexturePath, resourceLoader);
                generator.setAutomatedModeInfo(decoName, TextureGenerator.TextureType.BLOCK);
                generator.generate();
                String generatedFileName = baseName + "_generated.png";
                Path generatedFilePath = generatorOutputPath.resolve(generatedFileName);
                String finalFileName = decoName + ".png";
                Path finalFilePath = finalOutputDirectory.resolve(finalFileName);
                if (!Files.exists(generatedFilePath, new LinkOption[0])) continue;
                byte[] textureBytes = Files.readAllBytes(generatedFilePath);
                HashCode hashCode = Hashing.sha1().hashBytes(textureBytes);
                cachedOutput.m_213871_(finalFilePath, textureBytes, hashCode);
                Files.delete(generatedFilePath);
            }
            catch (Exception e) {
                BetterFishtanksMod.LOGGER.error("Failed to generate texture for '{}' using MINT Lib TextureGenerator", (Object)decoName, (Object)e);
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    private String getBaseName(String decoName) {
        if (decoName.startsWith("structure_cave")) {
            return "structure_cave";
        }
        if (decoName.startsWith("tiny_stone")) {
            return "tiny_stone";
        }
        if (decoName.startsWith("small_stone")) {
            return "small_stone";
        }
        if (decoName.startsWith("tiny_branch")) {
            return "tiny_branch";
        }
        if (decoName.startsWith("small_branch")) {
            return "small_branch";
        }
        if (decoName.startsWith("medium_branch")) {
            return "medium_branch";
        }
        if (decoName.startsWith("shipwreck")) {
            return "shipwreck";
        }
        if (decoName.startsWith("tower")) {
            return "tower";
        }
        return "";
    }

    public String m_6055_() {
        return "MINT Lib Texture Generator: " + this.modId;
    }
}

