/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.betterfishtanksmod.block.custom;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.ForgeRegistries;
import net.mint_gaming_studios.betterfishtanksmod.item.ModItems;

public class ContainerBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty POS_0_0 = BooleanProperty.m_61465_((String)"pos_0_0");
    public static final BooleanProperty POS_0_1 = BooleanProperty.m_61465_((String)"pos_0_1");
    public static final BooleanProperty POS_0_2 = BooleanProperty.m_61465_((String)"pos_0_2");
    public static final BooleanProperty POS_1_0 = BooleanProperty.m_61465_((String)"pos_1_0");
    public static final BooleanProperty POS_1_1 = BooleanProperty.m_61465_((String)"pos_1_1");
    public static final BooleanProperty POS_1_2 = BooleanProperty.m_61465_((String)"pos_1_2");
    public static final BooleanProperty POS_2_0 = BooleanProperty.m_61465_((String)"pos_2_0");
    public static final BooleanProperty POS_2_1 = BooleanProperty.m_61465_((String)"pos_2_1");
    public static final BooleanProperty POS_2_2 = BooleanProperty.m_61465_((String)"pos_2_2");
    private static final List<BooleanProperty> POSITIONS = List.of(POS_0_0, POS_0_1, POS_0_2, POS_1_0, POS_1_1, POS_1_2, POS_2_0, POS_2_1, POS_2_2);
    private static final List<BooleanProperty> PROPS_BY_INDEX = POSITIONS;
    private static final VoxelShape[] SHAPES = new VoxelShape[9];

    public ContainerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        BlockState defaultState = (BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH);
        for (BooleanProperty prop : POSITIONS) {
            defaultState = (BlockState)defaultState.m_61124_((Property)prop, (Comparable)Boolean.valueOf(false));
        }
        this.m_49959_(defaultState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_((Property[])POSITIONS.toArray(new BooleanProperty[0])).m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        ItemStack itemInHand = context.m_43722_();
        if (ContainerBlock.isFoodContainer(itemInHand) && itemInHand.m_41773_() > 0) {
            return null;
        }
        BlockPos clickedPos = context.m_8083_();
        Level level = context.m_43725_();
        BlockState stateAtClickedPos = level.m_8055_(clickedPos);
        if (stateAtClickedPos.m_60713_((Block)this)) {
            for (BooleanProperty prop : POSITIONS) {
                if (((Boolean)stateAtClickedPos.m_61143_((Property)prop)).booleanValue()) continue;
                return (BlockState)stateAtClickedPos.m_61124_((Property)prop, (Comparable)Boolean.valueOf(true));
            }
            return null;
        }
        if (stateAtClickedPos.m_60629_(context)) {
            BlockState newState = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)POSITIONS.get(0), (Comparable)Boolean.valueOf(true));
            if (newState.m_60710_((LevelReader)level, clickedPos)) {
                return newState;
            }
            return null;
        }
        return null;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext context) {
        if (!context.m_7078_() && context.m_43722_().m_150930_(this.m_5456_())) {
            for (BooleanProperty prop : POSITIONS) {
                if (((Boolean)state.m_61143_((Property)prop)).booleanValue()) continue;
                return true;
            }
        }
        return super.m_6864_(state, context);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Stream.Builder<VoxelShape> streamBuilder = Stream.builder();
        for (int i = 0; i < POSITIONS.size(); ++i) {
            if (!((Boolean)state.m_61143_((Property)POSITIONS.get(i))).booleanValue()) continue;
            streamBuilder.add(SHAPES[i]);
        }
        VoxelShape baseShape = streamBuilder.build().reduce(Shapes.m_83040_(), Shapes::m_83110_);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        if (facing == Direction.NORTH) {
            return baseShape;
        }
        return baseShape.m_83299_().stream().map(aabb -> {
            double newMinZ;
            double newMaxX;
            double newMinX;
            return Shapes.m_83048_((double)newMinX, (double)aabb.f_82289_, (double)newMinZ, (double)newMaxX, (double)aabb.f_82292_, (double)(switch (facing) {
                case Direction.SOUTH -> {
                    newMinX = 1.0 - aabb.f_82291_;
                    newMaxX = 1.0 - aabb.f_82288_;
                    newMinZ = 1.0 - aabb.f_82293_;
                    yield 1.0 - aabb.f_82290_;
                }
                case Direction.WEST -> {
                    newMinX = aabb.f_82290_;
                    newMaxX = aabb.f_82293_;
                    newMinZ = 1.0 - aabb.f_82291_;
                    yield 1.0 - aabb.f_82288_;
                }
                case Direction.EAST -> {
                    newMinX = 1.0 - aabb.f_82293_;
                    newMaxX = 1.0 - aabb.f_82290_;
                    newMinZ = aabb.f_82288_;
                    yield aabb.f_82291_;
                }
                default -> {
                    newMinX = aabb.f_82288_;
                    newMaxX = aabb.f_82291_;
                    newMinZ = aabb.f_82290_;
                    yield aabb.f_82293_;
                }
            }));
        }).reduce(Shapes.m_83040_(), Shapes::m_83110_);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(hand);
        boolean allOccupied = true;
        for (BooleanProperty prop : POSITIONS) {
            if (((Boolean)state.m_61143_((Property)prop)).booleanValue()) continue;
            allOccupied = false;
            break;
        }
        if (allOccupied && heldItem.m_150930_(this.m_5456_())) {
            return InteractionResult.FAIL;
        }
        if (player.m_6047_() && hand == InteractionHand.MAIN_HAND) {
            BooleanProperty prop;
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            Optional<BooleanProperty> hitProperty = this.getHitProperty(state, pos, hit);
            if (hitProperty.isPresent() && ((Boolean)state.m_61143_((Property)(prop = hitProperty.get()))).booleanValue()) {
                int filledCount = 0;
                for (BooleanProperty p : POSITIONS) {
                    if (!((Boolean)state.m_61143_((Property)p)).booleanValue()) continue;
                    ++filledCount;
                }
                if (filledCount > 1) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)prop, (Comparable)Boolean.valueOf(false)), 3);
                } else {
                    level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
                }
                ResourceLocation blockRegName = ForgeRegistries.BLOCKS.getKey((Object)this);
                if (blockRegName != null) {
                    String path = blockRegName.m_135815_().replace("_block", "");
                    ResourceLocation itemRegName = new ResourceLocation(blockRegName.m_135827_(), path);
                    ItemStack dropStack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(itemRegName));
                    Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)dropStack);
                }
                return InteractionResult.CONSUME;
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (pDirection == Direction.DOWN && !this.m_7898_(pState, (LevelReader)pLevel, pCurrentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockPosBelow = pPos.m_7495_();
        BlockState stateBelow = pLevel.m_8055_(blockPosBelow);
        return stateBelow.m_60783_((BlockGetter)pLevel, blockPosBelow, Direction.UP);
    }

    private Optional<BooleanProperty> getHitProperty(BlockState state, BlockPos pos, BlockHitResult hit) {
        double unrotatedX;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Vec3 relativeHit = hit.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)pos));
        double x = relativeHit.f_82479_;
        double y = relativeHit.f_82480_;
        double z = relativeHit.f_82481_;
        Vec3 unrotatedHit = new Vec3(unrotatedX, y, switch (facing) {
            case Direction.EAST -> {
                unrotatedX = z;
                yield 1.0 - x;
            }
            case Direction.SOUTH -> {
                unrotatedX = 1.0 - x;
                yield 1.0 - z;
            }
            case Direction.WEST -> {
                unrotatedX = 1.0 - z;
                yield x;
            }
            default -> {
                unrotatedX = x;
                yield z;
            }
        });
        for (int i = 0; i < SHAPES.length; ++i) {
            if (!((AABB)SHAPES[i].m_83299_().get(0)).m_82390_(unrotatedHit)) continue;
            return Optional.of(PROPS_BY_INDEX.get(i));
        }
        return Optional.empty();
    }

    private static boolean isFoodContainer(ItemStack stack) {
        return stack.m_150930_((Item)ModItems.FOOD_DRIEDKELP_CONTAINER.get()) || stack.m_150930_((Item)ModItems.FOOD_FLAKES_CONTAINER.get()) || stack.m_150930_((Item)ModItems.FOOD_MINISHRIMP_CONTAINER.get()) || stack.m_150930_((Item)ModItems.FOOD_PELLETS_CONTAINER.get());
    }

    static {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                double minX = (double)j * 5.333333333333333;
                double maxX = (double)(j + 1) * 5.333333333333333;
                double minZ = (double)i * 5.333333333333333;
                double maxZ = (double)(i + 1) * 5.333333333333333;
                ContainerBlock.SHAPES[i * 3 + j] = Block.m_49796_((double)Math.round(minX), (double)0.0, (double)Math.round(minZ), (double)Math.round(maxX), (double)6.0, (double)Math.round(maxZ));
            }
        }
    }
}

