/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.betterfishtanksmod.datagen.custom;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Guardian;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import net.mint_gaming_studios.betterfishtanksmod.config.ModConfig;
import net.mint_gaming_studios.mint_lib.fish.FishData;

public class FishClassifier {
    private static final Map<String, String> fishClassifications = new HashMap<String, String>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String OUTPUT_PATH = "src/main/resources/data/betterfishtanks/fish_classifications.json";
    private static final Set<String> BUCKET_MOB_KEYWORDS = new HashSet<String>();

    public static void generateFishClassifications() {
        for (EntityType type : ForgeRegistries.ENTITY_TYPES) {
            if (!FishClassifier.isCatchable(type)) continue;
            String entityId = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)type)).toString();
            String classification = FishClassifier.classify(type);
            fishClassifications.put(entityId, classification);
        }
        try (FileWriter writer = new FileWriter(OUTPUT_PATH);){
            GSON.toJson(fishClassifications, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean isCatchable(EntityType<?> entityType) {
        Entity entity = entityType.m_20615_(null);
        return FishClassifier.isCatchable(entity);
    }

    public static boolean isCatchable(Entity entity) {
        if (entity == null) {
            return false;
        }
        String registryName = Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_())).m_135815_().toLowerCase();
        String displayName = entity.m_5446_().getString().toLowerCase();
        BlockState blockAtEntity = entity.m_9236_().m_8055_(entity.m_20183_());
        boolean inFishtank = ForgeRegistries.BLOCKS.getKey((Object)blockAtEntity.m_60734_()).m_135815_().contains("fishtank");
        if (entity instanceof Drowned && ((Boolean)ModConfig.Server.ALLOW_DROWNED_CAPTURE.get()).booleanValue()) {
            return true;
        }
        if (entity instanceof Guardian && ((Boolean)ModConfig.Server.ALLOW_GUARDIAN_CAPTURE.get()).booleanValue()) {
            return true;
        }
        if ((registryName.contains("whale") || displayName.contains("whale")) && ((Boolean)ModConfig.Server.ALLOW_WHALE_CAPTURE.get()).booleanValue()) {
            return true;
        }
        if (entity instanceof Monster) {
            return false;
        }
        if (registryName.contains("whale") || displayName.contains("whale")) {
            return false;
        }
        if (entity instanceof Turtle) {
            return ((Turtle)entity).m_6162_() || inFishtank;
        }
        if (entity instanceof Bucketable) {
            return true;
        }
        if (entity instanceof WaterAnimal) {
            return true;
        }
        if (entity instanceof Frog) {
            return true;
        }
        return FishClassifier.isFishByKeywords(registryName, displayName);
    }

    private static boolean isFishByKeywords(String registryName, String displayName) {
        String registryNameForKeyword = registryName.replace('_', ' ');
        if (registryNameForKeyword.contains("fish") || displayName.contains("fish")) {
            return true;
        }
        for (String keyword : BUCKET_MOB_KEYWORDS) {
            if (!registryNameForKeyword.contains(keyword) && !displayName.contains(keyword)) continue;
            return true;
        }
        for (String fishName : FishData.getFishGroupMap().keySet()) {
            String formattedFishName = fishName.replace('_', ' ');
            if (!displayName.contains(formattedFishName) && !registryNameForKeyword.contains(formattedFishName)) continue;
            return true;
        }
        return false;
    }

    private static String classify(EntityType<?> entityType) {
        if (entityType == EntityType.f_147039_ || entityType == EntityType.f_217013_) {
            return "rare";
        }
        if (entityType == EntityType.f_147034_ || entityType == EntityType.f_20490_) {
            return "uncommon";
        }
        if (entityType == EntityType.f_217012_) {
            return "common";
        }
        ItemStack spawnEgg = FishClassifier.getSpawnEgg(entityType);
        if (spawnEgg.m_150930_(Items.f_151060_) || spawnEgg.m_150930_(Items.f_220214_)) {
            return "rare";
        }
        if (spawnEgg.m_150930_(Items.f_151061_) || spawnEgg.m_150930_(Items.f_42599_)) {
            return "uncommon";
        }
        if (spawnEgg.m_150930_(Items.f_220213_)) {
            return "common";
        }
        return "common";
    }

    private static ItemStack getSpawnEgg(EntityType<?> entityType) {
        SpawnEggItem spawnEggItem = SpawnEggItem.m_43213_(entityType);
        return spawnEggItem != null ? new ItemStack((ItemLike)spawnEggItem) : ItemStack.f_41583_;
    }

    static {
        try {
            String bucketPrefix = "bucket_of_";
            String bucketSuffix = "_bucket";
            for (Item item : ForgeRegistries.ITEMS) {
                ResourceLocation registryName = ForgeRegistries.ITEMS.getKey((Object)item);
                if (registryName == null) continue;
                String path = registryName.m_135815_();
                String keyword = null;
                if (path.startsWith("bucket_of_")) {
                    keyword = path.substring("bucket_of_".length());
                } else if (path.endsWith("_bucket")) {
                    keyword = path.substring(0, path.length() - "_bucket".length());
                }
                if (keyword == null) continue;
                BUCKET_MOB_KEYWORDS.add(keyword.replace('_', ' '));
            }
        }
        catch (Exception e) {
            System.err.println("FishClassifier static init failed: " + e.getMessage());
        }
    }
}

