/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.betterfishtanksmod.datagen.custom;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class FishTagSaver {
    public static void saveFishPoolToTag(Set<EntityType<?>> detectedFishPool, File configDirectory) {
        Path tagFilePath = configDirectory.toPath().resolve("data").resolve("betterfishtanks").resolve("tags").resolve("entity_types").resolve("catchable_fish.json");
        File tagFile = tagFilePath.toFile();
        if (!tagFile.getParentFile().exists() && !tagFile.getParentFile().mkdirs()) {
            System.err.println("Failed to create directories for fish tag file: " + String.valueOf(tagFilePath));
            return;
        }
        JsonObject tagJson = new JsonObject();
        JsonArray valuesArray = new JsonArray();
        for (EntityType<?> entityType : detectedFishPool) {
            ResourceLocation entityId = EntityType.m_20613_(entityType);
            if (entityId == null) continue;
            valuesArray.add(entityId.toString());
        }
        tagJson.addProperty("replace", Boolean.valueOf(false));
        tagJson.add("values", (JsonElement)valuesArray);
        try (FileWriter writer = new FileWriter(tagFile);){
            writer.write(tagJson.toString());
            System.out.println("Successfully saved fish pool to: " + String.valueOf(tagFilePath));
        }
        catch (IOException e) {
            System.err.println("Failed to write fish tag file: " + e.getMessage());
        }
    }
}

