/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.betterfishtanksmod.item.custom;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.mint_gaming_studios.betterfishtanksmod.datagen.custom.RandomFishPool;
import net.mint_gaming_studios.betterfishtanksmod.item.ModItems;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class RandomFishBagItem
extends Item {
    private static final Logger LOGGER = LogUtils.getLogger();

    public RandomFishBagItem(Item.Properties properties) {
        super(properties.m_41487_(1));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        if (!player.m_6144_()) {
            return InteractionResultHolder.m_19098_((Object)heldStack);
        }
        if (level.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)heldStack);
        }
        ArrayList<EntityType<? extends Mob>> catchableFish = new ArrayList<EntityType<? extends Mob>>(RandomFishPool.getFishPool());
        if (catchableFish.isEmpty()) {
            LOGGER.warn("RandomFishPool was empty. Using hardcoded fallback list.");
            player.m_5661_((Component)Component.m_237113_((String)"Warning: Main fish pool empty, using fallback."), true);
            catchableFish.add((EntityType<? extends Mob>)EntityType.f_20556_);
            catchableFish.add((EntityType<? extends Mob>)EntityType.f_20519_);
            catchableFish.add((EntityType<? extends Mob>)EntityType.f_20489_);
            catchableFish.add((EntityType<? extends Mob>)EntityType.f_20516_);
            catchableFish.add((EntityType<? extends Mob>)EntityType.f_147039_);
            catchableFish.add((EntityType<? extends Mob>)EntityType.f_20490_);
        }
        if (catchableFish.isEmpty()) {
            LOGGER.error("FATAL: Fallback fish list is also empty. Cannot spawn a fish.");
            player.m_5661_((Component)Component.m_237113_((String)"Error: Fallback fish list is empty!"), true);
            return InteractionResultHolder.m_19100_((Object)heldStack);
        }
        Random random = new Random();
        EntityType randomFishType = (EntityType)catchableFish.get(random.nextInt(catchableFish.size()));
        Entity entity = randomFishType.m_20615_(level);
        if (entity != null) {
            if (entity instanceof Turtle) {
                Turtle turtle = (Turtle)entity;
                turtle.m_6863_(true);
            }
            if (entity instanceof TropicalFish) {
                TropicalFish tropicalFish = (TropicalFish)entity;
                TropicalFish.Pattern pattern = TropicalFish.Pattern.values()[random.nextInt(TropicalFish.Pattern.values().length)];
                DyeColor baseColor = DyeColor.values()[random.nextInt(DyeColor.values().length)];
                DyeColor patternColor = DyeColor.values()[random.nextInt(DyeColor.values().length)];
                TropicalFish.Variant variant = new TropicalFish.Variant(pattern, baseColor, patternColor);
                int packedVariant = variant.m_262472_();
                CompoundTag compoundTag = new CompoundTag();
                compoundTag.m_128405_("Variant", packedVariant);
                tropicalFish.m_7378_(compoundTag);
            }
            if (entity instanceof Axolotl) {
                Axolotl axolotl = (Axolotl)entity;
                axolotl.m_28464_(Axolotl.Variant.values()[random.nextInt(Axolotl.Variant.values().length)]);
                if (random.nextFloat() <= 0.55f) {
                    axolotl.m_6863_(true);
                }
            }
            Vec3 spawnPos = player.m_146892_().m_82549_(player.m_20154_().m_82490_(1.5));
            entity.m_6034_(spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_);
            level.m_7967_(entity);
            return InteractionResultHolder.m_19090_((Object)new ItemStack((ItemLike)ModItems.FISH_BAG.get()));
        }
        LOGGER.error("Failed to create entity for {}", (Object)randomFishType.m_20675_());
        return InteractionResultHolder.m_19100_((Object)heldStack);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.betterfishtanks.random_fish_bag").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xA0A0A0))));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

