/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.betterfishtanksmod.config;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ModConfig {
    public static final ForgeConfigSpec COMMON_CONFIG;
    public static final Server SERVER;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        COMMON_CONFIG = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public static ForgeConfigSpec.BooleanValue REQUIRE_FOOD;
        public static ForgeConfigSpec.EnumValue<WaterUnit> waterDisplayUnit;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Better Fishtanks Mod Configuration").push("general");
            REQUIRE_FOOD = builder.comment("Require food for fish survival").define("requireFood", true);
            waterDisplayUnit = builder.comment(new String[]{"Defines how water is displayed in Fish Tank UI", "PERCENT: Shows as percentage (0-100%)", "BUCKETS: Shows as whole buckets (B)", "MILLIBUCKETS: Shows as millibuckets (mB)"}).defineEnum("waterDisplayUnit", (Enum)WaterUnit.PERCENT);
            builder.pop();
        }
    }

    public static enum WaterUnit {
        PERCENT,
        BUCKETS,
        MILLIBUCKETS;

    }
}

