/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.betterfishtanksmod.datagen.custom;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;

public class CatchableFishRegistry {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final List<EntityType<? extends Mob>> RANDOM_FISH_LIST = new ArrayList<EntityType<? extends Mob>>();
    private static boolean isInitialized = false;
    private static final TagKey<EntityType<?>> MINECRAFT_FISHES = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("minecraft", "fishes"));
    private static final TagKey<EntityType<?>> CATCHABLE_FISH_TAG = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("betterfishtanks", "catchable_fish"));
    private static final TagKey<EntityType<?>> C_FISH = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("c", "fish"));
    private static final TagKey<EntityType<?>> FORGE_FISH = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("forge", "fish"));

    private static void initialize(Level level) {
        if (isInitialized) {
            return;
        }
        LOGGER.info("Initializing Random Fish Bag list...");
        RANDOM_FISH_LIST.clear();
        CatchableFishRegistry.addFishFromTag(MINECRAFT_FISHES);
        CatchableFishRegistry.addFishFromTag(CATCHABLE_FISH_TAG);
        CatchableFishRegistry.addFishFromTag(C_FISH);
        CatchableFishRegistry.addFishFromTag(FORGE_FISH);
        LOGGER.info("Random Fish Bag list initialized with {} tagged fish.", (Object)RANDOM_FISH_LIST.size());
        isInitialized = true;
    }

    private static void addFishFromTag(TagKey<EntityType<?>> tag) {
        Optional holders = BuiltInRegistries.f_256780_.m_203431_(tag);
        if (holders.isPresent()) {
            for (Holder holder : (HolderSet.Named)holders.get()) {
                EntityType mobType;
                EntityType type = (EntityType)holder.m_203334_();
                if (!Mob.class.isAssignableFrom(type.m_142225_()) || RANDOM_FISH_LIST.contains(mobType = type)) continue;
                RANDOM_FISH_LIST.add((EntityType<? extends Mob>)mobType);
                LOGGER.debug("Added fish from tag {}: {}", (Object)tag.f_203868_(), (Object)type.m_20675_());
            }
        }
    }

    public static List<EntityType<? extends Mob>> getCatchableFish(Level level) {
        if (!isInitialized && !level.m_5776_()) {
            CatchableFishRegistry.initialize(level);
        }
        return Collections.unmodifiableList(RANDOM_FISH_LIST);
    }

    public static void addDynamicallyDetectedFish(EntityType<? extends Mob> fishType) {
        if (!RANDOM_FISH_LIST.contains(fishType)) {
            RANDOM_FISH_LIST.add(fishType);
            LOGGER.info("Dynamically added new fish to random bag list: {}", (Object)fishType.m_20675_());
        }
    }
}

