/*
 * Decompiled with CFR 0.152.
 */
package net.mint_gaming_studios.betterfishtanksmod.loot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.mint_gaming_studios.mint_lib.fish.FishData;

public class FishClassLootManager {
    private static final Map<String, List<Item>> DYNAMIC_FISH_LOOT_TABLES = new HashMap<String, List<Item>>();
    private static final Random RANDOM = new Random();
    private static boolean generated = false;

    public static void generateLoot() {
        if (generated) {
            return;
        }
        DYNAMIC_FISH_LOOT_TABLES.clear();
        for (EntityType type : ForgeRegistries.ENTITY_TYPES) {
            FishData.FishGroup group;
            String fishClass;
            Item fishItem;
            if (type.m_20674_() != MobCategory.WATER_AMBIENT && type.m_20674_() != MobCategory.WATER_CREATURE || (fishItem = (Item)ForgeRegistries.ITEMS.getValue(ForgeRegistries.ENTITY_TYPES.getKey((Object)type))) == null || fishItem == Items.f_41852_ || (fishClass = FishClassLootManager.mapGroupToClass(group = FishData.getFishGroup((Item)fishItem))) == null || fishClass.isEmpty()) continue;
            DYNAMIC_FISH_LOOT_TABLES.computeIfAbsent(fishClass, k -> new ArrayList()).add(fishItem);
        }
        generated = true;
    }

    private static String mapGroupToClass(FishData.FishGroup group) {
        if (group == null) {
            return null;
        }
        return switch (group) {
            default -> throw new IncompatibleClassChangeError();
            case FishData.FishGroup.TINY_FISH -> "common";
            case FishData.FishGroup.SMALL_FISH -> "uncommon";
            case FishData.FishGroup.MEDIUM_FISH -> "rare";
            case FishData.FishGroup.LARGE_FISH -> "epic";
            case FishData.FishGroup.VERY_LARGE_FISH -> "exotic";
            case FishData.FishGroup.GIANT_FISH -> "legendary";
        };
    }

    private static FishData.FishGroup mapClassToGroup(String fishClass) {
        return switch (fishClass) {
            case "common" -> FishData.FishGroup.TINY_FISH;
            case "uncommon" -> FishData.FishGroup.SMALL_FISH;
            case "rare" -> FishData.FishGroup.MEDIUM_FISH;
            case "epic" -> FishData.FishGroup.LARGE_FISH;
            case "exotic" -> FishData.FishGroup.VERY_LARGE_FISH;
            case "legendary" -> FishData.FishGroup.GIANT_FISH;
            default -> null;
        };
    }

    private static List<ItemStack> getMintLibLootPool(FishData.FishGroup group) {
        ArrayList<ItemStack> possibleDrops = new ArrayList<ItemStack>();
        if (group == null) {
            return possibleDrops;
        }
        switch (group) {
            case TINY_FISH: {
                possibleDrops.addAll(Arrays.asList(new ItemStack((ItemLike)Items.f_42499_, RANDOM.nextInt(2) + 1), new ItemStack((ItemLike)Items.f_42401_, RANDOM.nextInt(2) + 1)));
                break;
            }
            case SMALL_FISH: {
                possibleDrops.addAll(Arrays.asList(new ItemStack((ItemLike)Items.f_42526_, RANDOM.nextInt(2) + 1), new ItemStack((ItemLike)Items.f_42527_, RANDOM.nextInt(2) + 1), new ItemStack((ItemLike)Items.f_42499_, RANDOM.nextInt(3) + 1)));
                break;
            }
            case MEDIUM_FISH: {
                possibleDrops.addAll(Arrays.asList(new ItemStack((ItemLike)Items.f_42530_, RANDOM.nextInt(2) + 1), new ItemStack((ItemLike)Items.f_42531_, RANDOM.nextInt(2) + 1), new ItemStack((ItemLike)Items.f_42715_), new ItemStack((ItemLike)Items.f_42695_, RANDOM.nextInt(2) + 1)));
                break;
            }
            case LARGE_FISH: {
                possibleDrops.addAll(Arrays.asList(new ItemStack((ItemLike)Items.f_42530_, RANDOM.nextInt(3) + 1), new ItemStack((ItemLike)Items.f_42531_, RANDOM.nextInt(3) + 1), new ItemStack((ItemLike)Items.f_42715_, RANDOM.nextInt(2) + 1), new ItemStack((ItemLike)Items.f_42696_, RANDOM.nextInt(2) + 1)));
                break;
            }
            case VERY_LARGE_FISH: {
                possibleDrops.addAll(Arrays.asList(new ItemStack((ItemLike)Items.f_42715_, RANDOM.nextInt(3) + 1), new ItemStack((ItemLike)Items.f_42696_, RANDOM.nextInt(3) + 1), new ItemStack((ItemLike)Items.f_42716_), new ItemStack((ItemLike)Items.f_42415_)));
                break;
            }
            case GIANT_FISH: {
                possibleDrops.addAll(Arrays.asList(new ItemStack((ItemLike)Items.f_42716_, RANDOM.nextInt(2) + 1), new ItemStack((ItemLike)Items.f_42415_, RANDOM.nextInt(2) + 1), new ItemStack((ItemLike)Items.f_42616_, RANDOM.nextInt(2) + 1), new ItemStack((ItemLike)Items.f_42690_)));
            }
        }
        return possibleDrops;
    }

    public static List<ItemStack> getCombinedLootForClass(String fishClass) {
        FishData.FishGroup group;
        ArrayList<ItemStack> combinedPool = new ArrayList<ItemStack>();
        List<Item> dynamicFishItems = DYNAMIC_FISH_LOOT_TABLES.get(fishClass);
        if (dynamicFishItems != null) {
            dynamicFishItems.forEach(item -> combinedPool.add(new ItemStack((ItemLike)item)));
        }
        if ((group = FishClassLootManager.mapClassToGroup(fishClass)) != null) {
            combinedPool.addAll(FishClassLootManager.getMintLibLootPool(group));
        }
        return combinedPool;
    }

    public static ItemStack getRandomLootForClass(String fishClass) {
        List<ItemStack> combinedPool = FishClassLootManager.getCombinedLootForClass(fishClass);
        if (combinedPool.isEmpty()) {
            return ItemStack.f_41583_;
        }
        return combinedPool.get(RANDOM.nextInt(combinedPool.size()));
    }

    public static Map<String, List<Item>> getDynamicFishLootTables() {
        return Collections.unmodifiableMap(DYNAMIC_FISH_LOOT_TABLES);
    }
}

