/*
 * Decompiled with CFR 0.152.
 */
package com.example.createbugfix;

import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;

@Mod(value="clipboard_patch")
public class ClipboardFixMod {
    private static final ResourceLocation CLIPBOARD_PAGES = ResourceLocation.parse((String)"create:clipboard_pages");
    private static final ResourceLocation CLIPBOARD_TYPE = ResourceLocation.parse((String)"create:clipboard_type");

    public ClipboardFixMod(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onItemToss(ItemTossEvent event) {
        ItemEntity itemEntity = event.getEntity();
        ItemStack originalStack = itemEntity.getItem();
        ResourceLocation itemId = BuiltInRegistries.ITEM.getKey((Object)originalStack.getItem());
        if (itemId == null || !itemId.toString().equals("create:clipboard")) {
            return;
        }
        DataComponentMap components = originalStack.getComponents();
        boolean hasIllegalComponents = false;
        for (DataComponentType componentType : components.keySet()) {
            ResourceLocation componentId = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)componentType);
            if (componentId == null || componentId.equals((Object)CLIPBOARD_PAGES) || componentId.equals((Object)CLIPBOARD_TYPE)) continue;
            hasIllegalComponents = true;
            break;
        }
        if (hasIllegalComponents) {
            ItemStack newStack = new ItemStack((ItemLike)originalStack.getItem(), originalStack.getCount());
            DataComponentType pagesType = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(CLIPBOARD_PAGES);
            DataComponentType typeType = (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.get(CLIPBOARD_TYPE);
            if (pagesType != null && components.has(pagesType)) {
                this.copyComponent(newStack, pagesType, components.get(pagesType));
            }
            if (typeType != null && components.has(typeType)) {
                this.copyComponent(newStack, typeType, components.get(typeType));
            }
            itemEntity.setItem(newStack);
            System.out.println("Fixed clipboard with illegal components");
        }
    }

    private <T> void copyComponent(ItemStack stack, DataComponentType<?> componentType, Object value) {
        try {
            stack.set(componentType, value);
        }
        catch (ClassCastException e) {
            System.err.println("Failed to copy component: " + String.valueOf(componentType) + " - " + e.getMessage());
        }
    }
}

