/*
 * Decompiled with CFR 0.152.
 */
package com.sorkopiko.teammatestracker.client;

import com.google.protobuf.Any;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.sorkopiko.teammatestracker.config.TeammatesConfig;
import com.sorkopiko.teammatestracker.model.Teammate;
import com.sorkopiko.teammatestracker.packet.ApolloPayload;
import com.sorkopiko.teammatestracker.packet.UpdateTeamMembersPayload;
import com.sorkopiko.teammatestracker.render.TeammateRenderer;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lunarclient.apollo.team.v1.Schema;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.class_2561;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeammatesTrackerClient
implements ClientModInitializer {
    public static final String MOD_ID = "teammates-tracker";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"teammates-tracker");
    private final Map<UUID, Teammate> teammates = new ConcurrentHashMap<UUID, Teammate>();

    public void onInitializeClient() {
        LOGGER.info("Teammates Tracker initialized!");
        PayloadTypeRegistry.playS2C().register(ApolloPayload.ID, ApolloPayload.CODEC);
        ClientPlayNetworking.registerGlobalReceiver(ApolloPayload.ID, (payload, context) -> {
            try {
                Any message = Any.parseFrom((byte[])payload.data());
                LOGGER.debug("Received Apollo message of type {}", (Object)message.getTypeUrl());
                TeammatesTrackerClient.safeUnpack(message, Schema.UpdateTeamMembersMessage.class).ifPresent(updateMsg -> {
                    UpdateTeamMembersPayload updatePayload = UpdateTeamMembersPayload.fromProto(updateMsg);
                    this.handleUpdateTeamMembers(updatePayload, context);
                    LOGGER.debug("Received update team members payload");
                });
                TeammatesTrackerClient.safeUnpack(message, Schema.ResetTeamMembersMessage.class).ifPresent(resetMsg -> {
                    this.teammates.clear();
                    LOGGER.debug("Received reset team members payload");
                });
            }
            catch (Exception e) {
                LOGGER.warn("Failed to process Apollo message: {}", (Object)e.getMessage());
            }
        });
        WorldRenderEvents.AFTER_TRANSLUCENT.register(context -> TeammateRenderer.render(context.matrixStack(), context.camera(), this.teammates, context.tickCounter().method_60637(true)));
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> this.teammates.clear());
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> this.teammates.clear());
        TeammatesConfig.HANDLER.load();
    }

    private void handleUpdateTeamMembers(UpdateTeamMembersPayload payload, ClientPlayNetworking.Context context) {
        class_638 world = context.client().field_1687;
        long currentTime = System.currentTimeMillis();
        class_5455.class_6890 registries = world != null ? world.method_30349() : class_5455.field_40585;
        Set currentTeammateIds = payload.members().stream().map(UpdateTeamMembersPayload.TeamMemberPayload::playerId).collect(Collectors.toSet());
        this.teammates.keySet().removeIf(playerId -> !currentTeammateIds.contains(playerId));
        this.teammates.values().removeIf(teammate -> teammate.getLastUpdate() < currentTime - 30000L);
        payload.members().forEach(arg_0 -> this.lambda$handleUpdateTeamMembers$9(currentTime, (class_7225.class_7874)registries, arg_0));
    }

    private static <T extends GeneratedMessage> Optional<T> safeUnpack(Any message, Class<T> clazz) {
        try {
            return message.is(clazz) ? Optional.of((GeneratedMessage)message.unpack(clazz)) : Optional.empty();
        }
        catch (InvalidProtocolBufferException e) {
            LOGGER.warn("Failed to unpack message of type {}: {}", (Object)message.getTypeUrl(), (Object)e.getMessage());
            return Optional.empty();
        }
        catch (Exception e) {
            LOGGER.error("Failed to check message type for {}: {}", (Object)clazz.getSimpleName(), (Object)e.getMessage());
            return Optional.empty();
        }
    }

    private /* synthetic */ void lambda$handleUpdateTeamMembers$9(long currentTime, class_7225.class_7874 registries, UpdateTeamMembersPayload.TeamMemberPayload teammember) {
        Teammate teammate = this.teammates.computeIfAbsent(teammember.playerId(), id -> new Teammate((UUID)id, currentTime));
        teammate.update(teammember.x(), teammember.y(), teammember.z(), teammember.worldName(), (class_2561)class_2561.class_2562.method_10877((String)teammember.displayName(), (class_7225.class_7874)registries), teammember.markerColor(), currentTime);
    }
}

