/*
 * Decompiled with CFR 0.152.
 */
package com.sorkopiko.teammatestracker.model;

import java.awt.Color;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_3532;

public class Teammate {
    private final UUID playerId;
    private double x;
    private double y;
    private double z;
    private double lastX;
    private double lastY;
    private double lastZ;
    private String worldName;
    private class_2561 displayName;
    private Color markerColor;
    private long lastUpdate;
    private long lastLastUpdate;

    public Teammate(UUID playerId, long lastUpdate) {
        this.playerId = playerId;
        this.lastUpdate = lastUpdate;
    }

    public void update(double x, double y, double z, String worldName, class_2561 displayName, Color markerColor, long lastUpdate) {
        this.lastX = this.x;
        this.lastY = this.y;
        this.lastZ = this.z;
        this.x = x;
        this.y = y;
        this.z = z;
        this.worldName = worldName;
        this.displayName = displayName;
        this.markerColor = markerColor;
        this.lastLastUpdate = this.lastUpdate;
        this.lastUpdate = lastUpdate;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public Color getMarkerColor() {
        return this.markerColor;
    }

    public class_2561 getDisplayName() {
        return this.displayName;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public double getInterpolatedX(long currentTime) {
        return this.interpolatePosition(this.lastX, this.x, currentTime);
    }

    public double getInterpolatedY(long currentTime) {
        return this.interpolatePosition(this.lastY, this.y, currentTime);
    }

    public double getInterpolatedZ(long currentTime) {
        return this.interpolatePosition(this.lastZ, this.z, currentTime);
    }

    private double interpolatePosition(double lastPos, double currentPos, long currentTime) {
        if (this.lastLastUpdate == 0L || this.lastUpdate == this.lastLastUpdate) {
            return currentPos;
        }
        long timeDelta = this.lastUpdate - this.lastLastUpdate;
        long timeSinceLastUpdate = currentTime - this.lastUpdate;
        double tickDelta = (double)timeSinceLastUpdate / (double)timeDelta;
        return class_3532.method_16436((double)tickDelta, (double)lastPos, (double)currentPos);
    }

    public double distanceTo(Teammate other) {
        double dx = this.x - other.x;
        double dy = this.y - other.y;
        double dz = this.z - other.z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }
}

