/*
 * Decompiled with CFR 0.152.
 */
package com.sorkopiko.teammatestracker.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.sorkopiko.teammatestracker.config.TeammatesConfig;
import com.sorkopiko.teammatestracker.model.InterpolatedLocation;
import com.sorkopiko.teammatestracker.model.Teammate;
import java.awt.Color;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_6854;
import net.minecraft.class_898;
import net.minecraft.class_9801;
import net.minecraft.class_9958;
import org.joml.Matrix4f;

public class TeammateRenderer {
    private static final class_310 client = class_310.method_1551();
    private static final float ARROW_SIZE = 0.3f;
    private static final int TEXT_OFFSET = 20;
    private static final float ARROW_OFFSET_Y = 2.0f;

    public static void render(class_4587 matrices, class_4184 camera, Map<UUID, Teammate> teammates, double tickDelta) {
        if (TeammateRenderer.client.field_1724 == null || TeammateRenderer.client.field_1687 == null || !((TeammatesConfig)TeammatesConfig.HANDLER.instance()).enabled) {
            return;
        }
        class_243 cameraPos = camera.method_19326();
        String currentWorld = TeammateRenderer.client.field_1687.method_27983().method_29177().method_12832();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        class_9958 originalFog = RenderSystem.getShaderFog();
        RenderSystem.setShaderFog((class_9958)new class_9958(Float.MAX_VALUE, Float.MAX_VALUE, class_6854.field_36350, 0.0f, 0.0f, 0.0f, 0.0f));
        long currentTime = System.currentTimeMillis();
        matrices.method_22903();
        teammates.values().stream().filter(teammate -> !teammate.getPlayerId().equals(TeammateRenderer.client.field_1724.method_5667()) && currentWorld.equals(teammate.getWorldName())).sorted((a, b) -> {
            double distanceA = TeammateRenderer.calculateDistance(TeammateRenderer.getLocation(a, currentTime, tickDelta), cameraPos);
            double distanceB = TeammateRenderer.calculateDistance(TeammateRenderer.getLocation(b, currentTime, tickDelta), cameraPos);
            return Double.compare(distanceB, distanceA);
        }).forEach(teammate -> {
            InterpolatedLocation location = TeammateRenderer.getLocation(teammate, currentTime, tickDelta);
            double distance = TeammateRenderer.calculateDistance(location, cameraPos);
            TeammateRenderer.renderTeammateMarker(matrices, location.withOffset(0.0, 2.0f + ((TeammatesConfig)TeammatesConfig.HANDLER.instance()).yOffset, 0.0).relativeToCamera(cameraPos), teammate, distance);
        });
        matrices.method_22909();
        RenderSystem.setShaderFog((class_9958)originalFog);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    private static void renderTeammateMarker(class_4587 matrices, InterpolatedLocation location, Teammate teammate, double distance) {
        if (TeammateRenderer.client.field_1772 == null) {
            return;
        }
        matrices.method_22903();
        matrices.method_22904(location.x(), location.y(), location.z());
        class_898 dispatcher = client.method_1561();
        matrices.method_22907(dispatcher.method_24197());
        float scale = (float)TeammateRenderer.getScale(distance, ((TeammatesConfig)TeammatesConfig.HANDLER.instance()).markerScale);
        matrices.method_22905(scale, scale, scale);
        int backgroundColor = (int)(class_310.method_1551().field_1690.method_19343(0.25f) * 255.0f) << 24 | 0x666666;
        class_2561 displayName = teammate.getDisplayName();
        if (displayName != null) {
            TeammateRenderer.renderText(matrices, displayName, 0.0f, -30.0f, 0xFFFFFF, backgroundColor, true, distance);
        }
        String distanceText = String.format("%.1fm", distance);
        TeammateRenderer.renderArrow(matrices, teammate.getMarkerColor());
        TeammateRenderer.renderText(matrices, (class_2561)class_2561.method_43470((String)distanceText), 0.0f, -20.0f, 0xFFFFFF, backgroundColor, true, distance);
        matrices.method_22909();
    }

    private static void renderArrow(class_4587 matrices, Color color) {
        Matrix4f matrix = matrices.method_23760().method_23761();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27379, class_290.field_1576);
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        float a = (float)color.getAlpha() / 255.0f;
        float halfSize = 0.15f;
        buffer.method_22918(matrix, -halfSize, halfSize, 0.0f).method_22915(r, g, b, a);
        buffer.method_22918(matrix, 0.0f, -halfSize, 0.0f).method_22915(r, g, b, a);
        buffer.method_22918(matrix, halfSize, halfSize, 0.0f).method_22915(r, g, b, a);
        RenderSystem.setShader((class_10156)class_10142.field_53876);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_286.method_43433((class_9801)buffer.method_60800());
    }

    private static void renderText(class_4587 matrices, class_2561 text, float x, float y, int color, int backgroundColor, boolean centered, double distance) {
        matrices.method_22903();
        float scale = 0.015f;
        matrices.method_22905(scale, -scale, scale);
        class_327 textRenderer = TeammateRenderer.client.field_1772;
        if (centered) {
            x += (float)(-textRenderer.method_27525((class_5348)text)) / 2.0f;
        }
        class_4597.class_4598 immediate = client.method_22940().method_23000();
        textRenderer.method_27522(text, x, y, color, false, matrices.method_23760().method_23761(), (class_4597)immediate, class_327.class_6415.field_33994, backgroundColor, 0xF000F0);
        immediate.method_22993();
        matrices.method_22909();
    }

    private static double getScale(double distance, float scaleFactor) {
        if (distance < 10.0) {
            return scaleFactor;
        }
        return (double)scaleFactor * (distance / 10.0);
    }

    private static double calculateDistance(InterpolatedLocation location, class_243 cameraPos) {
        double dx = location.x() - cameraPos.field_1352;
        double dy = location.y() - cameraPos.field_1351;
        double dz = location.z() - cameraPos.field_1350;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    private static class_1657 getLoadedPlayer(UUID playerId) {
        if (TeammateRenderer.client.field_1687 == null) {
            return null;
        }
        return TeammateRenderer.client.field_1687.method_18456().stream().filter(player -> player.method_5667().equals(playerId)).findFirst().orElse(null);
    }

    private static InterpolatedLocation getLocation(Teammate teammate, long currentTime, double tickDelta) {
        class_1657 player = TeammateRenderer.getLoadedPlayer(teammate.getPlayerId());
        if (player != null) {
            return InterpolatedLocation.fromPlayer(player, tickDelta);
        }
        return InterpolatedLocation.fromTeammate(teammate, currentTime);
    }
}

