/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.ranged_weapon.mixin.attribute;

import net.fabric_extras.ranged_weapon.Platform;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabric_extras.ranged_weapon.internal.RangedHasteEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements RangedHasteEntity {
    @Shadow
    protected int useItemRemaining;
    @Shadow
    protected ItemStack useItem;
    private float partialHasteTick = 0.0f;

    LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"createLivingAttributes()Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;"}, require=1, allow=1, at={@At(value="RETURN")})
    private static void addAttributes(CallbackInfoReturnable<AttributeSupplier.Builder> info) {
        for (EntityAttributes_RangedWeapon.Entry entry : EntityAttributes_RangedWeapon.all) {
            ((AttributeSupplier.Builder)info.getReturnValue()).add(entry.entry);
        }
    }

    @Inject(method={"getUseItemRemainingTicks()I"}, at={@At(value="HEAD")}, cancellable=true)
    private void getItemUseTimeLeft(CallbackInfoReturnable<Integer> info) {
        if (Platform.NeoForge) {
            UseAnim useAction = this.useItem.getUseAnimation();
            if (useAction == UseAnim.BOW || useAction == UseAnim.CROSSBOW) {
                info.setReturnValue((Object)(this.useItemRemaining - (int)this.partialHasteTick));
            }
        } else {
            UseAnim useAction;
            int value = this.useItemRemaining;
            LivingEntity entity = (LivingEntity)this;
            if (entity.isUsingItem() && ((useAction = this.useItem.getUseAnimation()) == UseAnim.BOW || useAction == UseAnim.CROSSBOW)) {
                int progress = this.useItem.getUseDuration(entity) - value;
                double haste = entity.getAttributeValue(EntityAttributes_RangedWeapon.HASTE.entry);
                int newProgress = (int)((double)progress * EntityAttributes_RangedWeapon.HASTE.asMultiplier((float)haste));
                info.setReturnValue((Object)(this.useItem.getUseDuration(entity) - newProgress));
                info.cancel();
            }
        }
    }

    @Inject(method={"stopUsingItem()V"}, at={@At(value="TAIL")})
    private void clearActiveItem_RWA(CallbackInfo ci) {
        this.resetPartialHasteTicks();
    }

    @Override
    public void addPartialHasteTick(float tick) {
        this.partialHasteTick += tick;
    }

    @Override
    public void resetPartialHasteTicks() {
        this.partialHasteTick = 0.0f;
    }

    @Override
    public float getPartialHasteTick() {
        return this.partialHasteTick;
    }
}

