/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.ranged_weapon.mixin.client;

import java.util.function.Consumer;
import net.fabric_extras.ranged_weapon.api.AttributeModifierIDs;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemStack.class})
public class ItemStackMixin {
    @Inject(method={"addModifierTooltip(Ljava/util/function/Consumer;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/core/Holder;Lnet/minecraft/world/entity/ai/attributes/AttributeModifier;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void customFormattedAttributes_RWA(Consumer<Component> textConsumer, @Nullable Player player, Holder<Attribute> attribute, AttributeModifier modifier, CallbackInfo ci) {
        if (player != null) {
            if (attribute == EntityAttributes_RangedWeapon.DAMAGE.entry && modifier.is(AttributeModifierIDs.WEAPON_DAMAGE_ID) && modifier.operation().equals((Object)AttributeModifier.Operation.ADD_VALUE)) {
                this.addGreenText(textConsumer, attribute, modifier, modifier.amount());
                ci.cancel();
            }
            if (attribute == EntityAttributes_RangedWeapon.PULL_TIME.entry && modifier.is(AttributeModifierIDs.WEAPON_PULL_TIME_ID) && modifier.operation().equals((Object)AttributeModifier.Operation.ADD_VALUE)) {
                double value = modifier.amount() + player.getAttributeBaseValue(EntityAttributes_RangedWeapon.PULL_TIME.entry);
                this.addGreenText(textConsumer, attribute, modifier, value);
                ci.cancel();
            }
        }
    }

    private void addGreenText(Consumer<Component> textConsumer, Holder<Attribute> attribute, AttributeModifier modifier, double decimalValue) {
        textConsumer.accept((Component)CommonComponents.space().append((Component)Component.translatable((String)("attribute.modifier.equals." + modifier.operation().id()), (Object[])new Object[]{ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(decimalValue), Component.translatable((String)((Attribute)attribute.value()).getDescriptionId())})).withStyle(ChatFormatting.DARK_GREEN));
    }
}

