/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.ranged_weapon.mixin.item;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import net.fabric_extras.ranged_weapon.api.CustomRangedWeapon;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabric_extras.ranged_weapon.api.RangedConfig;
import net.fabric_extras.ranged_weapon.internal.ArrowExtension;
import net.fabric_extras.ranged_weapon.internal.AttributeUtils;
import net.fabric_extras.ranged_weapon.internal.RangedItemSettings;
import net.fabric_extras.ranged_weapon.internal.ScalingUtil;
import net.fabric_extras.ranged_weapon.mixin.item.ComponentMapBuilderAccessor;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ProjectileWeaponItem.class})
abstract class RangedWeaponItemMixin
extends Item
implements CustomRangedWeapon {
    private RangedConfig typeBaseLine = RangedConfig.BOW;

    RangedWeaponItemMixin(Item.Properties settings) {
        super(settings);
    }

    @ModifyVariable(method={"<init>(Lnet/minecraft/world/item/Item$Properties;)V"}, at=@At(value="HEAD"), ordinal=0)
    private static Item.Properties applyDefaultAttributes(Item.Properties settings) {
        RangedItemSettings rangedSettings = (RangedItemSettings)settings;
        RangedConfig config = rangedSettings.getRangedAttributes();
        if (config != null) {
            Reference2ObjectMap<DataComponentType<?>, Object> existingComponents;
            Object existing;
            ItemAttributeModifiers existingAttributes = null;
            DataComponentMap.Builder componentBuilder = rangedSettings.rwa_getComponentBuilder();
            if (componentBuilder != null && (existing = (existingComponents = ((ComponentMapBuilderAccessor)componentBuilder).rwa_components()).get((Object)DataComponents.ATTRIBUTE_MODIFIERS)) instanceof ItemAttributeModifiers) {
                ItemAttributeModifiers attributeModifiers;
                existingAttributes = attributeModifiers = (ItemAttributeModifiers)existing;
            }
            ItemAttributeModifiers rangedAttributes = AttributeUtils.fromRangedConfig(config);
            ItemAttributeModifiers applicableAttributes = AttributeUtils.mergeComponents(rangedAttributes, existingAttributes);
            return settings.attributes(applicableAttributes);
        }
        return settings;
    }

    @Override
    public void setTypeBaseline(RangedConfig config) {
        this.typeBaseLine = config;
    }

    @Override
    public RangedConfig getTypeBaseline() {
        return this.typeBaseLine;
    }

    @WrapOperation(method={"shoot(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/item/ItemStack;Ljava/util/List;FFZLnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ProjectileWeaponItem;shootProjectile(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/projectile/Projectile;IFFFLnet/minecraft/world/entity/LivingEntity;)V")})
    private void applyCustomVelocity_RWA(ProjectileWeaponItem instance, LivingEntity shooter, Projectile projectile, int index, float speed, float divergence, float yaw, @Nullable LivingEntity target, Operation<Void> original) {
        double bonusVelocity = shooter.getAttributeValue(EntityAttributes_RangedWeapon.VELOCITY.entry);
        double velocityMultiplier = ScalingUtil.arrowVelocityMultiplier((Item)instance, bonusVelocity);
        original.call(new Object[]{instance, shooter, projectile, index, Float.valueOf(speed *= (float)velocityMultiplier), Float.valueOf(divergence), Float.valueOf(yaw), target});
        if (projectile instanceof AbstractArrow) {
            double rangedDamage;
            AbstractArrow projectileEntity = (AbstractArrow)projectile;
            if (!((ArrowExtension)projectile).rwa_isModified() && (rangedDamage = shooter.getAttributeValue(EntityAttributes_RangedWeapon.DAMAGE.entry)) > 0.0) {
                double multiplier = ScalingUtil.arrowDamageMultiplier(this.getTypeBaseline().damage(), rangedDamage, velocityMultiplier);
                double finalDamage = projectileEntity.getBaseDamage() * multiplier;
                projectileEntity.setBaseDamage(finalDamage);
                ((ArrowExtension)projectile).rwa_markModified(true);
            }
        }
    }
}

