/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.ranged_weapon;

import java.util.List;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabric_extras.ranged_weapon.api.StatusEffects_RangedWeapon;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.alchemy.Potion;

public class RangedWeaponMod {
    public static final String NAMESPACE = "ranged_weapon";
    public static final String ID = "ranged_weapon_api";
    private static boolean potionRegistered = false;

    public static void init() {
        double boostEffectBonusPerLevel = 0.1;
        StatusEffects_RangedWeapon.DAMAGE.effect.addAttributeModifier(EntityAttributes_RangedWeapon.DAMAGE.entry, ResourceLocation.fromNamespaceAndPath((String)NAMESPACE, (String)"effect.damage"), boostEffectBonusPerLevel, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
        StatusEffects_RangedWeapon.HASTE.effect.addAttributeModifier(EntityAttributes_RangedWeapon.HASTE.entry, ResourceLocation.fromNamespaceAndPath((String)NAMESPACE, (String)"effect.haste"), boostEffectBonusPerLevel, AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    public static void registerAttributes() {
        for (EntityAttributes_RangedWeapon.Entry entry : EntityAttributes_RangedWeapon.all) {
            entry.register();
        }
    }

    public static void registerStatusEffects() {
        for (StatusEffects_RangedWeapon.Entry entry : StatusEffects_RangedWeapon.all) {
            entry.register();
        }
    }

    public static void registerPotions() {
        if (potionRegistered) {
            return;
        }
        potionRegistered = true;
        List<StatusEffects_RangedWeapon.Entry> entries = List.of(StatusEffects_RangedWeapon.DAMAGE, StatusEffects_RangedWeapon.HASTE);
        for (StatusEffects_RangedWeapon.Entry entry : entries) {
            Potion potion = new Potion(new MobEffectInstance[]{new MobEffectInstance(entry.entry, 3600)});
            Registry.register((Registry)BuiltInRegistries.POTION, (ResourceLocation)RangedWeaponMod.potionId(entry.id), (Object)potion);
        }
    }

    public static ResourceLocation potionId(ResourceLocation id) {
        return ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)(id.getNamespace() + "." + id.getPath()));
    }
}

