/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.ranged_weapon.internal;

import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;

public class ScalingUtil {
    public static final float STANDARD_BOW_VELOCITY = 3.0f;
    public static final float STANDARD_BOW_DAMAGE = 6.0f;
    public static final float STANDARD_CROSSBOW_VELOCITY = 3.15f;
    public static final float STANDARD_CROSSBOW_DAMAGE = 9.0f;
    public static final Scaling BOW_BASELINE = new Scaling(3.0, 6.0);
    public static final Scaling CROSSBOW_BASELINE = new Scaling(3.15f, 9.0);

    public static Scaling baselineFor(Item item) {
        if (item instanceof BowItem) {
            return BOW_BASELINE;
        }
        if (item instanceof CrossbowItem) {
            return CROSSBOW_BASELINE;
        }
        return new Scaling(1.0, 1.0);
    }

    public static double arrowVelocityMultiplier(double standardVelocity, double customVelocity) {
        return customVelocity / standardVelocity;
    }

    public static double arrowVelocityMultiplier(Item item, double bonusVelocity) {
        Scaling baseline = ScalingUtil.baselineFor(item);
        return (baseline.velocity() + bonusVelocity) / baseline.velocity();
    }

    public static double arrowDamageMultiplier(double standardDamage, double attributeDamage, double velocityMultiplier) {
        double multiplier = attributeDamage / standardDamage;
        if (velocityMultiplier != 1.0) {
            multiplier /= velocityMultiplier;
        }
        return multiplier;
    }

    public record Scaling(double velocity, double damage) {
    }
}

