/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.ranged_weapon.mixin.item;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import net.fabric_extras.ranged_weapon.api.AttributeModifierIDs;
import net.fabric_extras.ranged_weapon.api.CustomRangedWeapon;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.fabric_extras.ranged_weapon.api.RangedConfig;
import net.fabric_extras.ranged_weapon.internal.RangedItemSettings;
import net.fabric_extras.ranged_weapon.internal.ScalingUtil;
import net.fabric_extras.ranged_weapon.internal.Utils;
import net.fabric_extras.ranged_weapon.mixin.item.ComponentMapBuilderAccessor;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ProjectileWeaponItem.class})
abstract class RangedWeaponItemMixin
extends Item
implements CustomRangedWeapon {
    private RangedConfig typeBaseLine = RangedConfig.BOW;

    RangedWeaponItemMixin(Item.Properties settings) {
        super(settings);
    }

    @ModifyVariable(method={"<init>(Lnet/minecraft/world/item/Item$Properties;)V"}, at=@At(value="HEAD"), ordinal=0)
    private static Item.Properties applyDefaultAttributes(Item.Properties settings) {
        RangedItemSettings rangedSettings = (RangedItemSettings)settings;
        RangedConfig config = rangedSettings.getRangedAttributes();
        if (config != null) {
            DataComponentMap.Builder componentBuilder = rangedSettings.rwa_getComponentBuilder();
            Reference2ObjectMap<DataComponentType<?>, Object> existingComponents = ((ComponentMapBuilderAccessor)componentBuilder).rwa_components();
            ItemAttributeModifiers existingAttributes = null;
            Object existing = existingComponents.get((Object)DataComponents.ATTRIBUTE_MODIFIERS);
            if (existing instanceof ItemAttributeModifiers) {
                ItemAttributeModifiers attributeModifiers;
                existingAttributes = attributeModifiers = (ItemAttributeModifiers)existing;
            }
            ItemAttributeModifiers rangedAttributes = RangedWeaponItemMixin.createAttributeModifiers(config);
            ItemAttributeModifiers applicableAttributes = Utils.mergeAttributeComponents(rangedAttributes, existingAttributes);
            return settings.attributes(applicableAttributes);
        }
        return settings;
    }

    private static ItemAttributeModifiers createAttributeModifiers(RangedConfig config) {
        AttributeModifier damage = new AttributeModifier(AttributeModifierIDs.WEAPON_DAMAGE_ID, (double)config.damage(), AttributeModifier.Operation.ADD_VALUE);
        AttributeModifier pullTime = new AttributeModifier(AttributeModifierIDs.WEAPON_PULL_TIME_ID, (double)config.pull_time_bonus(), AttributeModifier.Operation.ADD_VALUE);
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder().add(EntityAttributes_RangedWeapon.DAMAGE.entry, damage, EquipmentSlotGroup.HAND).add(EntityAttributes_RangedWeapon.PULL_TIME.entry, pullTime, EquipmentSlotGroup.HAND);
        if (config.velocity_bonus() > 0.0f) {
            AttributeModifier velocity = new AttributeModifier(AttributeModifierIDs.WEAPON_VELOCITY_ID, (double)config.velocity_bonus(), AttributeModifier.Operation.ADD_VALUE);
            builder.add(EntityAttributes_RangedWeapon.VELOCITY.entry, velocity, EquipmentSlotGroup.HAND);
        }
        return builder.build();
    }

    @Override
    public void setTypeBaseline(RangedConfig config) {
        this.typeBaseLine = config;
    }

    @Override
    public RangedConfig getTypeBaseline() {
        return this.typeBaseLine;
    }

    @WrapOperation(method={"shoot(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/InteractionHand;Lnet/minecraft/world/item/ItemStack;Ljava/util/List;FFZLnet/minecraft/world/entity/LivingEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ProjectileWeaponItem;shootProjectile(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/projectile/Projectile;IFFFLnet/minecraft/world/entity/LivingEntity;)V")})
    private void applyCustomVelocity_RWA(ProjectileWeaponItem instance, LivingEntity shooter, Projectile projectile, int index, float speed, float divergence, float yaw, @Nullable LivingEntity target, Operation<Void> original) {
        double bonusVelocity = shooter.getAttributeValue(EntityAttributes_RangedWeapon.VELOCITY.entry);
        double velocityMultiplier = ScalingUtil.arrowVelocityMultiplier((Item)instance, bonusVelocity);
        original.call(new Object[]{instance, shooter, projectile, index, Float.valueOf(speed *= (float)velocityMultiplier), Float.valueOf(divergence), Float.valueOf(yaw), target});
        if (projectile instanceof AbstractArrow) {
            AbstractArrow projectileEntity = (AbstractArrow)projectile;
            double rangedDamage = shooter.getAttributeValue(EntityAttributes_RangedWeapon.DAMAGE.entry);
            if (rangedDamage > 0.0) {
                double multiplier = ScalingUtil.arrowDamageMultiplier(this.getTypeBaseline().damage(), rangedDamage, velocityMultiplier);
                double finalDamage = projectileEntity.getBaseDamage() * multiplier;
                projectileEntity.setBaseDamage(finalDamage);
            }
        }
    }
}

