/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.shadowtrace.commands;

import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import no.vestlandetmc.shadowtrace.ShadowTrace;
import no.vestlandetmc.shadowtrace.config.Messages;
import no.vestlandetmc.shadowtrace.handlers.MessageHandler;
import no.vestlandetmc.shadowtrace.handlers.Permissions;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.Nullable;

public class ShadowTraceCommand
implements BasicCommand {
    public void execute(@NotNull CommandSourceStack commandSourceStack, String @NotNull [] args) {
        Object object = commandSourceStack.getSender();
        if (!(object instanceof Player)) {
            MessageHandler.sendConsole(Messages.SHTC_ONLY_PLAYER);
            return;
        }
        Player player = (Player)object;
        if (args.length == 0) {
            MessageHandler.sendMessage(player, Messages.SHTC_INVALID_ARG_GETORES);
            return;
        }
        switch (args[0]) {
            case "getores": {
                if (args.length < 3) {
                    MessageHandler.sendMessage(player, Messages.SHTC_INVALID_ARG_GETORES);
                    break;
                }
                String targetName = args[1];
                String time = args[2];
                OfflinePlayer targetPlayer = Bukkit.getOfflinePlayerIfCached((String)targetName);
                if (targetPlayer == null) {
                    MessageHandler.sendMessage(player, Messages.SHTC_INVALID_PLAYER);
                    return;
                }
                World.Environment env = player.getWorld().getEnvironment();
                if (env == World.Environment.NETHER) {
                    ShadowTrace.getCoreProtectManager().findOresNether(player, targetPlayer, time);
                    break;
                }
                if (env == World.Environment.NORMAL) {
                    ShadowTrace.getCoreProtectManager().findOres(player, targetPlayer, time);
                    break;
                }
                MessageHandler.sendMessage(player, Messages.SHTC_NO_ORES);
                break;
            }
            case "teleport": {
                if (args.length < 4) break;
                double x = Double.parseDouble(args[1]);
                double y = Double.parseDouble(args[2]);
                double z = Double.parseDouble(args[3]);
                Location loc = new Location(player.getWorld(), x, y, z);
                player.teleport(loc, PlayerTeleportEvent.TeleportCause.COMMAND);
                break;
            }
            case "blocks": {
                if (args.length < 4) {
                    MessageHandler.sendMessage(player, Messages.SHTC_INVALID_ARG_BLOCKS);
                    break;
                }
                String targetName = args[1];
                String time = args[2];
                List<Object> blocks = Arrays.stream(args[3].split(",")).map(Material::matchMaterial).filter(Objects::nonNull).filter(Material::isSolid).map(m -> m).toList();
                OfflinePlayer targetPlayer = Bukkit.getOfflinePlayerIfCached((String)targetName);
                if (targetPlayer == null) {
                    MessageHandler.sendMessage(player, Messages.SHTC_INVALID_PLAYER);
                    return;
                }
                if (blocks.isEmpty()) {
                    MessageHandler.sendMessage(player, Messages.SHTC_NO_VALID_BLOCKS);
                    return;
                }
                ShadowTrace.getCoreProtectManager().findBlocks(player, targetPlayer, time, blocks);
            }
        }
    }

    @NotNull
    public Collection<String> suggest(@NotNull CommandSourceStack commandSourceStack, String @NotNull [] args) {
        List<String> subs = List.of("getores", "blocks");
        if (args.length == 0) {
            return subs;
        }
        if (args.length == 1) {
            return subs.stream().filter(s -> s.startsWith(args[0].toLowerCase()) || args[0].isEmpty()).toList();
        }
        if (args.length == 2) {
            return Bukkit.getOnlinePlayers().stream().map(Player::getName).filter(name -> name.toLowerCase().startsWith(args[1].toLowerCase())).toList();
        }
        if (args.length == 3) {
            return Stream.of("1m", "1h", "1d").filter(s -> s.startsWith(args[2].toLowerCase())).toList();
        }
        return List.of();
    }

    public boolean canUse(@NotNull CommandSender sender) {
        return super.canUse(sender);
    }

    public @Nullable String permission() {
        return Permissions.SHT_COMMAND.getName();
    }
}

