/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.shadowtrace.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import no.vestlandetmc.shadowtrace.ShadowTrace;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;

public class ConfigHandler
extends YamlConfiguration {
    private final File file;
    private final YamlConfiguration defaults;
    private String pathPrefix;

    public ConfigHandler(String fileName) {
        this(fileName, true);
    }

    public ConfigHandler(String fileName, boolean useDefaults) {
        ShadowTrace plugin = ShadowTrace.getPlugin();
        this.file = new File(plugin.getDataFolder(), fileName);
        if (useDefaults) {
            try (InputStream defaultStream = plugin.getResource(fileName);){
                if (defaultStream != null) {
                    this.defaults = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream, StandardCharsets.UTF_8));
                }
                this.defaults = null;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load default config for " + fileName, e);
            }
        } else {
            this.defaults = null;
        }
        this.extractDefaults(fileName);
        this.loadConfig();
    }

    public void reloadConfig() {
        this.saveConfig();
        this.loadConfig();
    }

    public void write(String path, Object value) {
        this.set(path, value);
        this.saveConfig();
    }

    public void saveConfig() {
        try {
            super.save(this.file);
        }
        catch (IOException e) {
            ShadowTrace.getPlugin().getLogger().severe("Failed to save config: " + e.getMessage());
        }
    }

    private void loadConfig() {
        try {
            super.load(this.file);
        }
        catch (Exception e) {
            ShadowTrace.getPlugin().getLogger().severe("Failed to load config: " + e.getMessage());
        }
    }

    public Object get(@NotNull String path, Object def) {
        Object defaultValue;
        if (this.defaults != null && def != null && !PrimitiveWrapper.isWrapperType(def.getClass())) {
            throw new IllegalArgumentException("Defaults must be null. Using defaults from file. Path: " + (String)path);
        }
        if (this.defaults != null && super.get((String)path, null) == null && (defaultValue = this.defaults.get((String)path)) != null) {
            this.write((String)path, defaultValue);
        }
        if (this.defaults == null && this.pathPrefix != null && !this.calledFrom("getConfigurationSection") && !this.calledFrom("get")) {
            path = this.pathPrefix + "." + (String)path;
        }
        return super.get((String)path, null);
    }

    public void set(@NotNull String path, Object value) {
        if (this.defaults == null && this.pathPrefix != null && !this.calledFrom("getConfigurationSection") && !this.calledFrom("get")) {
            path = this.pathPrefix + "." + (String)path;
        }
        super.set((String)path, value);
    }

    private void extractDefaults(String fileName) {
        if (!this.file.exists()) {
            try {
                Files.createDirectories(this.file.getParentFile().toPath(), new FileAttribute[0]);
                Files.copy(ShadowTrace.getPlugin().getResource(fileName), this.file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                ShadowTrace.getPlugin().getLogger().severe("Failed to extract default config: " + e.getMessage());
            }
        }
    }

    private boolean calledFrom(String methodName) {
        return new Throwable().getStackTrace()[1].getMethodName().equals(methodName);
    }

    @Generated
    public void setPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
    }

    private static final class PrimitiveWrapper {
        private static final Set<Class<?>> WRAPPER_TYPES = PrimitiveWrapper.getWrapperTypes();

        private PrimitiveWrapper() {
        }

        private static boolean isWrapperType(Class<?> clazz) {
            return WRAPPER_TYPES.contains(clazz);
        }

        private static Set<Class<?>> getWrapperTypes() {
            HashSet ret = new HashSet();
            ret.add(Boolean.class);
            ret.add(Character.class);
            ret.add(Byte.class);
            ret.add(Short.class);
            ret.add(Integer.class);
            ret.add(Long.class);
            ret.add(Float.class);
            ret.add(Double.class);
            ret.add(Void.class);
            return ret;
        }
    }
}

