/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.shadowtrace.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.coreprotect.CoreProtect;
import net.coreprotect.CoreProtectAPI;
import no.vestlandetmc.shadowtrace.ShadowTrace;
import no.vestlandetmc.shadowtrace.config.Messages;
import no.vestlandetmc.shadowtrace.handlers.MessageHandler;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class CoreProtectManager {
    private final List<Object> blocksOverworld = Arrays.asList(Material.COAL_ORE, Material.COPPER_ORE, Material.DIAMOND_ORE, Material.GOLD_ORE, Material.LAPIS_ORE, Material.EMERALD_ORE, Material.IRON_ORE, Material.REDSTONE_ORE, Material.DEEPSLATE_COAL_ORE, Material.DEEPSLATE_COPPER_ORE, Material.DEEPSLATE_DIAMOND_ORE, Material.DEEPSLATE_GOLD_ORE, Material.DEEPSLATE_LAPIS_ORE, Material.DEEPSLATE_EMERALD_ORE, Material.DEEPSLATE_IRON_ORE, Material.DEEPSLATE_REDSTONE_ORE, Material.SPAWNER);
    private final List<Object> blocksNether = Arrays.asList(Material.ANCIENT_DEBRIS, Material.NETHER_GOLD_ORE, Material.SPAWNER);
    private CoreProtectAPI coreProtectAPI;
    private String reason;

    public CoreProtectManager() {
        CoreProtectAPI coreProtectAPI;
        Plugin plugin = ShadowTrace.getPlugin().getServer().getPluginManager().getPlugin("CoreProtect");
        if (!(plugin instanceof CoreProtect)) {
            this.coreProtectAPI = null;
            this.reason = "CoreProtect was not found.";
        }
        if (!(coreProtectAPI = ((CoreProtect)plugin).getAPI()).isEnabled() || coreProtectAPI.APIVersion() < 10) {
            this.coreProtectAPI = null;
            this.reason = "CoreProtect requires API version 10 or higher.";
        } else {
            this.coreProtectAPI = coreProtectAPI;
            this.reason = "CoreProtect was found and connected.";
        }
    }

    public void findBlocks(Player player, OfflinePlayer target, String time, List<Object> blocks) {
        List<String> username = Arrays.asList(target.getName());
        List<Integer> action = Arrays.asList(0);
        int taskId = Bukkit.getScheduler().runTaskTimer((Plugin)ShadowTrace.getPlugin(), () -> MessageHandler.sendAction(player, Messages.SRC_ACTION_SEARCH), 0L, 40L).getTaskId();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)ShadowTrace.getPlugin(), () -> {
            List lookup = this.coreProtectAPI.performLookup(this.convertToSeconds(time), username, null, blocks, null, action, 0, null);
            ArrayList<String> messageList = new ArrayList<String>();
            for (int i = 0; i < lookup.size() && i < 1500; ++i) {
                String[] result = (String[])lookup.get(i);
                CoreProtectAPI.ParseResult parseResult = this.coreProtectAPI.parseResult(result);
                String world = parseResult.worldName();
                if (!player.getWorld().getName().equals(world)) continue;
                long timestamp = parseResult.getTimestamp() / 1000L;
                int locX = parseResult.getX();
                int locY = parseResult.getY();
                int locZ = parseResult.getZ();
                String block = parseResult.getBlockData().getMaterial().name();
                String out = world + ":" + locX + ":" + locY + ":" + locZ + ":" + block + ":" + timestamp;
                messageList.add(out);
            }
            if (messageList.isEmpty()) {
                Bukkit.getScheduler().cancelTask(taskId);
                MessageHandler.sendMessage(player, "&6[&eShadowTrace&6] " + Messages.SRC_NO_DATA_FOUND);
                MessageHandler.sendAction(player, Messages.SRC_ACTION_NO_DATA_FOUND);
            } else {
                ShadowTrace.getPacketHandler().sendData(player, messageList);
                Bukkit.getScheduler().cancelTask(taskId);
                MessageHandler.sendMessage(player, "&6[&eShadowTrace&6] " + Messages.SRC_DATA_FOUND);
                MessageHandler.sendAction(player, Messages.SRC_ACTION_DATA_FOUND);
            }
        });
    }

    public void findOres(Player player, OfflinePlayer target, String time) {
        List<String> username = Arrays.asList(target.getName());
        List<Integer> action = Arrays.asList(0);
        int taskId = Bukkit.getScheduler().runTaskTimer((Plugin)ShadowTrace.getPlugin(), () -> MessageHandler.sendAction(player, Messages.SRC_ACTION_SEARCH), 0L, 40L).getTaskId();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)ShadowTrace.getPlugin(), () -> {
            List lookup = this.coreProtectAPI.performLookup(this.convertToSeconds(time), username, null, this.blocksOverworld, null, action, 0, null);
            ArrayList<String> messageList = new ArrayList<String>();
            for (int i = 0; i < lookup.size() && i < 1500; ++i) {
                String[] result = (String[])lookup.get(i);
                CoreProtectAPI.ParseResult parseResult = this.coreProtectAPI.parseResult(result);
                long timestamp = parseResult.getTimestamp() / 1000L;
                int locX = parseResult.getX();
                int locY = parseResult.getY();
                int locZ = parseResult.getZ();
                String world = parseResult.worldName();
                String block = parseResult.getBlockData().getMaterial().name();
                String out = world + ":" + locX + ":" + locY + ":" + locZ + ":" + block + ":" + timestamp;
                messageList.add(out);
            }
            if (messageList.isEmpty()) {
                Bukkit.getScheduler().cancelTask(taskId);
                MessageHandler.sendMessage(player, "&6[&eShadowTrace&6] " + Messages.SRC_NO_DATA_FOUND);
                MessageHandler.sendAction(player, Messages.SRC_ACTION_NO_DATA_FOUND);
            } else {
                ShadowTrace.getPacketHandler().sendData(player, messageList);
                Bukkit.getScheduler().cancelTask(taskId);
                MessageHandler.sendMessage(player, "&6[&eShadowTrace&6] " + Messages.SRC_DATA_FOUND);
                MessageHandler.sendAction(player, Messages.SRC_ACTION_DATA_FOUND);
            }
        });
    }

    public void findOresNether(Player player, OfflinePlayer target, String time) {
        List<String> username = Arrays.asList(target.getName());
        List<Integer> action = Arrays.asList(0);
        int taskId = Bukkit.getScheduler().runTaskTimer((Plugin)ShadowTrace.getPlugin(), () -> MessageHandler.sendAction(player, Messages.SRC_ACTION_SEARCH), 0L, 40L).getTaskId();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)ShadowTrace.getPlugin(), () -> {
            List lookup = this.coreProtectAPI.performLookup(this.convertToSeconds(time), username, null, this.blocksNether, null, action, 0, null);
            ArrayList<String> messageList = new ArrayList<String>();
            for (int i = 0; i < lookup.size() && i < 300; ++i) {
                String[] result = (String[])lookup.get(i);
                CoreProtectAPI.ParseResult parseResult = this.coreProtectAPI.parseResult(result);
                long timestamp = parseResult.getTimestamp() / 1000L;
                int locX = parseResult.getX();
                int locY = parseResult.getY();
                int locZ = parseResult.getZ();
                String world = parseResult.worldName();
                String block = parseResult.getBlockData().getMaterial().name();
                String out = world + ":" + locX + ":" + locY + ":" + locZ + ":" + block + ":" + timestamp;
                messageList.add(out);
            }
            if (messageList.isEmpty()) {
                Bukkit.getScheduler().cancelTask(taskId);
                MessageHandler.sendMessage(player, "&6[&eShadowTrace&6] " + Messages.SRC_NO_DATA_FOUND);
                MessageHandler.sendAction(player, Messages.SRC_ACTION_NO_DATA_FOUND);
            } else {
                ShadowTrace.getPacketHandler().sendData(player, messageList);
                Bukkit.getScheduler().cancelTask(taskId);
                MessageHandler.sendMessage(player, "&6[&eShadowTrace&6] " + Messages.SRC_DATA_FOUND);
                MessageHandler.sendAction(player, Messages.SRC_ACTION_DATA_FOUND);
            }
        });
    }

    private int convertToSeconds(String timeString) {
        int totalSeconds = 0;
        String regex = "(\\d+)([dhm])";
        Pattern pattern = Pattern.compile("(\\d+)([dhm])");
        Matcher matcher = pattern.matcher(timeString);
        block10: while (matcher.find()) {
            String unit;
            int value = Integer.parseInt(matcher.group(1));
            switch (unit = matcher.group(2)) {
                case "d": {
                    totalSeconds += value * 86400;
                    continue block10;
                }
                case "h": {
                    totalSeconds += value * 3600;
                    continue block10;
                }
                case "m": {
                    totalSeconds += value * 60;
                    continue block10;
                }
            }
            return 0;
        }
        return totalSeconds;
    }

    @Generated
    public List<Object> getBlocksOverworld() {
        return this.blocksOverworld;
    }

    @Generated
    public List<Object> getBlocksNether() {
        return this.blocksNether;
    }

    @Generated
    public CoreProtectAPI getCoreProtectAPI() {
        return this.coreProtectAPI;
    }

    @Generated
    public String getReason() {
        return this.reason;
    }
}

