/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.shadowtrace.handlers;

import java.time.Duration;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.title.Title;
import no.vestlandetmc.shadowtrace.ShadowTrace;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class MessageHandler {
    public static void sendAction(Player player, String message) {
        Component text = MessageHandler.colorize(message);
        player.sendActionBar(text);
    }

    public static void sendTitle(Player player, String maintitle, String subtitle) {
        Component main = MessageHandler.colorize(maintitle);
        Component sub = MessageHandler.colorize(subtitle);
        Title title = Title.title((Component)main, (Component)sub);
        player.showTitle(title);
    }

    public static void sendTitle(Player player, String maintitle, String subtitle, int fadein, int stay, int fadeout) {
        Component main = MessageHandler.colorize(maintitle);
        Component sub = MessageHandler.colorize(subtitle);
        Title.Times times = Title.Times.times((Duration)Duration.ofSeconds(fadein), (Duration)Duration.ofSeconds(stay), (Duration)Duration.ofSeconds(fadeout));
        Title title = Title.title((Component)main, (Component)sub, (Title.Times)times);
        player.showTitle(title);
    }

    public static void sendMessage(Player player, String ... message) {
        for (String s : message) {
            MessageHandler.sendMessage(player, s);
        }
    }

    public static void sendMessage(Player player, String message) {
        Component text = MessageHandler.colorize(message);
        player.sendMessage(text);
    }

    public static void sendAnnounce(String message) {
        Component text = MessageHandler.colorize(message);
        for (Player player : Bukkit.getOnlinePlayers()) {
            player.sendMessage(text);
        }
    }

    public static void sendConsole(String ... message) {
        for (String m : message) {
            MessageHandler.sendConsole(m);
        }
    }

    public static void sendConsole(String message) {
        Component text = MessageHandler.colorize(message);
        ShadowTrace.getPlugin().getServer().getConsoleSender().sendMessage(text);
    }

    public static Component colorize(String ... messages) {
        TextComponent finalMessage = null;
        int c = 1;
        for (String m : messages) {
            if (finalMessage == null) {
                finalMessage = (TextComponent)LegacyComponentSerializer.legacy((char)'&').deserialize(m).append((Component)Component.newline());
            } else if (c == messages.length) {
                more = LegacyComponentSerializer.legacy((char)'&').deserialize(m);
                finalMessage = (TextComponent)finalMessage.append((Component)more);
            } else {
                more = LegacyComponentSerializer.legacy((char)'&').deserialize(m).append((Component)Component.newline());
                finalMessage = (TextComponent)finalMessage.append((Component)more);
            }
            ++c;
        }
        return finalMessage;
    }

    public static Component colorize(String message) {
        return LegacyComponentSerializer.legacy((char)'&').deserialize(message);
    }
}

