/*
 * Decompiled with CFR 0.152.
 */
package no.vestlandetmc.shadowtrace.handlers;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import no.vestlandetmc.shadowtrace.ShadowTrace;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PacketHandler {
    private final ShadowTrace plugin;
    private final String channel;

    public PacketHandler(ShadowTrace plugin, String channel) {
        this.plugin = plugin;
        this.channel = channel;
        plugin.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)plugin, channel);
    }

    public void sendData(Player player, List<String> messageList) {
        try (ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
             DataOutputStream out = new DataOutputStream(byteStream);){
            out.writeInt(messageList.size());
            for (String message : messageList) {
                byte[] bytes = message.getBytes(StandardCharsets.UTF_8);
                out.writeInt(bytes.length);
                out.write(bytes);
            }
            player.sendPluginMessage((Plugin)this.plugin, this.channel, byteStream.toByteArray());
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Error sending data: " + e.getMessage());
        }
    }
}

