/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.layer;

import dev.xylonity.companions.common.blockentity.AbstractTeslaBlockEntity;
import dev.xylonity.companions.common.blockentity.RecallPlatformBlockEntity;
import dev.xylonity.companions.common.event.CompanionsEntityTracker;
import dev.xylonity.companions.common.tesla.TeslaConnectionManager;
import dev.xylonity.companions.common.util.interfaces.ITeslaUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.texture.AutoGlowingTexture;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class ElectricConnectionLayer<T extends AbstractTeslaBlockEntity>
extends GeoRenderLayer<T>
implements ITeslaUtil {
    private final class_2960 texture;
    private final int totalFrames;
    private final int ticksPerFrame;

    public ElectricConnectionLayer(GeoRenderer<T> renderer, class_2960 texture, int totalFrames, int ticksPerFrame) {
        super(renderer);
        this.texture = texture;
        this.totalFrames = totalFrames;
        this.ticksPerFrame = ticksPerFrame;
    }

    public void render(class_4587 poseStack, T animatable, BakedGeoModel bakedModel, class_1921 renderType, class_4597 bufferSource, class_4588 buffer, float partialTick, int packedLight, int packedOverlay) {
        if (!((AbstractTeslaBlockEntity)((Object)animatable)).isActive()) {
            return;
        }
        int frame = this.calculateCurrentFrame(animatable);
        if (frame < 0) {
            return;
        }
        for (TeslaConnectionManager.ConnectionNode node : TeslaConnectionManager.getInstance().getOutgoing(((AbstractTeslaBlockEntity)((Object)animatable)).asConnectionNode())) {
            AbstractTeslaBlockEntity be;
            if (node == null) continue;
            if (node.isEntity()) {
                class_1297 entity = CompanionsEntityTracker.getEntityByUUID(node.entityId());
                if (!(entity instanceof class_1309)) continue;
                class_1309 livingEntity = (class_1309)entity;
                class_243 offset = new class_243(0.0, 1.25, 0.0);
                class_243 dir = livingEntity.method_19538().method_1020(animatable.method_11016().method_46558()).method_1031(0.0, (double)livingEntity.method_17682() * 1.1, 0.0);
                this.renderConnection(bufferSource, poseStack, offset, dir, frame, packedLight);
                continue;
            }
            if (!node.isBlock() || (be = TeslaConnectionManager.getInstance().getBlockEntity(node)) == null) continue;
            class_243 offset = ((AbstractTeslaBlockEntity)((Object)animatable)).electricalChargeOriginOffset();
            class_243 blockPos = be.method_11016().method_46558();
            class_243 blockPosVec = new class_243(blockPos.field_1352, blockPos.field_1351, blockPos.field_1350);
            class_243 endOffset = be instanceof RecallPlatformBlockEntity ? this.calculateClosestFaceOffset(animatable.method_11016().method_46558(), blockPosVec) : be.electricalChargeEndOffset();
            class_243 dir = blockPosVec.method_1020(animatable.method_11016().method_46558()).method_1019(endOffset);
            this.renderConnection(bufferSource, poseStack, offset, dir, frame, packedLight);
        }
    }

    private class_243 calculateClosestFaceOffset(class_243 sourcePos, class_243 targetPos) {
        class_243[] faceOffsets = new class_243[]{new class_243(0.0, -0.45, -0.5), new class_243(0.0, 0.0, 0.5), new class_243(0.5, 0.0, 0.0), new class_243(-0.5, 0.0, 0.0)};
        class_243 closest = class_243.field_1353;
        double minDist = Double.MAX_VALUE;
        for (class_243 faceOffset : faceOffsets) {
            double distance = sourcePos.method_1022(targetPos.method_1019(faceOffset));
            if (!(distance < minDist)) continue;
            minDist = distance;
            closest = faceOffset;
        }
        return closest;
    }

    private int calculateCurrentFrame(T animatable) {
        int frame = ((AbstractTeslaBlockEntity)((Object)animatable)).getAnimationStartTick() / this.ticksPerFrame;
        if (frame >= this.totalFrames) {
            return -1;
        }
        return frame;
    }

    private void renderConnection(class_4597 bufferSource, class_4587 poseStack, class_243 p0, class_243 p1, int frame, int light) {
        int[] ids;
        class_4588 vertexConsumer = bufferSource.getBuffer(AutoGlowingTexture.getRenderType((class_2960)this.texture));
        Matrix4f positionMatrix = poseStack.method_23760().method_23761();
        Matrix3f normalMatrix = poseStack.method_23760().method_23762();
        float x0 = (float)p0.field_1352;
        float y0 = (float)p0.field_1351;
        float z0 = (float)p0.field_1350;
        float x1 = (float)p1.field_1352;
        float y1 = (float)p1.field_1351;
        float z1 = (float)p1.field_1350;
        float dx = x1 - x0;
        float dy = y1 - y0;
        float dz = z1 - z0;
        if (dx == 0.0f) {
            dx = 0.001f;
        }
        float dHorizontal = class_3532.method_15355((float)(dx * dx + dz * dz));
        float length = class_3532.method_15355((float)(dHorizontal * dHorizontal + dy * dy));
        float offset = 0.5f;
        float yOffset = offset * (dHorizontal / length);
        float xOffset = offset * (dy / length) * (dx / dHorizontal);
        float zOffset = offset * (dy / length) * (dz / dHorizontal);
        float frameSize = 1.0f / (float)this.totalFrames;
        float v0 = (float)frame * frameSize;
        float v1 = v0 + frameSize;
        VertexCoordinates[] vertices = new VertexCoordinates[]{new VertexCoordinates(x0 + xOffset, y0 - yOffset, z0 + zOffset, 0.0f, v1), new VertexCoordinates(x1 + xOffset, y1 - yOffset, z1 + zOffset, 1.0f, v1), new VertexCoordinates(x1 - xOffset, y1 + yOffset, z1 - zOffset, 1.0f, v0), new VertexCoordinates(x0 - xOffset, y0 + yOffset, z0 - zOffset, 0.0f, v0)};
        for (int i : ids = new int[]{0, 1, 2, 3, 3, 2, 1, 0}) {
            this.produceVertex(vertexConsumer, positionMatrix, normalMatrix, vertices[i].x, vertices[i].y, vertices[i].z, vertices[i].u, vertices[i].v);
        }
    }

    private void produceVertex(class_4588 vertexConsumer, Matrix4f positionMatrix, Matrix3f normalMatrix, float x, float y, float z, float textureU, float textureV) {
        vertexConsumer.method_22918(positionMatrix, x, y, z).method_1336(255, 255, 255, 255).method_22913(textureU, textureV).method_22922(class_4608.field_21444).method_22916(0xF000F0).method_23763(normalMatrix, 0.0f, 1.0f, 0.0f).method_1344();
    }

    private record VertexCoordinates(float x, float y, float z, float u, float v) {
    }
}

