/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.cornelius;

import dev.xylonity.companions.common.entity.companion.CorneliusEntity;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public abstract class AbstractCorneliusAttackGoal
extends class_1352 {
    protected final CorneliusEntity cornelius;
    protected final int minCooldown;
    protected final int maxCooldown;
    protected int attackTicks;
    protected int nextUseTick;
    protected boolean started;
    protected int currentAttackDelay;
    protected int currentAttackDuration;
    protected static final int SPAWN_RADIUS = 3;
    protected static final int MAX_SPAWN_ATTEMPTS = 20;

    public AbstractCorneliusAttackGoal(CorneliusEntity cornelius, int minCd, int maxCd) {
        this.cornelius = cornelius;
        this.minCooldown = minCd;
        this.maxCooldown = maxCd;
        this.nextUseTick = -1;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        if (!this.cornelius.method_6181()) {
            return false;
        }
        if (!this.cornelius.canAttack()) {
            return false;
        }
        if (this.cornelius.getAttackType() != 0) {
            return false;
        }
        if (this.cornelius.method_5968() == null) {
            return false;
        }
        if (!this.hasSufficientCoins()) {
            this.nextUseTick = -1;
            return false;
        }
        if (this.nextUseTick < 0) {
            int cd = this.minCooldown + this.cornelius.method_6051().method_43048(this.maxCooldown - this.minCooldown + 1);
            this.nextUseTick = this.cornelius.field_6012 + cd;
            return false;
        }
        return this.cornelius.field_6012 >= this.nextUseTick;
    }

    public boolean method_6266() {
        return this.started && this.attackTicks < this.currentAttackDuration;
    }

    public void method_6269() {
        int currentAttackType = this.cornelius.method_6051().method_43048(3) + 1;
        switch (currentAttackType) {
            case 1: {
                this.currentAttackDelay = 15;
                this.currentAttackDuration = 30;
                break;
            }
            case 2: {
                this.currentAttackDelay = 17;
                this.currentAttackDuration = 25;
                break;
            }
            default: {
                this.currentAttackDelay = 18;
                this.currentAttackDuration = 26;
            }
        }
        this.attackTicks = 0;
        this.started = true;
        this.cornelius.setAttackType(currentAttackType);
        this.cornelius.setSummonedCount(this.cornelius.getSummonedCount() + 1);
        this.consumeCoins();
        this.cornelius.method_43077(CompanionsSounds.FROGGY_ATTACK.get());
    }

    public void method_6270() {
        this.started = false;
        this.cornelius.setAttackType(0);
        this.nextUseTick = -1;
    }

    public void method_6268() {
        class_1309 target = this.cornelius.method_5968();
        if (target != null) {
            this.cornelius.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
        }
        if (this.attackTicks == this.currentAttackDelay && target != null && target.method_5805()) {
            this.performAttack(target);
        }
        ++this.attackTicks;
    }

    public boolean method_38846() {
        return true;
    }

    protected boolean hasSufficientCoins() {
        int found = 0;
        for (int i = 0; i <= 2; ++i) {
            class_1799 stack = this.cornelius.inventory.method_5438(i);
            if (stack.method_7909() != this.coin() || (found += stack.method_7947()) < this.coinsToConsume()) continue;
            return true;
        }
        return false;
    }

    protected void consumeCoins() {
        int toConsume = this.coinsToConsume();
        for (int i = 0; i <= 2 && toConsume > 0; ++i) {
            class_1799 stack = this.cornelius.inventory.method_5438(i);
            if (stack.method_7909() != this.coin()) continue;
            int remove = Math.min(toConsume, stack.method_7947());
            stack.method_7934(remove);
            toConsume -= remove;
            this.cornelius.inventory.method_5447(i, stack);
        }
    }

    protected boolean isValidSpawnPosition(class_1937 level, class_2338 pos) {
        class_2338 abovePos = pos.method_10084();
        return !level.method_8320(pos).method_26216((class_1922)level, pos) && !level.method_8320(abovePos).method_26216((class_1922)level, abovePos) && level.method_8320(pos.method_10074()).method_26216((class_1922)level, pos.method_10074());
    }

    protected class_2338 findPosAroundCornelius() {
        for (int attempt = 0; attempt < 20; ++attempt) {
            int x = this.cornelius.method_24515().method_10263() + this.cornelius.method_6051().method_43048(7) - 3;
            int z = this.cornelius.method_24515().method_10260() + this.cornelius.method_6051().method_43048(7) - 3;
            class_2338 surf = this.findSurfacePosition(this.cornelius.method_37908(), new class_2338(x, this.cornelius.method_24515().method_10264(), z));
            if (surf == null || !this.isValidSpawnPosition(this.cornelius.method_37908(), surf)) continue;
            return surf;
        }
        return this.cornelius.method_24515();
    }

    protected class_2338 findPosAroundTarget() {
        if (this.cornelius.method_5968() != null) {
            for (int attempt = 0; attempt < 40; ++attempt) {
                int x = this.cornelius.method_5968().method_24515().method_10263() + this.cornelius.method_5968().method_6051().method_43048(15) - 7;
                int z = this.cornelius.method_5968().method_24515().method_10260() + this.cornelius.method_5968().method_6051().method_43048(15) - 7;
                class_2338 surf = this.findSurfacePosition(this.cornelius.method_5968().method_37908(), new class_2338(x, this.cornelius.method_5968().method_24515().method_10264(), z));
                if (surf == null || !this.isValidSpawnPosition(this.cornelius.method_5968().method_37908(), surf)) continue;
                return surf;
            }
            return this.cornelius.method_5968().method_24515();
        }
        return this.cornelius.method_24515();
    }

    private class_2338 findSurfacePosition(class_1937 level, class_2338 startPos) {
        class_2338 abovePos;
        class_2338 checkPos;
        int y;
        for (y = startPos.method_10264(); y > level.method_31607(); --y) {
            checkPos = new class_2338(startPos.method_10263(), y, startPos.method_10260());
            abovePos = checkPos.method_10084();
            if (!level.method_8320(checkPos).method_26216((class_1922)level, checkPos) || level.method_8320(abovePos).method_26216((class_1922)level, abovePos)) continue;
            return abovePos;
        }
        for (y = startPos.method_10264(); y < level.method_31600(); ++y) {
            checkPos = new class_2338(startPos.method_10263(), y, startPos.method_10260());
            abovePos = checkPos.method_10084();
            if (!level.method_8320(checkPos).method_26216((class_1922)level, checkPos) || level.method_8320(abovePos).method_26216((class_1922)level, abovePos)) continue;
            return abovePos;
        }
        return null;
    }

    protected abstract void performAttack(class_1309 var1);

    protected abstract class_1792 coin();

    protected abstract int coinsToConsume();
}

