/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.ai.mage.goal;

import dev.xylonity.companions.common.entity.ai.mage.AbstractSoulMageAttackGoal;
import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import dev.xylonity.companions.common.entity.projectile.MagicRayCircleProjectile;
import dev.xylonity.companions.common.entity.projectile.MagicRayPieceProjectile;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsItems;
import dev.xylonity.knightlib.api.scheduler.TickScheduler;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class SoulMageMagicRayGoal
extends AbstractSoulMageAttackGoal {
    public SoulMageMagicRayGoal(SoulMageEntity soulMage, int minCd, int maxCd) {
        super(soulMage, minCd, maxCd, "MAGIC_RAY");
    }

    @Override
    protected void performAttack(class_1309 target) {
        if (target != null) {
            class_243 baseDir = target.method_19538().method_1020(this.soulMage.method_19538()).method_1029();
            double traveled = 0.0;
            for (int i = 0; i < 30; ++i) {
                class_243 piecePos = this.soulMage.method_5836(1.0f).method_1019(baseDir).method_1019(baseDir.method_1021(traveled));
                traveled += 1.0;
                class_2338 blockPos = class_2338.method_49638((class_2374)piecePos);
                if (!this.isPassableBlock(this.soulMage.method_37908(), blockPos)) {
                    this.spawnRayPiece(this.soulMage.method_37908(), this.soulMage, piecePos, baseDir, i == 0);
                    break;
                }
                this.spawnRayPiece(this.soulMage.method_37908(), this.soulMage, piecePos, baseDir, i == 0);
            }
        }
    }

    private boolean isPassableBlock(class_1937 level, class_2338 pos) {
        return level.method_8320(pos).method_26220((class_1922)level, pos).method_1110();
    }

    private void spawnRayPiece(class_1937 pLevel, SoulMageEntity pPlayer, class_243 piecePos, class_243 lookVec, boolean isFirstPiece) {
        if (isFirstPiece) {
            MagicRayCircleProjectile circle = (MagicRayCircleProjectile)CompanionsEntities.MAGIC_RAY_PIECE_CIRCLE_PROJECTILE.method_5883(pLevel);
            if (circle != null) {
                circle.method_5814(piecePos.field_1352, piecePos.field_1351, piecePos.field_1350);
                circle.method_7432((class_1297)pPlayer);
                this.rotateProjectile(circle, lookVec);
                pLevel.method_8649((class_1297)circle);
            }
        } else {
            MagicRayPieceProjectile ray = (MagicRayPieceProjectile)CompanionsEntities.MAGIC_RAY_PIECE_PROJECTILE.method_5883(pLevel);
            if (ray != null) {
                ray.method_5814(piecePos.field_1352, piecePos.field_1351, piecePos.field_1350);
                this.rotateProjectile(ray, lookVec);
                ray.method_7432((class_1297)pPlayer);
                if (pLevel instanceof class_3218) {
                    class_3218 level = (class_3218)pLevel;
                    TickScheduler.scheduleServer((class_1937)level, () -> pLevel.method_8649((class_1297)ray), (int)3);
                }
            }
        }
    }

    private void rotateProjectile(MagicRayPieceProjectile projectile, class_243 direction) {
        projectile.setPitch((float)(-Math.atan2(direction.field_1351, Math.sqrt(direction.field_1352 * direction.field_1352 + direction.field_1350 * direction.field_1350)) * 57.29577951308232));
        projectile.setYaw((float)(Math.atan2(direction.field_1350, direction.field_1352) * 57.29577951308232) - 90.0f);
    }

    @Override
    protected boolean hasRequiredBook() {
        for (int i = 0; i < this.soulMage.inventory.method_5439(); ++i) {
            class_1799 stack = this.soulMage.inventory.method_5438(i);
            if (stack.method_7909() != CompanionsItems.BOOK_MAGIC_RAY.get()) continue;
            return true;
        }
        return false;
    }
}

