/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.hostile;

import dev.xylonity.companions.common.ai.navigator.GroundNavigator;
import dev.xylonity.companions.common.entity.hostile.BrokenDinamoEntity;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1379;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1439;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3763;
import net.minecraft.class_3988;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class IllagerGolemEntity
extends class_3763
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public List<class_1297> visibleEntities = new ArrayList<class_1297>();
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation WALK = RawAnimation.begin().thenPlay("roll");
    private final RawAnimation SHOOT = RawAnimation.begin().thenPlay("shoot");
    private static final class_2940<Boolean> ACTIVE = class_2945.method_12791(IllagerGolemEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> ANIMATION_START_TICK = class_2945.method_12791(IllagerGolemEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> TICKCOUNT = class_2945.method_12791(IllagerGolemEntity.class, (class_2941)class_2943.field_13327);
    public static final class_2940<Integer> TEST_TIMER = class_2945.method_12791(IllagerGolemEntity.class, (class_2941)class_2943.field_13327);
    private static final int TIME_PER_ACTIVATION = 60;
    public static final int ELECTRICAL_CHARGE_DURATION = 8;

    public IllagerGolemEntity(class_1299<? extends class_3763> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
        this.field_5985 = true;
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 pLevel) {
        return new GroundNavigator((class_1308)this, pLevel);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(8, (class_1352)new class_1379((class_1314)this, 0.6));
        this.field_6201.method_6277(9, (class_1352)new class_1361((class_1308)this, class_1657.class, 15.0f, 0.01f));
        this.field_6201.method_6277(10, (class_1352)new class_1361((class_1308)this, class_1308.class, 15.0f));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[]{class_3763.class}).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_3988.class, false));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1439.class, true));
    }

    public static class_5132.class_5133 setAttributes() {
        return class_3763.method_26828().method_26868(class_5134.field_23716, 40.0).method_26868(class_5134.field_23721, 5.0).method_26868(class_5134.field_23723, 1.0).method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23717, 35.0);
    }

    public void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("TickCount", this.getTickCount());
        tag.method_10569("AnimationStartTick", this.getAnimationStartTick());
    }

    public void method_5651(@NotNull class_2487 tag) {
        super.method_5651(tag);
        this.setAnimationStartTick(tag.method_10550("TickCount"));
        this.setAnimationStartTick(tag.method_10550("AnimationStartTick"));
    }

    public void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10545("TickCount")) {
            this.setTickCount(tag.method_10550("TickCount"));
        } else {
            this.setTickCount(0);
        }
        if (tag.method_10545("AnimationStartTick")) {
            this.setAnimationStartTick(tag.method_10550("AnimationStartTick"));
        } else {
            this.setAnimationStartTick(0);
        }
    }

    public int getAnimationStartTick() {
        return (Integer)this.field_6011.method_12789(TEST_TIMER);
    }

    public void setAnimationStartTick(int tick) {
        this.field_6011.method_12778(TEST_TIMER, (Object)tick);
    }

    public int getTickCount() {
        return (Integer)this.field_6011.method_12789(TICKCOUNT);
    }

    public void setTickCount(int tick) {
        this.field_6011.method_12778(TICKCOUNT, (Object)tick);
    }

    public void method_16484(int i, boolean b) {
    }

    @NotNull
    public class_3414 method_20033() {
        return class_3417.field_19150;
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            this.setTickCount(this.field_6012);
        }
        if (this.getTickCount() % 60 == 0) {
            this.setActive(true);
        }
        if (this.isActive() && this.getTickCount() % 60 >= 8) {
            this.setActive(false);
            this.visibleEntities.clear();
        }
        if (!this.method_5805()) {
            this.setActive(false);
        }
        if (this.isActive()) {
            this.searchAndAttack();
        }
    }

    protected void method_6108() {
        ++this.field_6213;
        if (this.field_6213 >= 20 && !this.method_37908().method_8608() && !this.method_31481()) {
            this.method_37908().method_8421((class_1297)this, (byte)60);
            BrokenDinamoEntity dinamo = (BrokenDinamoEntity)CompanionsEntities.BROKEN_DINAMO.method_5883(this.method_37908());
            if (dinamo != null && this.method_37908().field_9229.method_43057() < 0.15f && !this.method_37908().field_9236) {
                dinamo.method_29495(this.method_19538());
                dinamo.setLifetime(new Random().nextInt(6000, 10000));
                this.method_37908().method_8649((class_1297)dinamo);
            }
            this.method_5650(class_1297.class_5529.field_26998);
        }
    }

    private void searchAndAttack() {
        this.visibleEntities = this.method_37908().method_8333((class_1297)this, this.method_5829().method_1014(10.0), entity -> {
            if (entity instanceof class_1588) {
                return false;
            }
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                return !player.method_7337() && !player.method_7325();
            }
            return entity instanceof class_1309;
        }).stream().filter(arg_0 -> ((IllagerGolemEntity)this).method_6057(arg_0)).collect(Collectors.toList());
        if (!this.visibleEntities.isEmpty()) {
            if (this.method_37908().method_8608()) {
                double radius = 0.42;
                for (int i = 0; i < 360; i += 120) {
                    double rad = Math.toRadians(i);
                    double particleX = this.method_19538().field_1352 + radius * Math.cos(rad);
                    double particleZ = this.method_19538().field_1350 + radius * Math.sin(rad);
                    this.method_37908().method_8406((class_2394)CompanionsParticles.ILLAGER_GOLEM_SPARK.get(), particleX, this.method_19538().method_10214() + (double)this.method_17682() - 0.6, particleZ, 0.0, 0.35, 0.0);
                }
            }
            int elapsed = this.getTickCount() - this.getAnimationStartTick();
            if (!this.method_37908().field_9236 && elapsed >= 3 && elapsed < 8) {
                for (class_1297 entity2 : this.visibleEntities) {
                    class_1309 e;
                    if (!(entity2 instanceof class_1309) || Util.areEntitiesLinked((class_1297)this, (class_1297)(e = (class_1309)entity2))) continue;
                    this.method_6121((class_1297)e);
                }
            }
        }
    }

    public void setActive(boolean active) {
        if (active && !this.isActive()) {
            this.setAnimationStartTick(this.getTickCount());
        }
        this.field_6011.method_12778(ACTIVE, (Object)active);
    }

    public boolean isActive() {
        return (Boolean)this.field_6011.method_12789(ACTIVE);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ACTIVE, (Object)false);
        this.field_6011.method_12784(ANIMATION_START_TICK, (Object)0);
        this.field_6011.method_12784(TEST_TIMER, (Object)0);
        this.field_6011.method_12784(TICKCOUNT, (Object)0);
    }

    protected void method_5712(@NotNull class_2338 pPos, @NotNull class_2680 pState) {
        super.method_5712(pPos, pState);
        this.method_5783(CompanionsSounds.DINAMO_STEP.get(), 0.07875f, 1.0f);
    }

    @Nullable
    protected class_3414 method_5994() {
        return CompanionsSounds.DINAMO_IDLE.get();
    }

    protected void method_6013(@NotNull class_1282 pSource) {
        this.method_5783(CompanionsSounds.DINAMO_HURT.get(), 0.25f, 1.0f);
    }

    @Nullable
    protected class_3414 method_6002() {
        return CompanionsSounds.DINAMO_DEATH.get();
    }

    public int method_5970() {
        return 320;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackcontroller", 1, this::attackPredicate)});
    }

    private <T extends GeoAnimatable> PlayState attackPredicate(AnimationState<T> event) {
        if (event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED) && this.isActive() && !this.visibleEntities.isEmpty()) {
            event.getController().forceAnimationReset();
            event.getController().setAnimation(this.SHOOT);
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(this.WALK);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

