/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.entity.projectile;

import dev.xylonity.companions.common.entity.companion.SoulMageEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SoulMageBookEntity
extends class_1676
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation OPEN = RawAnimation.begin().thenPlay("open");
    private final RawAnimation DEAD = RawAnimation.begin().thenPlay("dead");
    private final RawAnimation SUMMON = RawAnimation.begin().thenPlay("summon");
    private static final class_2940<Integer> TARGET_RED = class_2945.method_12791(SoulMageBookEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> TARGET_GREEN = class_2945.method_12791(SoulMageBookEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> TARGET_BLUE = class_2945.method_12791(SoulMageBookEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> CURRENT_RED = class_2945.method_12791(SoulMageBookEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> CURRENT_GREEN = class_2945.method_12791(SoulMageBookEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> CURRENT_BLUE = class_2945.method_12791(SoulMageBookEntity.class, (class_2941)class_2943.field_13320);

    public SoulMageBookEntity(class_1299<? extends class_1676> pEntityType, class_1937 pLevel) {
        super(pEntityType, pLevel);
        this.field_5960 = true;
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_24921() == null || this.method_24921().method_31481()) {
            this.method_5650(class_1297.class_5529.field_26999);
        }
        if (!this.method_37908().field_9236) {
            this.updateTargetColor();
            this.updateCurrentColor();
        }
        if (this.method_24921() != null) {
            this.orbit(this.method_24921());
        }
    }

    protected void method_5693() {
        this.field_6011.method_12784(TARGET_RED, (Object)255);
        this.field_6011.method_12784(TARGET_GREEN, (Object)255);
        this.field_6011.method_12784(TARGET_BLUE, (Object)255);
        this.field_6011.method_12784(CURRENT_RED, (Object)Float.valueOf(255.0f));
        this.field_6011.method_12784(CURRENT_GREEN, (Object)Float.valueOf(255.0f));
        this.field_6011.method_12784(CURRENT_BLUE, (Object)Float.valueOf(255.0f));
    }

    public float getCurrentRed() {
        return ((Float)this.field_6011.method_12789(CURRENT_RED)).floatValue();
    }

    public float getCurrentGreen() {
        return ((Float)this.field_6011.method_12789(CURRENT_GREEN)).floatValue();
    }

    public float getCurrentBlue() {
        return ((Float)this.field_6011.method_12789(CURRENT_BLUE)).floatValue();
    }

    public void updateTargetColor() {
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof SoulMageEntity) {
            SoulMageEntity soulMageEntity = (SoulMageEntity)class_12972;
            int[] color = SoulMageEntity.ATTACK_COLORS.getOrDefault(soulMageEntity.getCurrentAttackType(), SoulMageEntity.ATTACK_COLORS.get("NONE"));
            this.field_6011.method_12778(TARGET_RED, (Object)color[0]);
            this.field_6011.method_12778(TARGET_GREEN, (Object)color[1]);
            this.field_6011.method_12778(TARGET_BLUE, (Object)color[2]);
        } else {
            this.field_6011.method_12778(TARGET_RED, (Object)255);
            this.field_6011.method_12778(TARGET_GREEN, (Object)255);
            this.field_6011.method_12778(TARGET_BLUE, (Object)255);
        }
    }

    public void updateCurrentColor() {
        float curR = ((Float)this.field_6011.method_12789(CURRENT_RED)).floatValue();
        float curG = ((Float)this.field_6011.method_12789(CURRENT_GREEN)).floatValue();
        float curB = ((Float)this.field_6011.method_12789(CURRENT_BLUE)).floatValue();
        int targetR = (Integer)this.field_6011.method_12789(TARGET_RED);
        int targetG = (Integer)this.field_6011.method_12789(TARGET_GREEN);
        int targetB = (Integer)this.field_6011.method_12789(TARGET_BLUE);
        curR = this.lerp(curR, targetR);
        curG = this.lerp(curG, targetG);
        curB = this.lerp(curB, targetB);
        this.field_6011.method_12778(CURRENT_RED, (Object)Float.valueOf(curR));
        this.field_6011.method_12778(CURRENT_GREEN, (Object)Float.valueOf(curG));
        this.field_6011.method_12778(CURRENT_BLUE, (Object)Float.valueOf(curB));
    }

    private float lerp(float start, float target) {
        return start + 0.1f * (target - start);
    }

    private void orbit(class_1297 owner) {
        double angle = 0.05 * (double)this.method_37908().method_8510();
        double radius = 2.0;
        class_243 orbitOffset = new class_243(radius * Math.cos(angle), 0.0, radius * Math.sin(angle));
        class_243 targetPos = new class_243(owner.method_23317(), owner.method_23318(), owner.method_23321()).method_1031(0.0, (double)owner.method_17682(), 0.0).method_1019(orbitOffset);
        class_243 vel = this.method_18798();
        double K = 0.006;
        class_243 accel = targetPos.method_1020(this.method_19538()).method_1021(K).method_1020(vel.method_1021(2.0 * Math.sqrt(K)));
        vel = vel.method_1019(accel);
        this.method_18799(vel);
        this.method_5784(class_1313.field_6308, vel);
    }

    protected void method_5652(@NotNull class_2487 pCompound) {
        super.method_5652(pCompound);
        pCompound.method_10569("TargetRed", ((Integer)this.field_6011.method_12789(TARGET_RED)).intValue());
        pCompound.method_10569("TargetGreen", ((Integer)this.field_6011.method_12789(TARGET_GREEN)).intValue());
        pCompound.method_10569("TargetBlue", ((Integer)this.field_6011.method_12789(TARGET_BLUE)).intValue());
        pCompound.method_10548("CurrentRed", ((Float)this.field_6011.method_12789(CURRENT_RED)).floatValue());
        pCompound.method_10548("CurrentGreen", ((Float)this.field_6011.method_12789(CURRENT_GREEN)).floatValue());
        pCompound.method_10548("CurrentBlue", ((Float)this.field_6011.method_12789(CURRENT_BLUE)).floatValue());
    }

    protected void method_5749(@NotNull class_2487 pCompound) {
        super.method_5749(pCompound);
        if (pCompound.method_10545("TargetRed")) {
            this.field_6011.method_12778(TARGET_RED, (Object)pCompound.method_10550("TargetRed"));
            this.field_6011.method_12778(TARGET_GREEN, (Object)pCompound.method_10550("TargetGreen"));
            this.field_6011.method_12778(TARGET_BLUE, (Object)pCompound.method_10550("TargetBlue"));
        }
        if (pCompound.method_10545("CurrentRed")) {
            this.field_6011.method_12778(CURRENT_RED, (Object)Float.valueOf(pCompound.method_10583("CurrentRed")));
            this.field_6011.method_12778(CURRENT_GREEN, (Object)Float.valueOf(pCompound.method_10583("CurrentGreen")));
            this.field_6011.method_12778(CURRENT_BLUE, (Object)Float.valueOf(pCompound.method_10583("CurrentBlue")));
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "controller", this::predicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attackController", 1, this::attackPredicate)});
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "sizeController", 1, this::sizePredicate)});
    }

    private <T extends GeoAnimatable> PlayState attackPredicate(AnimationState<T> event) {
        SoulMageEntity mage;
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof SoulMageEntity && (mage = (SoulMageEntity)class_12972).isAttacking() && event.getController().getAnimationState().equals((Object)AnimationController.State.STOPPED)) {
            event.getController().setAnimation(this.OPEN);
            event.getController().forceAnimationReset();
        }
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        event.getController().setAnimation(this.IDLE);
        return PlayState.CONTINUE;
    }

    private <T extends GeoAnimatable> PlayState sizePredicate(AnimationState<T> event) {
        class_1297 class_12972 = this.method_24921();
        if (class_12972 instanceof SoulMageEntity) {
            SoulMageEntity mage = (SoulMageEntity)class_12972;
            if (mage.method_29504()) {
                event.getController().setAnimation(this.DEAD);
            } else if (this.field_6012 < 20) {
                event.getController().setAnimation(this.SUMMON);
            }
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

