/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.item;

import dev.xylonity.companions.common.blockentity.AbstractShadeAltarBlockEntity;
import dev.xylonity.companions.common.entity.ShadeEntity;
import dev.xylonity.companions.common.event.CompanionsEntityTracker;
import dev.xylonity.companions.common.item.TooltipItem;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class ShadowBellItem
extends TooltipItem {
    private static final String ST_DIM = "stored_dim";
    private static final String ST_X = "stored_x";
    private static final String ST_Y = "stored_y";
    private static final String ST_Z = "stored_z";
    private static final String BELL_CURR = "bell_curr";
    private static final String BELL_MAX = "bell_max";
    private static final String UUID_SHADE = "cached_shade";
    private static final String ALTAR_NAME = "altar_name";

    public ShadowBellItem(class_1792.class_1793 properties) {
        super(properties);
    }

    public boolean method_31567(class_1799 stack) {
        class_2487 t = stack.method_7969();
        return t != null && t.method_10545(BELL_CURR) && t.method_10545(BELL_MAX);
    }

    public int method_31569(@NotNull class_1799 stack) {
        class_2487 t = stack.method_7969();
        int curr = t != null ? t.method_10550(BELL_CURR) : 0;
        int max = t != null ? t.method_10550(BELL_MAX) : 1;
        return Math.round((float)curr * 13.0f / (float)max);
    }

    public int method_31571(@NotNull class_1799 stack) {
        return 0xAA0077;
    }

    public void method_7888(@NotNull class_1799 pStack, @NotNull class_1937 pLevel, @NotNull class_1297 pEntity, int pSlotId, boolean pIsSelected) {
        String currName;
        class_2586 class_25862;
        class_3218 maybe;
        if (!(pEntity instanceof class_1657)) {
            return;
        }
        if (pLevel.field_9236) {
            return;
        }
        class_2487 tag = pStack.method_7969();
        if (tag == null || !tag.method_10545(ST_DIM)) {
            return;
        }
        class_3218 altarLevel = null;
        if (pLevel.method_8503() != null && (maybe = pLevel.method_8503().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(tag.method_10558(ST_DIM))))) instanceof class_3218) {
            altarLevel = maybe;
        }
        class_2338 pos = new class_2338(tag.method_10550(ST_X), tag.method_10550(ST_Y), tag.method_10550(ST_Z));
        if (altarLevel == null || !((class_25862 = altarLevel.method_8321(pos)) instanceof AbstractShadeAltarBlockEntity)) {
            this.clearLink(pStack);
            return;
        }
        AbstractShadeAltarBlockEntity altar = (AbstractShadeAltarBlockEntity)class_25862;
        if (altar.getCharges() <= 0) {
            return;
        }
        if (tag.method_10550(BELL_CURR) != altar.getCharges() || tag.method_10550(BELL_MAX) != altar.getMaxCharges()) {
            tag.method_10569(BELL_CURR, altar.getCharges());
            tag.method_10569(BELL_MAX, altar.getMaxCharges());
            pStack.method_7980(tag);
        }
        if (!(currName = altarLevel.method_8320(pos).method_26204().method_9518().getString()).equals(tag.method_10558(ALTAR_NAME))) {
            tag.method_10582(ALTAR_NAME, currName);
            pStack.method_7980(tag);
        }
    }

    @Override
    public void method_7851(@NotNull class_1799 stack, class_1937 level, @NotNull List<class_2561> tooltip, @NotNull class_1836 flag) {
        class_2487 t = stack.method_7969();
        if (!(t != null && t.method_10545(ST_DIM) && t.method_10545(ST_X) && t.method_10545(ST_Y) && t.method_10545(ST_Z))) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.item.companions.shadow_bell.default").method_27695(new class_124[]{class_124.field_1063, class_124.field_1056}));
            return;
        }
        if (t.method_10545(BELL_CURR) && t.method_10545(ALTAR_NAME)) {
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.item.companions.shadow_bell.linked_to", (Object[])new Object[]{t.method_10558(ALTAR_NAME)}));
            tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.item.companions.shadow_bell.charges_remaining", (Object[])new Object[]{t.method_10550(BELL_CURR)}));
            if (t.method_25928(UUID_SHADE)) {
                class_1297 e = CompanionsEntityTracker.getEntityByUUID(t.method_25926(UUID_SHADE));
                if (e instanceof ShadeEntity) {
                    ShadeEntity shade = (ShadeEntity)e;
                    tooltip.add((class_2561)class_2561.method_43469((String)"tooltip.item.companions.shadow_bell.lifetime", (Object[])new Object[]{shade.getLifetime() / 20}));
                } else {
                    t.method_10551(UUID_SHADE);
                    stack.method_7980(t);
                }
            }
        }
    }

    @Override
    protected String tooltipName() {
        return "";
    }

    @NotNull
    public class_1269 method_7884(class_1838 ctx) {
        class_1937 level = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        class_1799 stack = ctx.method_8041();
        if (level.field_9236) {
            return class_1269.field_5812;
        }
        class_2586 class_25862 = level.method_8321(pos);
        if (!(class_25862 instanceof AbstractShadeAltarBlockEntity)) {
            if (ctx.method_8036() != null) {
                return this.method_7836(level, ctx.method_8036(), ctx.method_20287()).method_5467();
            }
            return class_1269.field_5811;
        }
        AbstractShadeAltarBlockEntity altar = (AbstractShadeAltarBlockEntity)class_25862;
        if (altar.getCharges() <= 0 && ctx.method_8036() != null) {
            ctx.method_8036().method_7353((class_2561)class_2561.method_43471((String)"shadow_bell.companions.client_message.altar_empty"), true);
        }
        class_2487 tag = stack.method_7948();
        tag.method_10582(ST_DIM, level.method_27983().method_29177().toString());
        tag.method_10569(ST_X, pos.method_10263());
        tag.method_10569(ST_Y, pos.method_10264());
        tag.method_10569(ST_Z, pos.method_10260());
        tag.method_10569(BELL_CURR, altar.getCharges());
        tag.method_10569(BELL_MAX, altar.getMaxCharges());
        tag.method_10582(ALTAR_NAME, level.method_8320(pos).method_26204().method_9518().getString());
        stack.method_7980(tag);
        if (ctx.method_8036() != null) {
            ctx.method_8036().method_7353((class_2561)class_2561.method_43471((String)"shadow_bell.companions.client_message.altar_saved"), true);
        }
        return class_1269.field_5812;
    }

    @NotNull
    public class_1269 method_7847(@NotNull class_1799 pStack, @NotNull class_1657 pPlayer, @NotNull class_1309 pInteractionTarget, @NotNull class_1268 pUsedHand) {
        ShadeEntity shade;
        class_2487 tag = pStack.method_7969();
        if (tag != null && pInteractionTarget instanceof ShadeEntity && (shade = (ShadeEntity)pInteractionTarget).method_6139() != null && shade.method_6139().equals(pPlayer.method_5667())) {
            pInteractionTarget.method_31472();
            if (tag.method_25928(UUID_SHADE) && pInteractionTarget.method_5667().equals(tag.method_25926(UUID_SHADE)) && pInteractionTarget instanceof ShadeEntity) {
                tag.method_10551(UUID_SHADE);
                pStack.method_7980(tag);
            }
            return class_1269.field_5812;
        }
        return super.method_7847(pStack, pPlayer, pInteractionTarget, pUsedHand);
    }

    @NotNull
    public class_1271<class_1799> method_7836(@NotNull class_1937 pLevel, @NotNull class_1657 pPlayer, @NotNull class_1268 pUsedHand) {
        class_1799 stack = pPlayer.method_5998(pUsedHand);
        class_2487 tag = stack.method_7969();
        if (pLevel.field_9236) {
            return class_1271.method_22427((Object)stack);
        }
        if (!(tag != null && tag.method_10545(ST_DIM) && tag.method_10545(ST_X) && tag.method_10545(ST_Y) && tag.method_10545(ST_Z) && pLevel.method_8503() != null)) {
            return class_1271.method_22430((Object)stack);
        }
        class_3218 world = pLevel.method_8503().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(tag.method_10558(ST_DIM))));
        if (world == null) {
            pPlayer.method_7353((class_2561)class_2561.method_43471((String)"shadow_bell.companions.client_message.couldnt_find"), true);
            this.clearLink(stack);
            return class_1271.method_22430((Object)stack);
        }
        class_2586 class_25862 = world.method_8321(new class_2338(tag.method_10550(ST_X), tag.method_10550(ST_Y), tag.method_10550(ST_Z)));
        if (class_25862 instanceof AbstractShadeAltarBlockEntity) {
            ShadeEntity entity;
            AbstractShadeAltarBlockEntity altar = (AbstractShadeAltarBlockEntity)class_25862;
            if (altar.getCharges() <= 0) {
                pPlayer.method_7353((class_2561)class_2561.method_43471((String)"shadow_bell.companions.client_message.no_charges"), true);
                return class_1271.method_22430((Object)stack);
            }
            UUID oldShadeUUID = altar.activeShadeUUID;
            if (oldShadeUUID != null) {
                class_1297 oldShade = world.method_14190(oldShadeUUID);
                if (oldShade instanceof ShadeEntity) {
                    oldShade.method_31472();
                }
                altar.activeShadeUUID = null;
            }
            if ((entity = altar.spawnShade(pPlayer.method_37908(), pPlayer, pUsedHand, this)) != null) {
                tag.method_25927(UUID_SHADE, entity.method_5667());
                stack.method_7980(tag);
            }
            if (altar.consumeCharge()) {
                altar.sync();
                tag.method_10569(BELL_CURR, altar.getCharges());
                stack.method_7980(tag);
            } else {
                pPlayer.method_7353((class_2561)class_2561.method_43471((String)"shadow_bell.companions.client_message.no_charges"), true);
                this.clearLink(stack);
            }
            pPlayer.method_37908().method_8396(null, pPlayer.method_24515(), CompanionsSounds.SHADE_BELL_SUMMON.get(), pPlayer.method_5634(), 0.3f, 1.0f);
        } else {
            this.clearLink(stack);
            pPlayer.method_7353((class_2561)class_2561.method_43471((String)"shadow_bell.companions.client_message.couldnt_find"), true);
        }
        return class_1271.method_29237((Object)stack, (boolean)false);
    }

    private void clearLink(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return;
        }
        tag.method_10551(ST_DIM);
        tag.method_10551(ST_X);
        tag.method_10551(ST_Y);
        tag.method_10551(ST_Z);
        tag.method_10551(BELL_CURR);
        tag.method_10551(BELL_MAX);
        tag.method_10551(UUID_SHADE);
        tag.method_10551(ALTAR_NAME);
        stack.method_7980(tag);
    }
}

