/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client;

import dev.xylonity.companions.common.blockentity.AbstractShadeAltarBlockEntity;
import dev.xylonity.companions.common.blockentity.AbstractTeslaBlockEntity;
import dev.xylonity.companions.common.entity.companion.ShadeMawEntity;
import dev.xylonity.companions.common.entity.projectile.trigger.LaserTriggerProjectile;
import dev.xylonity.companions.common.particle.BaseRibbonTrailParticle;
import dev.xylonity.companions.common.particle.CakeCreamParticle;
import dev.xylonity.companions.common.particle.ElectricArcParticle;
import dev.xylonity.companions.common.particle.GenericRibbonTrailParticle;
import dev.xylonity.companions.common.particle.GoldenAllayRibbonTrailParticle;
import dev.xylonity.companions.common.particle.RedElectricArcParticle;
import dev.xylonity.companions.common.particle.ShadeAltarRibbonParticle;
import dev.xylonity.companions.common.particle.SidedRibbonTrailParticle;
import dev.xylonity.companions.common.particle.SpiralLaserParticle;
import dev.xylonity.companions.proxy.IProxy;
import dev.xylonity.companions.registry.CompanionsParticles;
import dev.xylonity.knightlib.api.CameraShakeManager;
import java.util.Random;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ClientProxy
implements IProxy {
    @Override
    public void spawnElectricArc(Entity e, Entity target, Level level, float d) {
        if (target != null) {
            float distance = 1.0f + level.random.nextFloat() * d;
            float angle = (level.random.nextFloat() - 0.5f) * 60.0f;
            float finalAngle = e.getYRot() + angle;
            double radians = Math.toRadians(finalAngle);
            double offsetX = -Math.sin(radians) * (double)distance;
            double offsetZ = Math.cos(radians) * (double)distance;
            Vec3 start = new Vec3(e.position().x, e.position().y + (double)(e.getBbHeight() * 0.5f), e.position().z);
            Vec3 end = new Vec3(e.position().x + offsetX, (double)e.blockPosition().getY(), e.position().z + offsetZ);
            Minecraft.getInstance().particleEngine.add((Particle)new RedElectricArcParticle((ClientLevel)level, start, end, 0.6, 0.35, true, 8));
        }
    }

    @Override
    public void spawnBaseProjectileTrail(Entity entity, float radius, float height, float r, float g, float b) {
        Level level = entity.level();
        if (!(level instanceof ClientLevel)) {
            return;
        }
        ClientLevel level2 = (ClientLevel)level;
        double x = entity.getX() + (level2.random.nextDouble() - 0.5) * (double)entity.getBbWidth();
        double y = entity.getY() + (double)entity.getBbHeight() * level2.random.nextDouble();
        double z = entity.getZ() + (level2.random.nextDouble() - 0.5) * (double)entity.getBbWidth();
        Minecraft.getInstance().particleEngine.add((Particle)new BaseRibbonTrailParticle(level2, x, y, z, r, g, b, radius, height, entity.getId()));
    }

    @Override
    public void shakePlayerCamera(Player player, int durationTicks, float intensityX, float intensityY, float intensityZ, int fadeStartTick) {
        CameraShakeManager.shake((Player)player, (int)durationTicks, (float)intensityX, (float)intensityY, (float)intensityZ, (int)fadeStartTick);
    }

    @Override
    public void spawnGenericRibbonTrail(Entity e, Level level, double x, double y, double z, float r, float g, float b, float radius, float height) {
        Minecraft.getInstance().particleEngine.add((Particle)new GenericRibbonTrailParticle((ClientLevel)level, x, y, z, r, g, b, radius, height, e.getId()));
    }

    @Override
    public void spawnGoldenAllayRibbonTrail(Entity e, Level level, double x, double y, double z, float r, float g, float b, float radius, float height) {
        Minecraft.getInstance().particleEngine.add((Particle)new GoldenAllayRibbonTrailParticle((ClientLevel)level, x, y, z, r, g, b, radius, height, e.getId()));
    }

    @Override
    public void spawnSidedRibbonTrail(Entity e, Level level, double x, double y, double z, float r, float g, float b, float radius, float height, int side) {
        Minecraft.getInstance().particleEngine.add((Particle)new SidedRibbonTrailParticle((ClientLevel)level, x, y, z, r, g, b, radius, height, e.getId(), side));
    }

    @Override
    public void spawnShadeAltarParticles(AbstractShadeAltarBlockEntity e, Level level, float r, float g, float b, double radius) {
        Minecraft.getInstance().particleEngine.add((Particle)new ShadeAltarRibbonParticle((ClientLevel)level, e.getBlockPos().getCenter(), r, g, b, radius));
    }

    @Override
    public void spawnPlasmaLampElectricArc(AbstractTeslaBlockEntity e, Level level, BlockPos blockPos) {
        double radius1 = 0.42;
        double y = (double)e.getBlockPos().getY() + 0.5;
        for (int i = 0; i < 360; i += 40) {
            double angleRadians = Math.toRadians(i);
            double x = e.getBlockPos().getCenter().add((Vec3)e.electricalChargeOriginOffset()).x + radius1 * Math.cos(angleRadians);
            double z = e.getBlockPos().getCenter().add((Vec3)e.electricalChargeOriginOffset()).z + radius1 * Math.sin(angleRadians);
            level.addParticle((ParticleOptions)CompanionsParticles.DINAMO_SPARK.get(), x, y + level.random.nextDouble() * 0.7, z, 0.0, 0.35, 0.0);
        }
        double dd = (level.random.nextDouble() * 2.0 - 1.0) * 2.5;
        Vec3 start = new Vec3((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5).add(e.electricalChargeOriginOffset());
        Vec3 end = new Vec3((double)(blockPos.getX() + Mth.floor((double)dd)) + 0.5, (double)blockPos.getY(), (double)(blockPos.getZ() + Mth.floor((double)dd)) + 0.5);
        Minecraft.getInstance().particleEngine.add((Particle)new ElectricArcParticle((ClientLevel)level, start, end, Math.hypot(start.x - end.x, start.z - end.z) * 0.6, 0.35));
    }

    @Override
    public void tickLaserTriggerProjectile(LaserTriggerProjectile laser) {
        Entity e;
        if (laser.target == null && (e = laser.level().getEntity(laser.getTargetId())) instanceof LivingEntity) {
            laser.target = (LivingEntity)e;
        }
        if (laser.target != null) {
            Vec3 start = laser.position();
            Vec3 targetPos = laser.target.getEyePosition();
            ClipContext ctx = new ClipContext(start, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)laser);
            BlockHitResult hit = laser.level().clip(ctx);
            Vec3 end = hit.getType() == HitResult.Type.BLOCK && !laser.level().getBlockState(hit.getBlockPos()).getCollisionShape((BlockGetter)laser.level(), hit.getBlockPos()).isEmpty() ? hit.getLocation() : targetPos;
            ClientLevel cl = (ClientLevel)laser.level();
            if (laser.tickCount % 2 == 0) {
                Minecraft.getInstance().particleEngine.add((Particle)new RedElectricArcParticle(cl, start, end, 0.15f, 0.4f, false, 16));
            }
            if (laser.tickCount % 4 == 0 || laser.tickCount % 5 == 0) {
                Minecraft.getInstance().particleEngine.add((Particle)new SpiralLaserParticle(cl, start, end, 0.3f, 0.75));
            }
            Random random = new Random();
            if (random.nextFloat() < 0.2f) {
                this.spawnElectricArc((Entity)laser, (Entity)laser.target, laser.level(), (float)start.distanceTo(end));
            }
            Random random2 = new Random();
            if (random2.nextFloat() < 0.4f) {
                laser.spawnSparks(laser.level());
            }
        }
    }

    @Override
    public void spawnLaserRingElectricArc(Entity e, Level level, float distance) {
        float distStart = 1.0f + level.random.nextFloat() * distance;
        double radStart = Math.toRadians(level.random.nextFloat() * 360.0f);
        float distEnd = 1.0f + level.random.nextFloat() * distance;
        double radEnd = Math.toRadians(level.random.nextFloat() * 360.0f);
        Vec3 start = new Vec3(e.position().x + -Math.sin(radStart) * (double)distStart, e.position().y + (double)((level.random.nextFloat() - 0.5f) * 2.0f), e.position().z + Math.cos(radStart) * (double)distStart);
        Vec3 end = new Vec3(e.position().x + -Math.sin(radEnd) * (double)distEnd, e.position().y + (double)((level.random.nextFloat() - 0.5f) * 2.0f), e.position().z + Math.cos(radEnd) * (double)distEnd);
        Minecraft.getInstance().particleEngine.add((Particle)new RedElectricArcParticle((ClientLevel)level, start, end, 0.6, 0.35, true, 8));
    }

    @Override
    public void tickShadeMaw(ShadeMawEntity e) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.getVehicle() == e && Minecraft.getInstance().options.getCameraType() != CameraType.THIRD_PERSON_BACK) {
            Minecraft.getInstance().options.setCameraType(CameraType.THIRD_PERSON_BACK);
        }
    }

    @Override
    public void updateCreamParticle(Vec3 coordinates) {
        CakeCreamParticle.setDefaultVelocity(coordinates.x * 0.5, coordinates.y * 0.5, coordinates.z * 0.5);
    }
}

