/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.entity.model;

import dev.xylonity.companions.common.entity.hostile.BrokenDinamoEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.model.GeoModel;

public class BrokenDinamoModel
extends GeoModel<BrokenDinamoEntity> {
    public ResourceLocation getModelResource(BrokenDinamoEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"geo/broken_dinamo.geo.json");
    }

    public ResourceLocation getTextureResource(BrokenDinamoEntity animatable) {
        if (animatable.getState() >= 4) {
            return ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/entity/dinamo.png");
        }
        return ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/entity/illager_golem.png");
    }

    public void setCustomAnimations(BrokenDinamoEntity animatable, long instanceId, AnimationState<BrokenDinamoEntity> animationState) {
        Entity camera = Minecraft.getInstance().getCameraEntity();
        if (camera == null) {
            return;
        }
        float partialTick = animationState.getPartialTick();
        Vec3 cameraPos = camera.getEyePosition(partialTick);
        Vec3 entityPos = animatable.getEyePosition(partialTick);
        Vec3 diff = new Vec3(cameraPos.x - entityPos.x, 0.0, cameraPos.z - entityPos.z).normalize();
        Vec3 view = animatable.getState() == 0 ? animatable.getViewVector(partialTick).yRot((float)Math.toRadians(32.5)).normalize() : animatable.getViewVector(partialTick).normalize();
        view = new Vec3(view.x, 0.0, view.z).normalize();
        Vec3 lateral = new Vec3(-view.z, 0.0, view.x);
        float dot = (float)(diff.x * lateral.x + diff.z * lateral.z);
        dot = Mth.clamp((float)dot, (float)-1.0f, (float)1.0f);
        GeoBone leftEyeBone = this.getAnimationProcessor().getBone("left_eye");
        GeoBone rightEyeBone = this.getAnimationProcessor().getBone("right_eye");
        float baseLeftEyeX = -0.0f;
        float baseRightEyeX = 0.0f;
        if (leftEyeBone != null) {
            leftEyeBone.setPosX(baseLeftEyeX - dot);
        }
        if (rightEyeBone != null) {
            rightEyeBone.setPosX(baseRightEyeX - dot);
        }
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
    }

    public ResourceLocation getAnimationResource(BrokenDinamoEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"animations/illager_golem.animation.json");
    }
}

