/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.xylonity.companions.common.blockentity.SoulFurnaceBlockEntity;
import dev.xylonity.companions.common.container.SoulFurnaceContainerMenu;
import java.util.Random;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class SoulFurnaceScreen
extends AbstractContainerScreen<SoulFurnaceContainerMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/gui/soul_furnace_gui.png");
    private static final int FRAME_WIDTH = 10;
    private static final int FRAME_HEIGHT = 9;
    private static final int FRAME_COUNT = 6;
    private static final int FRAME_BASE_X = 176;
    private static final int FRAME_BASE_Y = 31;
    private static final int FRAME_Y_OFFSET = 9;
    private final int[] animationTicks;
    private final int animationSpeeds = 3;
    private final int[] animationOffsets;

    public SoulFurnaceScreen(SoulFurnaceContainerMenu container, Inventory inv, Component title) {
        super((AbstractContainerMenu)container, inv, title);
        this.imageWidth = 176;
        this.imageHeight = 179;
        int maxCharges = SoulFurnaceBlockEntity.getMaxCharges();
        this.animationTicks = new int[maxCharges];
        this.animationOffsets = new int[maxCharges];
        for (int i = 0; i < maxCharges; ++i) {
            this.animationOffsets[i] = new Random().nextInt(6);
        }
    }

    protected void containerTick() {
        super.containerTick();
        int i = 0;
        while (i < this.animationTicks.length) {
            int n = i++;
            this.animationTicks[n] = this.animationTicks[n] + 1;
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int relX = (this.width - this.imageWidth) / 2;
        int relY = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, relX, relY, 0, 0, this.imageWidth, this.imageHeight);
        if (((SoulFurnaceContainerMenu)this.menu).getProcessingTime() > 0) {
            int progressWidth = 24;
            int progressHeight = 17;
            int progress = (int)((float)((SoulFurnaceContainerMenu)this.menu).getProgress() / (float)((SoulFurnaceContainerMenu)this.menu).getProcessingTime() * (float)progressWidth);
            guiGraphics.blit(TEXTURE, relX + 79, relY + 40, 176, 14, progress, progressHeight);
        }
        int chargeCount = ((SoulFurnaceContainerMenu)this.menu).getCharge();
        for (int i = 0; i < chargeCount; ++i) {
            int drawY;
            int drawX;
            int currentFrame = (this.animationTicks[i] / 3 + this.animationOffsets[i]) % 6;
            int frameY = 31 + currentFrame * 9;
            if (i == 0) {
                drawX = relX + 9;
                drawY = relY + 61;
            } else if (i == SoulFurnaceBlockEntity.getMaxCharges() - 1) {
                drawX = relX + 157;
                drawY = relY + 61;
            } else {
                drawX = relX + 26 + (i - 1) * 19;
                drawY = relY + 69;
            }
            guiGraphics.blit(TEXTURE, drawX, drawY, 176, frameY, 10, 9);
        }
    }

    public void render(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(pGuiGraphics, pMouseX, pMouseY);
    }

    protected void renderLabels(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY + 2, 0x404040, false);
        pGuiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY + 14, 0x404040, false);
    }
}

