/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.projectile.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xylonity.companions.client.projectile.model.BloodSlashModel;
import dev.xylonity.companions.common.entity.projectile.BloodSlashProjectile;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class BloodSlashRenderer
extends GeoEntityRenderer<BloodSlashProjectile> {
    public BloodSlashRenderer(EntityRendererProvider.Context context) {
        super(context, (GeoModel)new BloodSlashModel());
    }

    protected void applyRotations(BloodSlashProjectile animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        Vec3 motion = animatable.getDeltaMovement();
        if (motion.lengthSqr() > 1.0E-6) {
            poseStack.mulPose(Axis.YP.rotationDegrees((float)(Mth.atan2((double)motion.x, (double)motion.z) * 57.2957763671875)));
            poseStack.mulPose(Axis.XP.rotationDegrees(-((float)(Mth.atan2((double)motion.y, (double)Mth.sqrt((float)((float)(motion.x * motion.x + motion.z * motion.z)))) * 57.2957763671875))));
        }
        super.applyRotations((Entity)animatable, poseStack, ageInTicks, rotationYaw, partialTick, nativeScale);
    }

    public void actuallyRender(PoseStack poseStack, BloodSlashProjectile animatable, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        poseStack.scale(1.75f, 1.75f, 1.75f);
        super.actuallyRender(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
    }

    public RenderType getRenderType(BloodSlashProjectile animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucentEmissive((ResourceLocation)this.getTextureLocation((Entity)animatable));
    }
}

