/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.projectile.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xylonity.companions.client.projectile.model.FireMarkModel;
import dev.xylonity.companions.common.entity.projectile.FireMarkProjectile;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class FireMarkRenderer
extends GeoEntityRenderer<FireMarkProjectile> {
    private static final float MAX_PITCH_ANGLE = 5.0f;

    public FireMarkRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new FireMarkModel());
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull FireMarkProjectile animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/entity/fire_mark.png");
    }

    public RenderType getRenderType(FireMarkProjectile animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(animatable));
    }

    public void actuallyRender(PoseStack poseStack, FireMarkProjectile animatable, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        if (camera != null) {
            float maxPitch;
            float pitchFactor;
            double horizontalDist;
            double dx = camera.getPosition().x - animatable.getX();
            double dz = camera.getPosition().z - animatable.getZ();
            if (Math.abs(dx) < 1.0E-4 && Math.abs(dz) < 1.0E-4) {
                dx = 0.0;
                dz = 1.0;
            }
            float desiredYaw = (float)Math.toDegrees(Math.atan2(dx, dz));
            float yawCorrection = 0.0f;
            desiredYaw += yawCorrection;
            double dy = camera.getPosition().y - animatable.getY();
            float rawPitch = (float)Math.toDegrees(Math.atan2(dy, horizontalDist = Math.sqrt(dx * dx + dz * dz)));
            float desiredPitch = rawPitch * (pitchFactor = 0.5f);
            if (desiredPitch > (maxPitch = 5.0f)) {
                desiredPitch = maxPitch;
            }
            if (desiredPitch < -maxPitch) {
                desiredPitch = -maxPitch;
            }
            poseStack.mulPose(Axis.YP.rotationDegrees(desiredYaw));
            poseStack.mulPose(Axis.XP.rotationDegrees(desiredPitch));
        }
        super.actuallyRender(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
    }
}

