/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.projectile.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xylonity.companions.client.projectile.model.MagicRayPieceModel;
import dev.xylonity.companions.common.entity.projectile.MagicRayPieceProjectile;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public class MagicRayPieceRenderer
extends GeoEntityRenderer<MagicRayPieceProjectile> {
    public MagicRayPieceRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new MagicRayPieceModel());
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull MagicRayPieceProjectile animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/entity/magic_ray_piece.png");
    }

    public RenderType getRenderType(MagicRayPieceProjectile animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucentEmissive((ResourceLocation)this.getTextureLocation(animatable));
    }

    public void actuallyRender(PoseStack poseStack, MagicRayPieceProjectile animatable, BakedGeoModel model, @Nullable RenderType renderType, MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        poseStack.pushPose();
        super.actuallyRender(poseStack, (Entity)animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
        poseStack.popPose();
    }

    protected void applyRotations(MagicRayPieceProjectile animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        super.applyRotations((Entity)animatable, poseStack, ageInTicks, rotationYaw, partialTick, nativeScale);
        float yaw = Mth.rotLerp((float)partialTick, (float)animatable.getYaw(), (float)animatable.getYaw());
        float pitch = Mth.lerp((float)partialTick, (float)animatable.getPitch(), (float)animatable.getPitch());
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
    }
}

