/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.client.projectile.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.xylonity.companions.client.projectile.model.SoulMageBookModel;
import dev.xylonity.companions.common.entity.projectile.SoulMageBookEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class SoulMageBookRenderer
extends GeoEntityRenderer<SoulMageBookEntity> {
    public SoulMageBookRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new SoulMageBookModel());
        this.addRenderLayer(new SoulMageBookGlowLayer((GeoRenderer<SoulMageBookEntity>)this));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull SoulMageBookEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/entity/soul_mage_book.png");
    }

    static class SoulMageBookGlowLayer
    extends GeoRenderLayer<SoulMageBookEntity> {
        private static final ResourceLocation EMB_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"companions", (String)"textures/entity/soul_mage_book_glow.png");

        public SoulMageBookGlowLayer(GeoRenderer<SoulMageBookEntity> entityRenderer) {
            super(entityRenderer);
        }

        public void render(PoseStack poseStack, SoulMageBookEntity entity, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            RenderType glowRenderType = RenderType.entityTranslucent((ResourceLocation)EMB_TEXTURE);
            int red = (int)entity.getCurrentRed();
            int green = (int)entity.getCurrentGreen();
            int blue = (int)entity.getCurrentBlue();
            int alpha = 255;
            int colour = alpha << 24 | red << 16 | green << 8 | blue;
            VertexConsumer glowBuffer = bufferSource.getBuffer(glowRenderType);
            this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)entity, glowRenderType, glowBuffer, partialTick, packedLight, OverlayTexture.NO_OVERLAY, colour);
        }
    }
}

