/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.ai.navigator;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import dev.xylonity.companions.common.ai.navigator.BonusPathFinder;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.FlyNodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class FlyingNavigator
extends FlyingPathNavigation {
    private static final float THETA = 1.0E-8f;
    private final Cache<BlockPos, Boolean> cache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(5L, TimeUnit.SECONDS).build();

    public FlyingNavigator(Mob entity, Level world) {
        super(entity, world);
    }

    @NotNull
    protected PathFinder createPathFinder(int maxVisitedNodes) {
        this.nodeEvaluator = new FlyNodeEvaluator();
        this.nodeEvaluator.setCanPassDoors(true);
        return new BonusPathFinder(this.nodeEvaluator, maxVisitedNodes);
    }

    protected void followThePath() {
        int lastNodeIndex;
        if (this.path == null || this.path.isDone()) {
            return;
        }
        Vec3 entityPos = this.getTempMobPos();
        int nextNodeIndex = this.path.getNextNodeIndex();
        double entityYFloor = Math.floor(entityPos.y);
        int pathLength = this.path.getNodeCount();
        for (lastNodeIndex = nextNodeIndex; lastNodeIndex < pathLength && (double)this.path.getNode((int)lastNodeIndex).y == entityYFloor; ++lastNodeIndex) {
        }
        Vec3 base = entityPos.subtract((double)(this.mob.getBbWidth() * 0.5f), 0.0, (double)(this.mob.getBbWidth() * 0.5f));
        if (this.attemptShortcut(this.path, entityPos, lastNodeIndex, base) && this.hasReached(this.path, 0.5f)) {
            this.path.advance();
        }
        this.doStuckDetection(entityPos);
    }

    private boolean hasReached(Path path, float threshold) {
        Vec3 pathPos = path.getNextEntityPos((Entity)this.mob);
        return Math.abs(this.mob.getX() - pathPos.x) < (double)threshold && Math.abs(this.mob.getZ() - pathPos.z) < (double)threshold && Math.abs(this.mob.getY() - pathPos.y) < 1.0;
    }

    private boolean attemptShortcut(Path path, Vec3 entityPos, int pathLength, Vec3 base) {
        int nextNodeIndex = path.getNextNodeIndex();
        for (int i = pathLength - 1; i > nextNodeIndex; --i) {
            Vec3 vec = path.getEntityPosAtNode((Entity)this.mob, i).subtract(entityPos);
            if (!this.isLineClear(vec, base)) continue;
            path.setNextNodeIndex(i);
            return false;
        }
        return true;
    }

    private boolean isLineClear(Vec3 vec, Vec3 base) {
        int stepZ;
        float tNextZ;
        float tDeltaZ;
        int stepY;
        float tNextY;
        float tDeltaY;
        int stepX;
        float tNextX;
        float tDeltaX;
        float maxT = (float)vec.length();
        if (maxT < 1.0E-8f) {
            return true;
        }
        float dx = (float)vec.x / maxT;
        float dy = (float)vec.y / maxT;
        float dz = (float)vec.z / maxT;
        if (Math.abs(dx) < 1.0E-8f) {
            tDeltaX = Float.POSITIVE_INFINITY;
            tNextX = Float.POSITIVE_INFINITY;
            stepX = 0;
        } else {
            stepX = dx > 0.0f ? 1 : -1;
            float voxelBoundaryX = stepX > 0 ? (float)(Mth.floor((double)base.x) + 1) : (float)Mth.floor((double)base.x);
            tDeltaX = 1.0f / Math.abs(dx);
            tNextX = (float)(((double)voxelBoundaryX - base.x) / (double)dx);
        }
        int currentX = Mth.floor((double)base.x);
        if (Math.abs(dy) < 1.0E-8f) {
            tDeltaY = Float.POSITIVE_INFINITY;
            tNextY = Float.POSITIVE_INFINITY;
            stepY = 0;
        } else {
            stepY = dy > 0.0f ? 1 : -1;
            float voxelBoundaryY = stepY > 0 ? (float)(Mth.floor((double)base.y) + 1) : (float)Mth.floor((double)base.y);
            tDeltaY = 1.0f / Math.abs(dy);
            tNextY = (float)(((double)voxelBoundaryY - base.y) / (double)dy);
        }
        int currentY = Mth.floor((double)base.y);
        if (Math.abs(dz) < 1.0E-8f) {
            tDeltaZ = Float.POSITIVE_INFINITY;
            tNextZ = Float.POSITIVE_INFINITY;
            stepZ = 0;
        } else {
            stepZ = dz > 0.0f ? 1 : -1;
            float voxelBoundaryZ = stepZ > 0 ? (float)(Mth.floor((double)base.z) + 1) : (float)Mth.floor((double)base.z);
            tDeltaZ = 1.0f / Math.abs(dz);
            tNextZ = (float)(((double)voxelBoundaryZ - base.z) / (double)dz);
        }
        int currentZ = Mth.floor((double)base.z);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        float t = 0.0f;
        while (t <= maxT) {
            if (tNextX < tNextY) {
                if (tNextX < tNextZ) {
                    currentX += stepX;
                    t = tNextX;
                    tNextX += tDeltaX;
                } else {
                    currentZ += stepZ;
                    t = tNextZ;
                    tNextZ += tDeltaZ;
                }
            } else if (tNextY < tNextZ) {
                currentY += stepY;
                t = tNextY;
                tNextY += tDeltaY;
            } else {
                currentZ += stepZ;
                t = tNextZ;
                tNextZ += tDeltaZ;
            }
            pos.set(currentX, currentY, currentZ);
            BlockPos immutablePos = pos.immutable();
            Boolean isPathfindable = (Boolean)this.cache.getIfPresent((Object)immutablePos);
            if (isPathfindable == null) {
                BlockState blockState = this.level.getBlockState((BlockPos)pos);
                isPathfindable = blockState.isSolidRender((BlockGetter)this.level, (BlockPos)pos) || blockState.isAir();
                this.cache.put((Object)immutablePos, (Object)isPathfindable);
            }
            if (!isPathfindable.booleanValue()) {
                return false;
            }
            PathType pathType = this.nodeEvaluator.getPathType(new PathfindingContext((CollisionGetter)this.level, this.mob), currentX, currentY, currentZ);
            float malus = this.mob.getPathfindingMalus(pathType);
            if (!(malus < 0.0f) && !(malus >= 8.0f) && pathType != PathType.DAMAGE_FIRE && pathType != PathType.DANGER_FIRE && pathType != PathType.DAMAGE_OTHER) continue;
            return false;
        }
        return true;
    }
}

