/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.block;

import dev.xylonity.companions.common.block.AbstractTeslaBlock;
import dev.xylonity.companions.common.blockentity.TeslaCoilBlockEntity;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeslaCoilBlock
extends AbstractTeslaBlock
implements EntityBlock {
    private static final VoxelShape SHAPE_UP = Stream.of(Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), Block.box((double)1.0, (double)9.0, (double)1.0, (double)15.0, (double)13.0, (double)15.0), Block.box((double)5.5, (double)6.0, (double)5.5, (double)10.5, (double)16.0, (double)10.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_DOWN = Stream.of(Block.box((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), Block.box((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), Block.box((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)10.0, (double)10.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_N = Stream.of(Block.box((double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0, (double)16.0), Block.box((double)1.0, (double)1.0, (double)3.0, (double)15.0, (double)15.0, (double)7.0), Block.box((double)5.5, (double)5.5, (double)0.0, (double)10.5, (double)10.5, (double)10.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_S = Stream.of(Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)6.0), Block.box((double)1.0, (double)1.0, (double)9.0, (double)15.0, (double)15.0, (double)13.0), Block.box((double)5.5, (double)5.5, (double)6.0, (double)10.5, (double)10.5, (double)16.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_W = Stream.of(Block.box((double)10.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), Block.box((double)3.0, (double)1.0, (double)1.0, (double)7.0, (double)15.0, (double)15.0), Block.box((double)0.0, (double)5.5, (double)5.5, (double)10.0, (double)10.5, (double)10.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();
    private static final VoxelShape SHAPE_E = Stream.of(Block.box((double)0.0, (double)5.0, (double)5.0, (double)6.0, (double)11.0, (double)11.0), Block.box((double)9.0, (double)1.0, (double)1.0, (double)13.0, (double)15.0, (double)15.0), Block.box((double)6.0, (double)5.5, (double)5.5, (double)16.0, (double)10.5, (double)10.5)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public TeslaCoilBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return switch ((Direction)pState.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> SHAPE_UP;
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.EAST -> SHAPE_E;
            case Direction.WEST -> SHAPE_W;
            case Direction.NORTH -> SHAPE_N;
            case Direction.SOUTH -> SHAPE_S;
        };
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return CompanionsBlockEntities.TESLA_COIL.get().create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level pLevel, @NotNull BlockState pState, @NotNull BlockEntityType<T> pBlockEntityType) {
        return pBlockEntityType == CompanionsBlockEntities.TESLA_COIL.get() ? TeslaCoilBlockEntity::tick : null;
    }
}

