/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.common.tesla.TeslaConnectionManager;
import dev.xylonity.companions.common.tesla.behaviour.DefaultAttackBehaviour;
import dev.xylonity.companions.common.util.interfaces.ITeslaNodeBehaviour;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtil;

public abstract class AbstractTeslaBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final TeslaConnectionManager connectionManager = TeslaConnectionManager.getInstance();
    public int tickCount = 0;
    public int activationTick = 0;
    public int cycleCounter = -1;
    protected boolean pendingRemoval = false;
    protected boolean receivesGenerator = false;
    protected int distance = 0;
    protected boolean isActive = false;
    protected UUID ownerUUID;
    protected ITeslaNodeBehaviour defaultAttackBehaviour = new DefaultAttackBehaviour();

    public AbstractTeslaBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public int getDistance() {
        return this.distance;
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public TeslaConnectionManager.ConnectionNode asConnectionNode() {
        ResourceLocation dimension = this.getLevel() != null ? this.getLevel().dimension().location() : ResourceLocation.withDefaultNamespace((String)"overworld");
        return TeslaConnectionManager.ConnectionNode.forBlock(this.getBlockPos(), dimension);
    }

    public void onLoad() {
        super.onLoad();
        TeslaConnectionManager.getInstance().registerBlockEntity(this);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        tag.getList("OutgoingConnections", 10).forEach(t -> TeslaConnectionManager.getInstance().addConnection(this.asConnectionNode(), TeslaConnectionManager.ConnectionNode.deserialize((CompoundTag)t), true));
        this.tickCount = tag.getInt("TickCount");
        this.isActive = tag.getBoolean("IsActive");
        int n = this.activationTick = tag.contains("ActivationTick") ? tag.getInt("ActivationTick") : 0;
        if (this.cycleCounter >= 0) {
            tag.putInt("CycleCounter", this.cycleCounter);
        }
        this.receivesGenerator = tag.getBoolean("ReceivesGenerator");
        this.setDistance(tag.getInt("Distance"));
        this.setAnimationStartTick(tag.getInt("AnimationTick"));
        if (tag.contains("OwnerUUID")) {
            this.setOwnerUUID(tag.getUUID("OwnerUUID"));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ListTag outgoing = new ListTag();
        this.connectionManager.getOutgoing(this.asConnectionNode()).forEach(node -> outgoing.add((Object)node.serialize()));
        tag.put("OutgoingConnections", (Tag)outgoing);
        tag.putInt("TickCount", this.tickCount);
        tag.putBoolean("IsActive", this.isActive);
        tag.putInt("ActivationTick", this.activationTick);
        tag.putInt("CycleCounter", this.cycleCounter);
        tag.putBoolean("ReceivesGenerator", this.receivesGenerator);
        tag.putInt("Distance", this.distance);
        tag.putInt("AnimationTick", this.getAnimationStartTick());
        if (this.getOwnerUUID() != null) {
            tag.putUUID("OwnerUUID", this.getOwnerUUID());
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public double getTick(Object o) {
        return RenderUtil.getCurrentTick();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider holders) {
        super.handleUpdateTag(tag, holders);
        this.tickCount = tag.getInt("TickCount");
        this.isActive = tag.getBoolean("IsActive");
        this.distance = tag.getInt("Distance");
        this.setAnimationStartTick(tag.getInt("AnimationTick"));
        this.cycleCounter = tag.getInt("CycleCounter");
        if (this.getOwnerUUID() != null) {
            this.setOwnerUUID(tag.getUUID("OwnerUUID"));
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        tag.putInt("TickCount", this.tickCount);
        tag.putBoolean("IsActive", this.isActive);
        tag.putInt("Distance", this.distance);
        tag.putInt("AnimationTick", this.getAnimationStartTick());
        tag.putInt("CycleCounter", this.cycleCounter);
        if (tag.contains("OwnerUUID")) {
            tag.putUUID("OwnerUUID", this.getOwnerUUID());
        }
        return tag;
    }

    public void sync() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ClientboundBlockEntityDataPacket pkt = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        ChunkPos chunkPos = new ChunkPos(this.worldPosition);
        serverLevel.getChunkSource().chunkMap.getPlayers(chunkPos, false).forEach(arg_0 -> AbstractTeslaBlockEntity.lambda$sync$2((Packet)pkt, arg_0));
    }

    public boolean isPendingRemoval() {
        return this.pendingRemoval;
    }

    public void setReceivesGenerator(boolean flag) {
        this.receivesGenerator = flag;
    }

    public boolean isReceivesGenerator() {
        return this.receivesGenerator;
    }

    public void setAnimationStartTick(int tick) {
        this.activationTick = tick;
    }

    public void startCycle() {
        this.cycleCounter = 0;
        this.setChanged();
    }

    public int getAnimationStartTick() {
        return this.activationTick;
    }

    public boolean hasConcurrentPower() {
        return this.isActive;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean canConnectToOtherModules() {
        return true;
    }

    @NotNull
    public abstract Vec3 electricalChargeOriginOffset();

    @NotNull
    public abstract Vec3 electricalChargeEndOffset();

    public boolean handleNodeSelection(TeslaConnectionManager.ConnectionNode thisNode, TeslaConnectionManager.ConnectionNode nodeToConnect, @Nullable UseOnContext ctx, Player player) {
        this.connectionManager.addConnection(thisNode, nodeToConnect);
        return true;
    }

    public boolean handleNodeRemoval(TeslaConnectionManager.ConnectionNode thisNode, TeslaConnectionManager.ConnectionNode nodeToConnect, @Nullable UseOnContext ctx, Player player) {
        this.connectionManager.removeConnection(thisNode, nodeToConnect);
        return true;
    }

    private static /* synthetic */ void lambda$sync$2(Packet pkt, ServerPlayer p) {
        p.connection.send(pkt);
    }
}

