/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.common.entity.companion.CroissantDragonEntity;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.knightlib.api.TickScheduler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtil;

public class CroissantEggBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private final RawAnimation SPASM = RawAnimation.begin().thenPlay("spasms");
    private int tickCounter = 0;
    private boolean spasm = false;

    public CroissantEggBlockEntity(BlockPos pos, BlockState state) {
        super(CompanionsBlockEntities.CROISSANT_EGG.get(), pos, state);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T F) {
        if (F instanceof CroissantEggBlockEntity) {
            CroissantEggBlockEntity egg = (CroissantEggBlockEntity)F;
            ++egg.tickCounter;
            if (egg.tickCounter >= CompanionsConfig.CROISSANT_EGG_LIFETIME) {
                level.destroyBlock(pos, false);
                Entity croissantDragonEntity = CompanionsEntities.CROISSANT_DRAGON.get().create(level);
                if (croissantDragonEntity instanceof CroissantDragonEntity) {
                    CroissantDragonEntity croissantDragon = (CroissantDragonEntity)croissantDragonEntity;
                    croissantDragon.moveTo(egg.getBlockPos().getCenter());
                    level.addFreshEntity((Entity)croissantDragon);
                }
            }
            if (egg.tickCounter % 200 == 0) {
                egg.spasm = true;
                TickScheduler.scheduleBoth((Level)level, () -> {
                    egg.spasm = false;
                }, (int)40);
            }
            if (egg.tickCounter % 25 == 0) {
                level.addParticle((ParticleOptions)ParticleTypes.CLOUD, (double)egg.getBlockPos().getX() + 0.5, (double)egg.getBlockPos().getY(), (double)egg.getBlockPos().getZ() + 0.5, 0.0015, 0.1, 0.0015);
            }
        }
    }

    public int getTickCounter() {
        return this.tickCounter;
    }

    public double getTick(Object o) {
        return RenderUtil.getCurrentTick();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        if (this.spasm) {
            event.getController().setAnimation(this.SPASM);
        } else {
            event.getController().setAnimation(this.IDLE);
        }
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

