/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.common.entity.HostileEntity;
import dev.xylonity.companions.common.util.Util;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import dev.xylonity.companions.registry.CompanionsBlocks;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SpawnUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtil;

public class FrogBonanzaBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public static final RawAnimation COIN = RawAnimation.begin().thenPlay("coin");
    public static final RawAnimation LEVER = RawAnimation.begin().thenPlay("lever");
    private static final int DELAY_BETWEEN_WHEELS = 4;
    private static final int GAME_TICKS = 100;
    private static final float EXTRA_SPINS = 720.0f;
    private final float[] rotation = new float[3];
    private final float[] startRot = new float[3];
    private final float[] totalRot = new float[3];
    private final int[] faceDeg = new int[3];
    private int spinStartTick = -1;
    private int tickCount = 0;
    private int spinsRemaining = 0;
    private static final String TAG_ROT = "Rot";
    private static final String TAG_FACE = "Face";
    private static final String TAG_START = "Start";
    private static final String TAG_TOTAL = "Total";

    public FrogBonanzaBlockEntity(BlockPos pos, BlockState state) {
        super(CompanionsBlockEntities.FROG_BONANZA.get(), pos, state);
    }

    public void startSpinning(int[] finalFacesDeg) {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        for (int i = 0; i < 3; ++i) {
            this.faceDeg[i] = finalFacesDeg[i] % 360;
            this.startRot[i] = this.rotation[i];
            float delta = (float)this.faceDeg[i] - Util.normalizeDeg(this.startRot[i]);
            if (delta < 0.0f) {
                delta += 360.0f;
            }
            this.totalRot[i] = delta + 720.0f;
        }
        this.spinStartTick = this.tickCount;
        this.sync();
    }

    public void startGame() {
        this.startSpinning(new int[]{new Random().nextInt(4) * 90, new Random().nextInt(4) * 90, new Random().nextInt(4) * 90});
    }

    public float getWheelRotation(int idx) {
        return this.rotation[idx];
    }

    public static <T extends BlockEntity> void tick(Level lvl, BlockPos pos, BlockState st, T be) {
        if (!(be instanceof FrogBonanzaBlockEntity)) {
            return;
        }
        FrogBonanzaBlockEntity b = (FrogBonanzaBlockEntity)be;
        if (b.spinStartTick < 0) {
            return;
        }
        boolean hasFinished = true;
        for (int i = 0; i < 3; ++i) {
            int local = b.tickCount - (b.spinStartTick + i * 4);
            if (local < 0) {
                hasFinished = false;
                continue;
            }
            if (local >= 100) {
                b.rotation[i] = b.faceDeg[i];
                continue;
            }
            hasFinished = false;
            b.rotation[i] = Util.normalizeDeg(b.startRot[i] + b.totalRot[i] * (1.0f - (float)Math.pow(1.0f - (float)local / 100.0f, 3.0)));
        }
        if (hasFinished) {
            b.spinStartTick = -1;
            b.getFroggyReward();
            b.sync();
        }
        ++b.tickCount;
    }

    private void getFroggyReward() {
        ConcurrentHashMap<Integer, Integer> counts = new ConcurrentHashMap<Integer, Integer>();
        for (int f : this.faceDeg) {
            counts.put(f, counts.getOrDefault(f, 0) + 1);
        }
        if (counts.size() == 1) {
            switch (this.faceDeg[0]) {
                case 0: {
                    this.tripleCreeper();
                    break;
                }
                case 90: {
                    this.tripleCoin();
                    break;
                }
                case 180: {
                    this.tripleTeddy();
                    break;
                }
                case 270: {
                    this.tripleSkull();
                }
            }
            return;
        }
        Object object = counts.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            if ((Integer)entry.getValue() != 2) continue;
            switch ((Integer)entry.getKey()) {
                case 0: {
                    this.doubleCreeper();
                    break;
                }
                case 90: {
                    this.doubleCoin();
                    break;
                }
                case 180: {
                    this.doubleTeddy();
                    break;
                }
                case 270: {
                    this.doubleSkull();
                }
            }
            return;
        }
    }

    private static List<TeddyDrop> parseBonanzaTeddyDrops(String config) {
        ArrayList<TeddyDrop> list = new ArrayList<TeddyDrop>();
        if (config == null || config.isBlank()) {
            return list;
        }
        for (String part : config.split(";")) {
            int max;
            int min;
            float chance;
            String[] entry = part.trim().split(",");
            if (entry.length != 3) continue;
            try {
                chance = Float.parseFloat(entry[1].trim());
            }
            catch (NumberFormatException ignore) {
                continue;
            }
            String count = entry[2].trim();
            if (count.contains("-")) {
                String[] range = count.split("-");
                try {
                    min = Integer.parseInt(range[0].trim());
                    max = Integer.parseInt(range[1].trim());
                }
                catch (NumberFormatException ignore) {
                    min = 1;
                    max = 1;
                }
            } else {
                try {
                    min = Integer.parseInt(count);
                    max = Integer.parseInt(count);
                }
                catch (NumberFormatException ignore) {
                    min = 1;
                    max = 1;
                }
            }
            list.add(new TeddyDrop(entry[0].trim(), chance, min, max));
        }
        return list;
    }

    private static List<SkullDropEntities> parseEntitySpawns(String config) {
        ArrayList<SkullDropEntities> list = new ArrayList<SkullDropEntities>();
        if (config == null || config.isBlank()) {
            return list;
        }
        for (String part : config.split(";")) {
            int amount;
            String[] entry = part.trim().split(",");
            if (entry.length != 2) continue;
            String id = entry[0].trim();
            try {
                amount = Integer.parseInt(entry[1].trim());
            }
            catch (NumberFormatException ignore) {
                continue;
            }
            list.add(new SkullDropEntities(id, amount));
        }
        return list;
    }

    private void doubleCreeper() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            BlockPos center = this.worldPosition.above();
            for (int i = 0; i < 2 + new Random().nextInt(3); ++i) {
                BonanzaTnt tnt = new BonanzaTnt((Level)server, (double)center.getX() + 0.5, center.getY(), (double)center.getZ() + 0.5, null);
                double angle = this.getLevel().random.nextDouble() * Math.PI * 2.0;
                double speed = 0.15 + this.getLevel().random.nextDouble() * 0.6;
                tnt.setDeltaMovement(Math.cos(angle) * speed, 0.5 + this.getLevel().random.nextDouble() * 0.3, Math.sin(angle) * speed);
                tnt.setFuse(40);
                server.addFreshEntity((Entity)tnt);
            }
            this.getLevel().playSound(null, this.getBlockPos(), CompanionsSounds.POP.get(), SoundSource.BLOCKS);
        }
    }

    private void doubleCoin() {
        if (this.getLevel() != null) {
            FrogBonanzaBlockEntity.popResource(this.getLevel(), this.getBlockPos(), new ItemStack((ItemLike)CompanionsBlocks.COPPER_COIN.get(), new Random().nextInt(2, 10)));
            FrogBonanzaBlockEntity.popResource(this.getLevel(), this.getBlockPos(), new ItemStack((ItemLike)CompanionsBlocks.NETHER_COIN.get(), new Random().nextInt(1, 4)));
            FrogBonanzaBlockEntity.popResource(this.getLevel(), this.getBlockPos(), new ItemStack((ItemLike)CompanionsBlocks.END_COIN.get()));
            this.getLevel().playSound(null, this.getBlockPos(), CompanionsSounds.POP.get(), SoundSource.BLOCKS);
        }
    }

    private void doubleTeddy() {
        if (this.getLevel() != null) {
            FrogBonanzaBlockEntity.parseBonanzaTeddyDrops(CompanionsConfig.BONANZA_2_TEDDY_HEADS_DROPS).forEach(drop -> {
                Item item;
                if (this.getLevel().getRandom().nextFloat() < drop.chance && (item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)drop.id()))) != null) {
                    FrogBonanzaBlockEntity.popResource(this.getLevel(), this.getBlockPos(), new ItemStack((ItemLike)item, drop.min == drop.max ? drop.min : this.getLevel().getRandom().nextInt(drop.min, drop.max + 1)));
                }
            });
            this.getLevel().playSound(null, this.getBlockPos(), CompanionsSounds.POP.get(), SoundSource.BLOCKS);
        }
    }

    private void doubleSkull() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 center = Vec3.atCenterOf((Vec3i)this.getBlockPos());
            Player player = serverLevel.getNearestPlayer(center.x, center.y, center.z, 25.0, false);
            if (player != null) {
                FallingBlockEntity anvil = new FallingBlockEntity((Level)serverLevel, player.getX(), player.getY() + 20.0, player.getZ(), Blocks.ANVIL.defaultBlockState());
                anvil.time = 1;
                anvil.disableDrop();
                anvil.setHurtsEntities(2.0f, 40);
                serverLevel.addFreshEntity((Entity)anvil);
            }
            this.getLevel().playSound(null, this.getBlockPos(), CompanionsSounds.POP.get(), SoundSource.BLOCKS);
        }
    }

    private void tripleCreeper() {
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            BlockPos center = this.worldPosition.above();
            for (int i = 0; i < 3; ++i) {
                double angle = new Random().nextDouble() * Math.PI * 2.0;
                double dist = new Random().nextDouble() * 4.0;
                double x = (double)center.getX() + 0.5 + Math.cos(angle) * dist;
                double y = center.getY();
                double z = (double)center.getZ() + 0.5 + Math.sin(angle) * dist;
                Creeper creeper = (Creeper)EntityType.CREEPER.create((Level)server);
                if (creeper == null) continue;
                creeper.moveTo(x, y, z, new Random().nextFloat() * 360.0f, 0.0f);
                LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)server);
                if (bolt != null) {
                    bolt.moveTo(x, y, z);
                    server.addFreshEntity((Entity)bolt);
                    creeper.thunderHit(server, bolt);
                }
                server.addFreshEntity((Entity)creeper);
            }
            this.getLevel().playSound(null, this.getBlockPos(), CompanionsSounds.POP.get(), SoundSource.BLOCKS);
        }
    }

    private void tripleCoin() {
        if (this.getLevel() != null) {
            RandomSource rand = this.getLevel().getRandom();
            FrogBonanzaBlockEntity.popResource(this.getLevel(), this.getBlockPos(), new ItemStack((ItemLike)CompanionsBlocks.COPPER_COIN.get(), rand.nextInt(1, 20)));
            if (rand.nextFloat() < 0.75f) {
                FrogBonanzaBlockEntity.popResource(this.getLevel(), this.getBlockPos(), new ItemStack((ItemLike)CompanionsBlocks.NETHER_COIN.get(), rand.nextInt(1, 5)));
            }
            if (rand.nextFloat() < 0.45f) {
                FrogBonanzaBlockEntity.popResource(this.getLevel(), this.getBlockPos(), new ItemStack((ItemLike)CompanionsBlocks.END_COIN.get(), 1));
            }
            this.getLevel().playSound(null, this.getBlockPos(), CompanionsSounds.POP.get(), SoundSource.BLOCKS);
        }
    }

    private void tripleTeddy() {
        if (this.getLevel() != null && this.getLevel() != null) {
            FrogBonanzaBlockEntity.parseBonanzaTeddyDrops(CompanionsConfig.BONANZA_3_TEDDY_HEADS_DROPS).forEach(drop -> {
                Item item;
                if (this.getLevel().getRandom().nextFloat() < drop.chance && (item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)drop.id()))) != null) {
                    FrogBonanzaBlockEntity.popResource(this.getLevel(), this.getBlockPos(), new ItemStack((ItemLike)item, drop.min == drop.max ? drop.min : this.getLevel().getRandom().nextInt(drop.min, drop.max + 1)));
                }
            });
            this.getLevel().playSound(null, this.getBlockPos(), CompanionsSounds.POP.get(), SoundSource.BLOCKS);
        }
    }

    private void tripleSkull() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        BlockPos center = this.worldPosition.above();
        Player player = server.getNearestPlayer((double)center.getX(), (double)center.getY(), (double)center.getZ(), 15.0, false);
        if (player == null) {
            return;
        }
        for (SkullDropEntities config : FrogBonanzaBlockEntity.parseEntitySpawns(CompanionsConfig.BONANZA_3_SKULL_DROP_ENTITIES)) {
            EntityType raw = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)config.id()));
            if (raw == null) continue;
            EntityType type = raw;
            for (int i = 0; i < config.amount; ++i) {
                if (type == EntityType.WARDEN) {
                    SpawnUtil.trySpawnMob((EntityType)type, (MobSpawnType)MobSpawnType.TRIGGERED, (ServerLevel)server, (BlockPos)center, (int)20, (int)5, (int)6, (SpawnUtil.Strategy)SpawnUtil.Strategy.ON_TOP_OF_COLLIDER).ifPresent(e -> {
                        e.moveTo(e.getX(), e.getY(), e.getZ(), player.getYRot(), 0.0f);
                        e.setTarget((LivingEntity)player);
                        e.getBrain().setMemory(MemoryModuleType.ANGRY_AT, (Object)player.getUUID());
                    });
                    continue;
                }
                LivingEntity e2 = (LivingEntity)type.spawn(server, new BlockPos(center.getX() - 3 + server.random.nextInt(4), center.getY() - 1, center.getZ() - 3 + server.random.nextInt(4)), MobSpawnType.MOB_SUMMONED);
                if (e2 == null) continue;
                e2.moveTo(e2.getX(), e2.getY(), e2.getZ(), player.getYRot(), 0.0f);
                if (e2 instanceof HostileEntity) {
                    HostileEntity hostile = (HostileEntity)e2;
                    hostile.setTarget((LivingEntity)player);
                }
                server.addFreshEntity((Entity)e2);
            }
        }
        this.level.playSound(null, center, CompanionsSounds.POP.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public static void popResource(Level pLevel, BlockPos pPos, ItemStack pStack) {
        double d0 = EntityType.ITEM.getHeight() / 2.0f;
        double d1 = (double)pPos.getX() + 0.5;
        double d2 = (double)pPos.getY() + 1.5 + Mth.nextDouble((RandomSource)pLevel.random, (double)-0.25, (double)0.25) - d0;
        double d3 = (double)pPos.getZ() + 0.5;
        FrogBonanzaBlockEntity.popResource(pLevel, () -> new ItemEntity(pLevel, d1, d2, d3, pStack, -0.25 + Math.random() * 0.25, -0.35 + Math.random() * (double)0.35f, -0.25 + Math.random() * 0.25), pStack);
    }

    private static void popResource(Level pLevel, Supplier<ItemEntity> pItemEntitySupplier, ItemStack pStack) {
        if (!pLevel.isClientSide && !pStack.isEmpty()) {
            ItemEntity itementity = pItemEntitySupplier.get();
            itementity.setDefaultPickUpDelay();
            pLevel.addFreshEntity((Entity)itementity);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("SpinStart", this.spinStartTick);
        tag.putInt("TickCount", this.tickCount);
        tag.put(TAG_ROT, (Tag)Util.floatsToList(this.rotation));
        tag.put(TAG_START, (Tag)Util.floatsToList(this.startRot));
        tag.put(TAG_TOTAL, (Tag)Util.floatsToList(this.totalRot));
        tag.put(TAG_FACE, (Tag)Util.intsToList(this.faceDeg));
        tag.putInt("SpinsRemaining", this.spinsRemaining);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.spinStartTick = tag.getInt("SpinStart");
        this.tickCount = tag.getInt("TickCount");
        Util.listToFloats(tag.getList(TAG_ROT, 5), this.rotation);
        Util.listToFloats(tag.getList(TAG_START, 5), this.startRot);
        Util.listToFloats(tag.getList(TAG_TOTAL, 5), this.totalRot);
        Util.listToInts(tag.getList(TAG_FACE, 3), this.faceDeg);
        this.spinsRemaining = tag.getInt("SpinsRemaining");
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    private void sync() {
        if (!(this.level instanceof ServerLevel)) {
            return;
        }
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    public ItemInteractionResult interact(Player player, InteractionHand hand) {
        if (this.level == null) {
            return ItemInteractionResult.FAIL;
        }
        if (this.level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        if (this.spinStartTick >= 0) {
            return ItemInteractionResult.FAIL;
        }
        ItemStack stack = player.getItemInHand(hand);
        Item item = stack.getItem();
        if (this.spinsRemaining <= 0) {
            int tries = FrogBonanzaBlockEntity.getSpinsForCurrencyItem(item);
            if (tries <= 0) {
                return ItemInteractionResult.FAIL;
            }
            this.spinsRemaining = tries;
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            this.triggerAnim("coin_controller", "coin");
            this.sync();
            this.level.playSound(null, this.getBlockPos(), CompanionsSounds.COIN_CLATTER.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        --this.spinsRemaining;
        this.triggerAnim("lever_controller", "lever");
        this.startGame();
        this.sync();
        this.level.playSound(null, this.getBlockPos(), CompanionsSounds.BONANZA.get(), SoundSource.BLOCKS, 0.35f, 1.0f);
        return ItemInteractionResult.SUCCESS;
    }

    private static Map<Item, Integer> parseBonanzaCurrencies(String configEntry) {
        ConcurrentHashMap<Item, Integer> map = new ConcurrentHashMap<Item, Integer>();
        if (configEntry == null || configEntry.isBlank()) {
            return map;
        }
        for (String part : configEntry.split(";")) {
            int tries;
            ResourceLocation id;
            String[] entry = part.trim().split(",");
            if (entry.length != 2) continue;
            String idString = entry[0].trim();
            String triesString = entry[1].trim();
            try {
                id = ResourceLocation.parse((String)idString);
            }
            catch (Exception ignore) {
                continue;
            }
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            if (item == null) continue;
            try {
                tries = Integer.parseInt(triesString);
            }
            catch (Exception ignore) {
                continue;
            }
            if (tries <= 0) continue;
            map.put(item, tries);
        }
        return map;
    }

    private static int getSpinsForCurrencyItem(Item item) {
        Map<Item, Integer> currencies = FrogBonanzaBlockEntity.parseBonanzaCurrencies(CompanionsConfig.BONANZA_CURRENCY_TYPES);
        return currencies.getOrDefault(item, 0);
    }

    public double getTick(Object o) {
        return RenderUtil.getCurrentTick();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "coin_controller", state -> PlayState.STOP).triggerableAnim("coin", COIN));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "lever_controller", state -> PlayState.STOP).triggerableAnim("lever", LEVER));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private record TeddyDrop(String id, float chance, int min, int max) {
    }

    private record SkullDropEntities(String id, int amount) {
    }

    private static class BonanzaTnt
    extends PrimedTnt {
        public BonanzaTnt(Level level, double x, double y, double z, LivingEntity owner) {
            super(level, x, y, z, owner);
        }

        protected void explode() {
            this.level().explode((Entity)this, this.getX(), this.getY() + (double)(this.getBbHeight() / 16.0f), this.getZ(), 4.0f, Level.ExplosionInteraction.NONE);
        }
    }
}

