/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.common.blockentity.AbstractTeslaBlockEntity;
import dev.xylonity.companions.common.tesla.TeslaConnectionManager;
import dev.xylonity.companions.common.tesla.behaviour.platform.RecallPlatformPulseBehaviour;
import dev.xylonity.companions.common.util.interfaces.ITeslaNodeBehaviour;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import dev.xylonity.companions.registry.CompanionsSounds;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class RecallPlatformBlockEntity
extends AbstractTeslaBlockEntity {
    private static final int COOLDOWN_TICKS = 20;
    private final Set<BlockPos> partnerPositions = new HashSet<BlockPos>();
    private int cooldown = 0;
    private final ITeslaNodeBehaviour pulseBehaviour = new RecallPlatformPulseBehaviour();

    public RecallPlatformBlockEntity(BlockPos pos, BlockState st) {
        super(CompanionsBlockEntities.RECALL_PLATFORM.get(), pos, st);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        if (!(t instanceof RecallPlatformBlockEntity)) {
            return;
        }
        RecallPlatformBlockEntity platform = (RecallPlatformBlockEntity)t;
        platform.cooldown = level.getEntitiesOfClass(Player.class, new AABB(platform.getBlockPos()).move(0.0, 1.0, 0.0).inflate(0.5)).isEmpty() ? 20 : --platform.cooldown;
        platform.pulseBehaviour.process(platform, level, blockPos, blockState);
        ++platform.tickCount;
        platform.sync();
    }

    public void onStepped(ServerPlayer player) {
        if (this.cooldown > 0 || !this.isActive()) {
            return;
        }
        if (this.getLevel() == null) {
            return;
        }
        ArrayList<BlockPos> shuffled = new ArrayList<BlockPos>(this.partnerPositions);
        Collections.shuffle(shuffled, new Random());
        for (BlockPos target : shuffled) {
            BlockEntity blockEntity = this.getLevel().getBlockEntity(target);
            if (!(blockEntity instanceof RecallPlatformBlockEntity)) {
                this.partnerPositions.remove(target);
                this.setChanged();
                continue;
            }
            RecallPlatformBlockEntity otherPlatform = (RecallPlatformBlockEntity)blockEntity;
            TeslaConnectionManager manager = TeslaConnectionManager.getInstance();
            if (!manager.getConnectedComponent(this.asConnectionNode()).contains(otherPlatform.asConnectionNode())) {
                this.partnerPositions.remove(target);
                this.setChanged();
                continue;
            }
            if (this.level != null) {
                this.level.playSound(null, this.getBlockPos(), CompanionsSounds.TEDDY_TRANSFORMATION.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            player.teleportTo((double)target.getX() + 0.5, (double)(target.getY() + 1), (double)target.getZ() + 0.5);
            if (this.level != null) {
                this.level.playSound(null, target, CompanionsSounds.TEDDY_TRANSFORMATION.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.cooldown = 20;
            otherPlatform.cooldown = 20;
            return;
        }
    }

    public void updatePartners(Set<BlockPos> newPartners) {
        this.partnerPositions.clear();
        this.partnerPositions.addAll(newPartners);
        this.setChanged();
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ListTag list = new ListTag();
        for (BlockPos p : this.partnerPositions) {
            CompoundTag t = new CompoundTag();
            t.putInt("X", p.getX());
            t.putInt("Y", p.getY());
            t.putInt("Z", p.getZ());
            list.add((Object)t);
        }
        tag.put("Partners", (Tag)list);
        tag.putInt("Cooldown", this.cooldown);
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.partnerPositions.clear();
        if (tag.contains("Partners", 9)) {
            ListTag list = tag.getList("Partners", 10);
            for (Tag t : list) {
                CompoundTag c = (CompoundTag)t;
                this.partnerPositions.add(new BlockPos(c.getInt("X"), c.getInt("Y"), c.getInt("Z")));
            }
        }
        this.cooldown = tag.getInt("Cooldown");
    }

    @Override
    @NotNull
    public Vec3 electricalChargeOriginOffset() {
        return Vec3.ZERO;
    }

    @Override
    @NotNull
    public Vec3 electricalChargeEndOffset() {
        return new Vec3(0.0, 0.5, 0.0);
    }
}

