/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.common.entity.CompanionEntity;
import dev.xylonity.companions.common.entity.projectile.RespawnTotemRingProjectile;
import dev.xylonity.companions.config.CompanionsConfig;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import dev.xylonity.companions.registry.CompanionsEntities;
import dev.xylonity.companions.registry.CompanionsParticles;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;
import software.bernie.geckolib.util.RenderUtil;

public class RespawnTotemBlockEntity
extends BlockEntity
implements GeoBlockEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    public final Map<UUID, CompoundTag> savedEntities = new ConcurrentHashMap<UUID, CompoundTag>();
    private final List<RespawnData> pending = new ArrayList<RespawnData>();
    private int tickCount = 0;
    private boolean isCapturing = false;
    private int charges = 0;
    private int captureCooldown = 0;

    public RespawnTotemBlockEntity(BlockPos pos, BlockState state) {
        super(CompanionsBlockEntities.RESPAWN_TOTEM.get(), pos, state);
    }

    public void queueRespawn(CompoundTag nbt, int delay) {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel sv = (ServerLevel)level;
        this.pending.add(new RespawnData(nbt, sv.getGameTime() + (long)delay));
        this.setChanged();
    }

    public void setCharges(int charges) {
        this.charges = charges;
        this.sync();
    }

    public int getCharges() {
        return this.charges;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public boolean captureNearby() {
        if (this.level == null) {
            return false;
        }
        if (this.level.isClientSide) {
            return false;
        }
        boolean captureFlag = false;
        for (Entity e : this.level.getEntitiesOfClass(TamableAnimal.class, new AABB(this.worldPosition).inflate(5.0))) {
            if (e.isRemoved()) continue;
            CompoundTag data = new CompoundTag();
            e.save(data);
            this.savedEntities.put(e.getUUID(), data);
            e.getPersistentData().putLong("RespawnTotemPos", this.worldPosition.asLong());
            e.getPersistentData().putString("RespawnTotemDim", this.level.dimension().location().toString());
            captureFlag = true;
        }
        this.setChanged();
        return captureFlag;
    }

    public int getCaptureCooldown() {
        return this.captureCooldown;
    }

    public void setCaptureCooldown(int captureCooldown) {
        this.captureCooldown = captureCooldown;
    }

    public void setCapturing(boolean capturing) {
        if (capturing && this.getCaptureCooldown() > 0) {
            return;
        }
        this.isCapturing = capturing;
    }

    public boolean isCapturing() {
        return this.isCapturing;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt("Charges", this.getCharges());
        ListTag list = new ListTag();
        this.savedEntities.forEach((uuid, data) -> {
            CompoundTag entry = new CompoundTag();
            entry.putUUID("Uuid", uuid);
            entry.put("Data", (Tag)data);
            list.add((Object)entry);
        });
        tag.put("RespawnList", (Tag)list);
        ListTag list2 = new ListTag();
        for (RespawnData p : this.pending) {
            CompoundTag e = new CompoundTag();
            e.putLong("When", p.time);
            e.put("Nbt", (Tag)p.nbt);
            list2.add((Object)e);
        }
        tag.put("RespawnPending", (Tag)list2);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.savedEntities.clear();
        this.charges = tag.getInt("Charges");
        ListTag list = tag.getList("RespawnList", 10);
        for (Tag t : list) {
            CompoundTag entry = (CompoundTag)t;
            this.savedEntities.put(entry.getUUID("Uuid"), entry.getCompound("Data"));
        }
        this.pending.clear();
        ListTag list2 = tag.getList("RespawnPending", 10);
        for (Tag t : list2) {
            CompoundTag e = (CompoundTag)t;
            this.pending.add(new RespawnData(e.getCompound("Nbt"), e.getLong("When")));
        }
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider holders) {
        super.handleUpdateTag(tag, holders);
        this.charges = tag.getInt("Charges");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = super.getUpdateTag(provider);
        tag.putInt("Charges", this.getCharges());
        return tag;
    }

    public void sync() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ClientboundBlockEntityDataPacket pkt = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        serverLevel.getChunkSource().chunkMap.getPlayers(new ChunkPos(this.worldPosition), false).forEach(arg_0 -> RespawnTotemBlockEntity.lambda$sync$1((Packet)pkt, arg_0));
    }

    public static <X extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, X blockEntity) {
        ServerLevel sv;
        if (!(blockEntity instanceof RespawnTotemBlockEntity)) {
            return;
        }
        RespawnTotemBlockEntity t = (RespawnTotemBlockEntity)blockEntity;
        if (level instanceof ServerLevel) {
            sv = (ServerLevel)level;
            long now = sv.getGameTime();
            Iterator<RespawnData> it = t.pending.iterator();
            while (it.hasNext()) {
                RespawnData p = it.next();
                if (now < p.time) continue;
                Entity spawned = EntityType.loadEntityRecursive((CompoundTag)p.nbt, (Level)sv, e -> {
                    BlockPos sPos = RespawnTotemBlockEntity.findSpawn(sv, pos, 5);
                    double x = sPos != null ? (double)sPos.getX() + 0.5 : (double)pos.getX() + 0.5;
                    double y = sPos != null ? sPos.getY() : pos.getY() + 1;
                    double z = sPos != null ? (double)sPos.getZ() + 0.5 : (double)pos.getZ() + 0.5;
                    e.setPos(x, y, z);
                    return e;
                });
                if (spawned != null) {
                    for (int i = 0; i < 20; ++i) {
                        double dx = (sv.random.nextDouble() - 0.5) * 2.0;
                        double dy = (sv.random.nextDouble() - 0.5) * 2.0;
                        double dz = (sv.random.nextDouble() - 0.5) * 2.0;
                        sv.sendParticles((ParticleOptions)ParticleTypes.POOF, spawned.getX(), spawned.getY() + (double)spawned.getBbHeight() * 0.5, spawned.getZ(), 1, dx, dy, dz, 0.1);
                    }
                    t.setCharges(t.getCharges() - 1);
                    if (spawned instanceof CompanionEntity) {
                        CompanionEntity c = (CompanionEntity)spawned;
                        c.setMainAction(0, null);
                    } else if (spawned instanceof TamableAnimal) {
                        TamableAnimal tamableAnimal = (TamableAnimal)spawned;
                        tamableAnimal.setOrderedToSit(true);
                    }
                    sv.addFreshEntity(spawned);
                }
                it.remove();
            }
        }
        if (t.isCapturing()) {
            if (level instanceof ServerLevel) {
                sv = (ServerLevel)level;
                for (int i = 0; i < 20; ++i) {
                    double dx = (sv.random.nextDouble() - 0.5) * 2.0;
                    double dy = (sv.random.nextDouble() - 0.5) * 2.0;
                    double dz = (sv.random.nextDouble() - 0.5) * 2.0;
                    sv.sendParticles((ParticleOptions)ParticleTypes.POOF, (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, 1, dx, dy, dz, 0.1);
                }
                RespawnTotemRingProjectile ring = (RespawnTotemRingProjectile)CompanionsEntities.RESPAWN_TOTEM_RING_PROJECTILE.get().create(level);
                if (ring != null) {
                    ring.setPos((double)pos.getX() + 0.5, t.getRingSpawnY(level, pos) + 0.015, (double)pos.getZ() + 0.5);
                    level.addFreshEntity((Entity)ring);
                }
            }
            if (t.captureNearby()) {
                t.setCharges(CompanionsConfig.RESPAWN_TOTEM_CHARGES);
            }
            t.setCapturing(false);
            t.setCaptureCooldown(40);
            t.setChanged();
        }
        if (t.getCaptureCooldown() > 0) {
            t.setCaptureCooldown(t.getCaptureCooldown() - 1);
        }
        if (t.tickCount % 10 == 0 && t.getCharges() > 0) {
            double dx = (new Random().nextDouble() - 0.5) * 0.5;
            double dy = (new Random().nextDouble() - 0.5) * 0.5;
            double dz = (new Random().nextDouble() - 0.5) * 0.5;
            if (level instanceof ServerLevel) {
                ServerLevel sv2 = (ServerLevel)level;
                sv2.sendParticles((ParticleOptions)CompanionsParticles.RESPAWN_TOTEM.get(), (double)t.getBlockPos().getX() + 0.5, (double)t.getBlockPos().getY() + 1.5 * Math.random(), (double)t.getBlockPos().getZ() + 0.5, 1, dx, dy, dz, 0.02);
            }
        }
        ++t.tickCount;
    }

    private static BlockPos findSpawn(ServerLevel level, BlockPos center, int radius) {
        for (int i = 0; i < 80; ++i) {
            int z;
            int y;
            int dx = new Random().nextInt(radius * 2 + 1) - radius;
            int dz = new Random().nextInt(radius * 2 + 1) - radius;
            int x = center.getX() + dx;
            BlockPos ret = new BlockPos(x, y = level.getHeight(Heightmap.Types.MOTION_BLOCKING, x, z = center.getZ() + dz), z);
            if (!level.getBlockState(ret).isAir() || !level.getBlockState(ret.above()).isAir()) continue;
            return ret;
        }
        return null;
    }

    private double getRingSpawnY(Level level, BlockPos basePos) {
        BlockPos below1 = basePos.below();
        if (!level.getBlockState(below1).isAir()) {
            int airCount;
            BlockPos below2 = below1.below();
            if (!level.getBlockState(below2).isAir()) {
                airCount = 0;
                for (Direction dir : Direction.Plane.HORIZONTAL) {
                    if (!level.getBlockState(below2.relative(dir)).isAir()) continue;
                    ++airCount;
                }
                if (airCount >= 3) {
                    return below2.getY();
                }
            }
            airCount = 0;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                if (!level.getBlockState(below1.relative(dir)).isAir()) continue;
                ++airCount;
            }
            if (airCount >= 3) {
                return below1.getY();
            }
        }
        return basePos.getY();
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public double getTick(Object o) {
        return RenderUtil.getCurrentTick();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate));
    }

    private <T extends GeoAnimatable> PlayState predicate(AnimationState<T> event) {
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private static /* synthetic */ void lambda$sync$1(Packet pkt, ServerPlayer p) {
        p.connection.send(pkt);
    }

    private static class RespawnData {
        CompoundTag nbt;
        long time;

        RespawnData(CompoundTag nbt, long time) {
            this.nbt = nbt;
            this.time = time;
        }
    }
}

