/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.blockentity;

import dev.xylonity.companions.common.block.AbstractTeslaBlock;
import dev.xylonity.companions.common.blockentity.AbstractTeslaBlockEntity;
import dev.xylonity.companions.common.tesla.behaviour.coil.CoilPulseBehaviour;
import dev.xylonity.companions.common.util.interfaces.ITeslaNodeBehaviour;
import dev.xylonity.companions.registry.CompanionsBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TeslaCoilBlockEntity
extends AbstractTeslaBlockEntity {
    private final ITeslaNodeBehaviour pulseBehaviour = new CoilPulseBehaviour();

    public TeslaCoilBlockEntity(BlockPos pos, BlockState state) {
        super(CompanionsBlockEntities.TESLA_COIL.get(), pos, state);
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos blockPos, BlockState blockState, T t) {
        if (level.isClientSide) {
            return;
        }
        if (!(t instanceof TeslaCoilBlockEntity)) {
            return;
        }
        TeslaCoilBlockEntity coil = (TeslaCoilBlockEntity)t;
        coil.pulseBehaviour.process(coil, level, blockPos, blockState);
        coil.defaultAttackBehaviour.process(coil, level, blockPos, blockState);
        coil.sync();
    }

    @Override
    @NotNull
    public Vec3 electricalChargeOriginOffset() {
        Direction dir = (Direction)this.getBlockState().getValue((Property)AbstractTeslaBlock.FACING);
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> new Vec3(0.0, 0.1, 0.0);
            case Direction.UP -> new Vec3(0.0, 0.9, 0.0);
            case Direction.NORTH -> new Vec3(0.0, 0.5, -0.5);
            case Direction.SOUTH -> new Vec3(0.0, 0.5, 0.5);
            case Direction.WEST -> new Vec3(-0.5, 0.5, 0.0);
            case Direction.EAST -> new Vec3(0.5, 0.5, 0.0);
        };
    }

    @Override
    @NotNull
    public Vec3 electricalChargeEndOffset() {
        Direction dir = (Direction)this.getBlockState().getValue((Property)AbstractTeslaBlock.FACING);
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> new Vec3(0.0, 0.1, 0.0);
            case Direction.UP -> new Vec3(0.0, 0.9, 0.0);
            case Direction.NORTH -> new Vec3(0.0, 0.5, -0.5);
            case Direction.SOUTH -> new Vec3(0.0, 0.5, 0.5);
            case Direction.WEST -> new Vec3(-0.5, 0.5, 0.0);
            case Direction.EAST -> new Vec3(0.5, 0.5, 0.0);
        };
    }
}

