/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.companions.common.container;

import dev.xylonity.companions.common.entity.companion.PuppetEntity;
import dev.xylonity.companions.common.item.PuppetArm;
import dev.xylonity.companions.registry.CompanionsMenuTypes;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PuppetContainerMenu
extends AbstractContainerMenu {
    private final PuppetEntity puppet;
    private final Container entityInventory;

    public PuppetContainerMenu(int windowId, Inventory playerInv, PuppetEntity puppet) {
        super(CompanionsMenuTypes.PUPPET_CONTAINER.get(), windowId);
        int col;
        this.puppet = puppet;
        this.entityInventory = puppet.inventory;
        PuppetContainerMenu.checkContainerSize((Container)this.entityInventory, (int)2);
        this.entityInventory.startOpen(playerInv.player);
        this.addSlot(new PartSlot(this.entityInventory, 0, 32, 80));
        this.addSlot(new PartSlot(this.entityInventory, 1, 128, 80));
        int PLAYER_INVENTORY_START_Y = 129;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 129 + row * 18));
            }
        }
        int HOTBAR_START_Y = 187;
        for (col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInv, col, 8 + col * 18, 187));
        }
    }

    public boolean stillValid(@NotNull Player player) {
        return this.entityInventory.stillValid(player) && this.puppet.isAlive() && this.puppet.distanceTo((Entity)player) < 8.0f;
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        this.entityInventory.stopOpen(player);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            itemstack = stackInSlot.copy();
            int containerSize = this.entityInventory.getContainerSize();
            if (index < containerSize ? !this.moveItemStackTo(stackInSlot, containerSize, this.slots.size(), true) : !this.moveItemStackTo(stackInSlot, 0, containerSize, false)) {
                return ItemStack.EMPTY;
            }
            if (stackInSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public static class PartSlot
    extends Slot {
        public PartSlot(Container container, int index, int x, int y) {
            super(container, index, x, y);
        }

        public boolean mayPlace(@NotNull ItemStack stack) {
            return stack.getItem() instanceof PuppetArm;
        }
    }
}

